/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.zzg;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public class zzp {
    @Nullable
    public static View zzg(@Nullable zzpb zzpb2) {
        if (zzpb2 == null) {
            zzpk.e((String)"AdState is null");
            return null;
        }
        if (zzp.zzh(zzpb2) && zzpb2.zzNH != null) {
            return zzpb2.zzNH.getView();
        }
        try {
            IObjectWrapper iObjectWrapper;
            IObjectWrapper iObjectWrapper2 = iObjectWrapper = zzpb2.zzLj != null ? zzpb2.zzLj.getView() : null;
            if (iObjectWrapper == null) {
                zzpk.zzbh((String)"View in mediation adapter is null.");
                return null;
            }
            return (View)zzd.zzF((IObjectWrapper)iObjectWrapper);
        }
        catch (RemoteException remoteException) {
            zzpk.zzc((String)"Could not get View from mediation adapter.", (Throwable)remoteException);
            return null;
        }
    }

    public static void zza(@Nullable zzpb zzpb2, zzg.zza zza2) {
        if (zzpb2 != null && zzp.zzh(zzpb2)) {
            View view;
            zzqw zzqw2 = zzpb2.zzNH;
            View view2 = view = zzqw2 != null ? zzqw2.getView() : null;
            if (view == null) {
                zzpk.zzbh((String)"AdWebView is null");
                return;
            }
            try {
                zzkf zzkf2;
                List<String> list;
                List<String> list2 = list = zzpb2.zzLi != null ? zzpb2.zzLi.zzKB : null;
                if (list == null || list.isEmpty()) {
                    zzpk.zzbh((String)"No template ids present in mediation response");
                    return;
                }
                zzke zzke2 = zzpb2.zzLj != null ? zzpb2.zzLj.zzhc() : null;
                zzkf zzkf3 = zzkf2 = zzpb2.zzLj != null ? zzpb2.zzLj.zzhd() : null;
                if (list.contains("2") && zzke2 != null) {
                    zzke2.zzm(zzd.zzA((Object)view));
                    if (!zzke2.getOverrideImpressionRecording()) {
                        zzke2.recordImpression();
                    }
                    zzqw2.zzlv().zza("/nativeExpressViewClicked", zzp.zza(zzke2, null, zza2));
                } else if (list.contains("1") && zzkf2 != null) {
                    zzkf2.zzm(zzd.zzA((Object)view));
                    if (!zzkf2.getOverrideImpressionRecording()) {
                        zzkf2.recordImpression();
                    }
                    zzqw2.zzlv().zza("/nativeExpressViewClicked", zzp.zza(null, zzkf2, zza2));
                } else {
                    zzpk.zzbh((String)"No matching template id and mapper");
                }
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Error occurred while recording impression and registering for clicks", (Throwable)remoteException);
                return;
            }
        }
    }

    public static boolean zza(zzqw zzqw2, zzjv zzjv2, CountDownLatch countDownLatch) {
        boolean bl = false;
        try {
            bl = zzp.zzb(zzqw2, zzjv2, countDownLatch);
        }
        catch (RemoteException remoteException) {
            zzpk.zzc((String)"Unable to invoke load assets", (Throwable)remoteException);
        }
        catch (RuntimeException runtimeException) {
            countDownLatch.countDown();
            throw runtimeException;
        }
        if (!bl) {
            countDownLatch.countDown();
        }
        return bl;
    }

    private static boolean zzb(zzqw zzqw2, zzjv zzjv2, CountDownLatch countDownLatch) throws RemoteException {
        Object object;
        View view = zzqw2.getView();
        if (view == null) {
            zzpk.zzbh((String)"AdWebView is null");
            return false;
        }
        view.setVisibility(4);
        List<String> list = zzjv2.zzLi.zzKB;
        if (list == null || list.isEmpty()) {
            zzpk.zzbh((String)"No template ids present in mediation response");
            return false;
        }
        zzp.zza(zzqw2, countDownLatch);
        zzke zzke2 = zzjv2.zzLj.zzhc();
        zzkf zzkf2 = zzjv2.zzLj.zzhd();
        if (list.contains("2") && zzke2 != null) {
            object = zzp.zza(zzke2);
            zzp.zza(zzqw2, (zzgv)object, zzjv2.zzLi.zzKA);
        } else if (list.contains("1") && zzkf2 != null) {
            object = zzp.zza(zzkf2);
            zzp.zza(zzqw2, (zzgw)object, zzjv2.zzLi.zzKA);
        } else {
            zzpk.zzbh((String)"No matching template id and mapper");
            return false;
        }
        object = zzjv2.zzLi.zzKy;
        String string2 = zzjv2.zzLi.zzKz;
        if (string2 != null) {
            zzqw2.loadDataWithBaseURL(string2, (String)object, "text/html", "UTF-8", null);
        } else {
            zzqw2.loadData((String)object, "text/html", "UTF-8");
        }
        return true;
    }

    public static boolean zzh(@Nullable zzpb zzpb2) {
        return zzpb2 != null && zzpb2.zzSn && zzpb2.zzLi != null && zzpb2.zzLi.zzKy != null;
    }

    private static zzgv zza(zzke zzke2) throws RemoteException {
        return new zzgv(zzke2.getHeadline(), zzke2.getImages(), zzke2.getBody(), zzke2.zzfQ(), zzke2.getCallToAction(), zzke2.getStarRating(), zzke2.getStore(), zzke2.getPrice(), null, zzke2.getExtras(), null, null);
    }

    private static zzgw zza(zzkf zzkf2) throws RemoteException {
        return new zzgw(zzkf2.getHeadline(), zzkf2.getImages(), zzkf2.getBody(), zzkf2.zzfV(), zzkf2.getCallToAction(), zzkf2.getAdvertiser(), null, zzkf2.getExtras(), null, null);
    }

    private static void zza(final zzqw zzqw2, final zzgv zzgv2, final String string2) {
        zzqw2.zzlv().zza(new zzqx.zza(){

            @Override
            public void zza(zzqw zzqw22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzgv2.getHeadline());
                    jSONObject.put("body", (Object)zzgv2.getBody());
                    jSONObject.put("call_to_action", (Object)zzgv2.getCallToAction());
                    jSONObject.put("price", (Object)zzgv2.getPrice());
                    jSONObject.put("star_rating", (Object)String.valueOf(zzgv2.getStarRating()));
                    jSONObject.put("store", (Object)zzgv2.getStore());
                    jSONObject.put("icon", (Object)zzp.zza(zzgv2.zzfQ()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzgv2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzhf zzhf2 = zzp.zze(e);
                            jSONArray.put((Object)zzp.zza(zzhf2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzp.zza(zzgv2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"2");
                    zzqw2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzpk.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(final zzqw zzqw2, final zzgw zzgw2, final String string2) {
        zzqw2.zzlv().zza(new zzqx.zza(){

            @Override
            public void zza(zzqw zzqw22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzgw2.getHeadline());
                    jSONObject.put("body", (Object)zzgw2.getBody());
                    jSONObject.put("call_to_action", (Object)zzgw2.getCallToAction());
                    jSONObject.put("advertiser", (Object)zzgw2.getAdvertiser());
                    jSONObject.put("logo", (Object)zzp.zza(zzgw2.zzfV()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzgw2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzhf zzhf2 = zzp.zze(e);
                            jSONArray.put((Object)zzp.zza(zzhf2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzp.zza(zzgw2.getExtras(), string2));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"1");
                    zzqw2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzpk.zzc((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(zzqw zzqw2, CountDownLatch countDownLatch) {
        zzqw2.zzlv().zza("/nativeExpressAssetsLoaded", zzp.zza(countDownLatch));
        zzqw2.zzlv().zza("/nativeExpressAssetsLoadingFailed", zzp.zzb(countDownLatch));
    }

    static zzid zza(final CountDownLatch countDownLatch) {
        return new zzid(){

            @Override
            public void zza(zzqw zzqw2, Map<String, String> map) {
                countDownLatch.countDown();
                zzqw2.getView().setVisibility(0);
            }
        };
    }

    static zzid zzb(final CountDownLatch countDownLatch) {
        return new zzid(){

            @Override
            public void zza(zzqw zzqw2, Map<String, String> map) {
                zzpk.zzbh((String)"Adapter returned an ad, but assets substitution failed");
                countDownLatch.countDown();
                zzqw2.destroy();
            }
        };
    }

    static zzid zza(final @Nullable zzke zzke2, final @Nullable zzkf zzkf2, final zzg.zza zza2) {
        return new zzid(){

            @Override
            public void zza(zzqw zzqw2, Map<String, String> map) {
                View view = zzqw2.getView();
                if (view == null) {
                    return;
                }
                try {
                    if (zzke2 != null) {
                        if (!zzke2.getOverrideClickHandling()) {
                            zzke2.zzl(zzd.zzA((Object)view));
                            zza2.onClick();
                        } else {
                            zzp.zza(zzqw2);
                        }
                    } else if (zzkf2 != null) {
                        if (!zzkf2.getOverrideClickHandling()) {
                            zzkf2.zzl(zzd.zzA((Object)view));
                            zza2.onClick();
                        } else {
                            zzp.zza(zzqw2);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    zzpk.zzc((String)"Unable to call handleClick on mapper", (Throwable)remoteException);
                }
            }
        };
    }

    private static void zza(zzqw zzqw2) {
        View.OnClickListener onClickListener = zzqw2.zzlK();
        if (onClickListener != null) {
            onClickListener.onClick(zzqw2.getView());
        }
    }

    private static JSONObject zza(@Nullable Bundle bundle, String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string2)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string2);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            Object object;
            String string3 = (String)iterator.next();
            if (!bundle.containsKey(string3)) continue;
            String string4 = jSONObject2.getString(string3);
            if ("image".equals(string4)) {
                object = bundle.get(string3);
                if (object instanceof Bitmap) {
                    String string5 = zzp.zza((Bitmap)object);
                    jSONObject.put(string3, (Object)string5);
                    continue;
                }
                zzpk.zzbh((String)"Invalid type. An image type extra should return a bitmap");
                continue;
            }
            object = bundle.get(string3);
            if (object instanceof Bitmap) {
                zzpk.zzbh((String)"Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string3, (Object)String.valueOf(bundle.get(string3)));
        }
        return jSONObject;
    }

    static String zza(@Nullable zzhf zzhf2) {
        if (zzhf2 == null) {
            zzpk.zzbh((String)"Image is null. Returning empty string");
            return "";
        }
        try {
            Uri uri = zzhf2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzpk.zzbh((String)"Unable to get image uri. Trying data uri next");
        }
        return zzp.zzb(zzhf2);
    }

    private static String zzb(zzhf zzhf2) {
        Drawable drawable2;
        IObjectWrapper iObjectWrapper;
        try {
            iObjectWrapper = zzhf2.zzfP();
            if (iObjectWrapper == null) {
                zzpk.zzbh((String)"Drawable is null. Returning empty string");
                return "";
            }
            drawable2 = (Drawable)zzd.zzF((IObjectWrapper)iObjectWrapper);
        }
        catch (RemoteException remoteException) {
            zzpk.zzbh((String)"Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            zzpk.zzbh((String)"Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        iObjectWrapper = (BitmapDrawable)drawable2;
        Bitmap bitmap = iObjectWrapper.getBitmap();
        return zzp.zza(bitmap);
    }

    private static String zza(@Nullable Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzpk.zzbh((String)"Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string2 = Base64.encodeToString((byte[])byArray, (int)0);
        String string3 = String.valueOf("data:image/png;base64,");
        String string4 = String.valueOf(string2);
        return string4.length() != 0 ? string3.concat(string4) : new String(string3);
    }

    @Nullable
    private static zzhf zze(Object object) {
        if (object instanceof IBinder) {
            return zzhf.zza.zzB((IBinder)((IBinder)object));
        }
        return null;
    }
}

