/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzqw;
import java.util.Map;
import org.json.JSONObject;

@zzme
public final class zzio
implements zzid {
    private boolean zzIv;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzel.zzeT().zzb(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzpk.zzbh((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public void zza(zzqw zzqw2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzpk.zzbh((String)"Action missing from video GMSG.");
            return;
        }
        if (zzpk.zzak((int)3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            String string3 = String.valueOf(object.toString());
            zzpk.zzbf((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Video GMSG: ").append(string2).append(" ").append(string3).toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzpk.zzbh((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object);
                zzqw2.setBackgroundColor(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzpk.zzbh((String)"Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzqw2.zzlD();
        if (object == null) {
            zzpk.zzbh((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzqw2.getContext();
            int n2 = zzio.zza(context, map, "x", 0);
            int n3 = zzio.zza(context, map, "y", 0);
            int n4 = zzio.zza(context, map, "w", -1);
            int n5 = zzio.zza(context, map, "h", -1);
            if (zzgd.zzEv.get().booleanValue()) {
                n4 = Math.min(n4, zzqw2.getMeasuredWidth() - n2);
                n5 = Math.min(n5, zzqw2.getMeasuredHeight() - n3);
            }
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzqv)object).zzlo() == null) {
                ((zzqv)object).zza(n2, n3, n4, n5, n, bl3);
            } else {
                ((zzqv)object).zze(n2, n3, n4, n5);
            }
        } else {
            zzl zzl2 = ((zzqv)object).zzlo();
            if (zzl2 == null) {
                zzl.zzi(zzqw2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzqw2.getContext();
                int n = zzio.zza(context, map, "x", 0);
                int n6 = zzio.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
                zzl2.zzf(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string4 = map.get("time");
                if (string4 == null) {
                    zzpk.zzbh((String)"Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    int n = (int)(f * 1000.0f);
                    zzl2.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzpk.zzbh((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                }
            } else if ("hide".equals(string2)) {
                zzl2.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzl2.zzib();
            } else if ("muted".equals(string2)) {
                boolean bl4 = Boolean.parseBoolean(map.get("muted"));
                if (bl4) {
                    zzl2.zzhZ();
                } else {
                    zzl2.zzia();
                }
            } else if ("pause".equals(string2)) {
                zzl2.pause();
            } else if ("play".equals(string2)) {
                zzl2.play();
            } else if ("show".equals(string2)) {
                zzl2.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzl2.zzaC(map.get("src"));
            } else if ("touchMove".equals(string2)) {
                Context context = zzqw2.getContext();
                int n = zzio.zza(context, map, "dx", 0);
                int n7 = zzio.zza(context, map, "dy", 0);
                zzl2.zza(n, n7);
                if (!this.zzIv) {
                    zze zze2 = zzqw2.zzlt();
                    zze2.zzhL();
                    this.zzIv = true;
                }
            } else if ("volume".equals(string2)) {
                String string6 = map.get("volume");
                if (string6 == null) {
                    zzpk.zzbh((String)"Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string6);
                    zzl2.zzb(f);
                }
                catch (NumberFormatException numberFormatException) {
                    String string7 = String.valueOf(string6);
                    zzpk.zzbh((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                }
            } else if ("watermark".equals(string2)) {
                zzl2.zzic();
            } else {
                String string8 = String.valueOf(string2);
                zzpk.zzbh((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
            }
        }
    }
}

