/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzme;
import java.util.Locale;

@zzme
public final class zzni {
    public final int zzUE;
    public final boolean zzUF;
    public final boolean zzUG;
    public final String zzUH;
    public final String zzUI;
    public final boolean zzUJ;
    public final boolean zzUK;
    public final boolean zzUL;
    public final boolean zzUM;
    public final String zzUN;
    public final String zzUO;
    public final int zzUP;
    public final int zzUQ;
    public final int zzUR;
    public final int zzUS;
    public final int zzUT;
    public final int zzUU;
    public final float zzxk;
    public final int zzRH;
    public final int zzRI;
    public final double zzUV;
    public final boolean zzUW;
    public final boolean zzUX;
    public final int zzUY;
    public final String zzUZ;
    public final boolean zzVa;

    zzni(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6, boolean bl9) {
        this.zzUE = n;
        this.zzUF = bl;
        this.zzUG = bl2;
        this.zzUH = string2;
        this.zzUI = string3;
        this.zzUJ = bl3;
        this.zzUK = bl4;
        this.zzUL = bl5;
        this.zzUM = bl6;
        this.zzUN = string4;
        this.zzUO = string5;
        this.zzUP = n2;
        this.zzUQ = n3;
        this.zzUR = n4;
        this.zzUS = n5;
        this.zzUT = n6;
        this.zzUU = n7;
        this.zzxk = f;
        this.zzRH = n8;
        this.zzRI = n9;
        this.zzUV = d;
        this.zzUW = bl7;
        this.zzUX = bl8;
        this.zzUY = n10;
        this.zzUZ = string6;
        this.zzVa = bl9;
    }

    public static final class zza {
        private int zzUE;
        private boolean zzUL;
        private boolean zzUM;
        private int zzUP;
        private int zzUT;
        private int zzUU;
        private String zzUH;
        private int zzUQ;
        private int zzUR;
        private int zzUS;
        private boolean zzUX;
        private int zzUY;
        private double zzUV;
        private boolean zzUW;
        private String zzUZ;
        private boolean zzUF;
        private boolean zzUG;
        private String zzUI;
        private boolean zzUJ;
        private boolean zzUK;
        private String zzUN;
        private String zzUO;
        private float zzxk;
        private int zzRH;
        private int zzRI;
        private boolean zzVa;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzw(context);
            this.zzx(context);
            this.zzy(context);
            Locale locale = Locale.getDefault();
            this.zzUF = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzUG = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzUI = locale.getCountry();
            this.zzUJ = zzel.zzeT().zzli();
            this.zzUK = zzj.zzbb((Context)context);
            this.zzUN = locale.getLanguage();
            this.zzUO = zza.zza(context, packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzxk = displayMetrics.density;
            this.zzRH = displayMetrics.widthPixels;
            this.zzRI = displayMetrics.heightPixels;
        }

        public zza(Context context, zzni zzni2) {
            context.getPackageManager();
            this.zzw(context);
            this.zzx(context);
            this.zzy(context);
            this.zzz(context);
            this.zzUF = zzni2.zzUF;
            this.zzUG = zzni2.zzUG;
            this.zzUI = zzni2.zzUI;
            this.zzUJ = zzni2.zzUJ;
            this.zzUK = zzni2.zzUK;
            this.zzUN = zzni2.zzUN;
            this.zzUO = zzni2.zzUO;
            this.zzxk = zzni2.zzxk;
            this.zzRH = zzni2.zzRH;
            this.zzRI = zzni2.zzRI;
        }

        private void zzw(Context context) {
            AudioManager audioManager = zzw.zzcM().zzR(context);
            if (audioManager != null) {
                try {
                    this.zzUE = audioManager.getMode();
                    this.zzUL = audioManager.isMusicActive();
                    this.zzUM = audioManager.isSpeakerphoneOn();
                    this.zzUP = audioManager.getStreamVolume(3);
                    this.zzUT = audioManager.getRingerMode();
                    this.zzUU = audioManager.getStreamVolume(2);
                    return;
                }
                catch (Throwable throwable) {
                    zzw.zzcQ().zza(throwable, "DeviceInfo.gatherAudioInfo");
                }
            }
            this.zzUE = -2;
            this.zzUL = false;
            this.zzUM = false;
            this.zzUP = 0;
            this.zzUT = 0;
            this.zzUU = 0;
        }

        @TargetApi(value=16)
        private void zzx(Context context) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzUH = telephonyManager.getNetworkOperator();
            this.zzUR = telephonyManager.getNetworkType();
            this.zzUS = telephonyManager.getPhoneType();
            this.zzUQ = -2;
            this.zzUX = false;
            this.zzUY = -1;
            if (zzw.zzcM().zze(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzUQ = networkInfo.getType();
                    this.zzUY = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzUQ = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzUX = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzy(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzUV = (float)n2 / (float)n3;
                this.zzUW = n == 2 || n == 5;
            } else {
                this.zzUV = -1.0;
                this.zzUW = false;
            }
        }

        private void zzz(Context context) {
            this.zzUZ = Build.FINGERPRINT;
            this.zzVa = zzgr.zzo(context);
        }

        private static String zza(Context context, PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                String string2;
                PackageInfo packageInfo = zzadg.zzbi((Context)context).getPackageInfo(activityInfo.packageName, 0);
                if (packageInfo != null) {
                    int n = packageInfo.versionCode;
                    String string3 = String.valueOf(activityInfo.packageName);
                    string2 = new StringBuilder(12 + String.valueOf(string3).length()).append(n).append(".").append(string3).toString();
                } else {
                    string2 = null;
                }
                return string2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zzni zzjC() {
            return new zzni(this.zzUE, this.zzUF, this.zzUG, this.zzUH, this.zzUI, this.zzUJ, this.zzUK, this.zzUL, this.zzUM, this.zzUN, this.zzUO, this.zzUP, this.zzUQ, this.zzUR, this.zzUS, this.zzUT, this.zzUU, this.zzxk, this.zzRH, this.zzRI, this.zzUV, this.zzUW, this.zzUX, this.zzUY, this.zzUZ, this.zzVa);
        }
    }
}

