/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.webkit.CookieManager;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzd;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.ads.internal.zzx;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzar;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzjs;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.internal.zzle;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmr;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpn;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqw;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;

@zzme
public abstract class zzb
extends zza
implements zzh,
zzj,
zzu,
zzif,
zzjs {
    protected final zzka zzsz;
    protected transient boolean zzsA;

    public zzb(Context context, zzeg zzeg2, String string2, zzka zzka2, zzqh zzqh2, zze zze2) {
        this(new zzx(context, zzeg2, string2, zzqh2), zzka2, null, zze2);
    }

    protected zzb(zzx zzx2, zzka zzka2, @Nullable zzt zzt2, zze zze2) {
        super(zzx2, zzt2, zze2);
        this.zzsz = zzka2;
        this.zzsA = false;
    }

    @Override
    public boolean zza(zzec zzec2, zzgl zzgl2) {
        if (!this.zzbM()) {
            return false;
        }
        Bundle bundle = zzw.zzcM().zzV(this.zzss.zzqn);
        this.zzsr.cancel();
        this.zzss.zzvO = 0;
        zzpd zzpd2 = null;
        if (zzgd.zzEJ.get().booleanValue()) {
            zzpd2 = zzw.zzcQ().zzkw();
            zzw.zzdi().zza(this.zzss.zzqn, this.zzss.zzvn, this.zzss.zzvl, zzpd2);
        }
        zzmk.zza zza2 = this.zza(zzec2, bundle, zzpd2);
        zzgl2.zzh("seq_num", zza2.zzRB);
        zzgl2.zzh("request_id", zza2.zzRL);
        zzgl2.zzh("session_id", zza2.zzRC);
        if (zza2.zzRz != null) {
            zzgl2.zzh("app_version", String.valueOf(zza2.zzRz.versionCode));
        }
        this.zzss.zzvp = zzw.zzcI().zza(this.zzss.zzqn, zza2, this);
        return true;
    }

    @Override
    public void zzb(zzpb zzpb2) {
        super.zzb(zzpb2);
        if (zzpb2.zzLi != null) {
            zzpk.zzbf((String)"Disable the debug gesture detector on the mediation ad frame.");
            if (this.zzss.zzvo != null) {
                this.zzss.zzvo.zzdy();
            }
            zzpk.zzbf((String)"Pinging network fill URLs.");
            zzw.zzdf().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, zzpb2, this.zzss.zzvl, false, zzpb2.zzLi.zzKu);
            if (zzpb2.zzWc != null && zzpb2.zzWc.zzKI != null && zzpb2.zzWc.zzKI.size() > 0) {
                zzpk.zzbf((String)"Pinging urls remotely");
                zzw.zzcM().zza(this.zzss.zzqn, zzpb2.zzWc.zzKI);
            }
        } else {
            zzpk.zzbf((String)"Enable the debug gesture detector on the admob ad frame.");
            if (this.zzss.zzvo != null) {
                this.zzss.zzvo.zzdx();
            }
        }
        if (zzpb2.errorCode == 3 && zzpb2.zzWc != null && zzpb2.zzWc.zzKH != null) {
            zzpk.zzbf((String)"Pinging no fill URLs.");
            zzw.zzdf().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, zzpb2, this.zzss.zzvl, false, zzpb2.zzWc.zzKH);
        }
    }

    @Override
    protected boolean zza(@Nullable zzpb zzpb2, zzpb zzpb3) {
        if (zzpb2 != null && zzpb2.zzLl != null) {
            zzpb2.zzLl.zza((zzjs)null);
        }
        if (zzpb3.zzLl != null) {
            zzpb3.zzLl.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzpb3.zzWc != null) {
            n = zzpb3.zzWc.zzKS;
            n2 = zzpb3.zzWc.zzKT;
        }
        this.zzss.zzvM.zzk(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzss.zzvs == null) {
            zzpk.zzbh((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzss.zzvs.zzWc != null && this.zzss.zzvs.zzWc.zzKF != null) {
            String string2 = zzw.zzdl().zzF(this.zzss.zzqn);
            zzw.zzdf().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, this.zzss.zzvs, this.zzss.zzvl, false, this.zza(string2, this.zzss.zzvs.zzWc.zzKF));
            if (this.zzss.zzvs.zzWc.zzKF.size() > 0) {
                zzw.zzdl().zzf(this.zzss.zzqn, string2);
            }
        }
        if (this.zzss.zzvs.zzLi != null && this.zzss.zzvs.zzLi.zzKs != null) {
            zzw.zzdf().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, this.zzss.zzvs, this.zzss.zzvl, false, this.zzss.zzvs.zzLi.zzKs);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzpb zzpb2) {
        zzec zzec2;
        boolean bl = false;
        if (this.zzst != null) {
            zzec2 = this.zzst;
            this.zzst = null;
        } else {
            zzec2 = zzpb2.zzRy;
            bl = zzec2.extras != null ? zzec2.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(zzec2, zzpb2, bl);
    }

    protected boolean zza(zzec zzec2, zzpb zzpb2, boolean bl) {
        if (!bl && this.zzss.zzdq()) {
            if (zzpb2.zzKL > 0L) {
                this.zzsr.zza(zzec2, zzpb2.zzKL);
            } else if (zzpb2.zzWc != null && zzpb2.zzWc.zzKL > 0L) {
                this.zzsr.zza(zzec2, zzpb2.zzWc.zzKL);
            } else if (!zzpb2.zzSn && zzpb2.errorCode == 2) {
                this.zzsr.zzh(zzec2);
            }
        }
        return this.zzsr.zzcy();
    }

    @Override
    public void pause() {
        zzac.zzdj((String)"pause must be called on the main UI thread.");
        if (this.zzss.zzvs != null && this.zzss.zzvs.zzNH != null && this.zzss.zzdq()) {
            zzw.zzcO().zzl(this.zzss.zzvs.zzNH);
        }
        if (this.zzss.zzvs != null && this.zzss.zzvs.zzLj != null) {
            try {
                this.zzss.zzvs.zzLj.pause();
            }
            catch (RemoteException remoteException) {
                zzpk.zzbh((String)"Could not pause mediation adapter.");
            }
        }
        this.zzsu.zzl(this.zzss.zzvs);
        this.zzsr.pause();
    }

    @Override
    public void resume() {
        zzac.zzdj((String)"resume must be called on the main UI thread.");
        zzqw zzqw2 = null;
        if (this.zzss.zzvs != null && this.zzss.zzvs.zzNH != null) {
            zzqw2 = this.zzss.zzvs.zzNH;
        }
        if (zzqw2 != null && this.zzss.zzdq()) {
            zzw.zzcO().zzm(this.zzss.zzvs.zzNH);
        }
        if (this.zzss.zzvs != null && this.zzss.zzvs.zzLj != null) {
            try {
                this.zzss.zzvs.zzLj.resume();
            }
            catch (RemoteException remoteException) {
                zzpk.zzbh((String)"Could not resume mediation adapter.");
            }
        }
        if (zzqw2 == null || !zzqw2.zzlC()) {
            this.zzsr.resume();
        }
        this.zzsu.zzm(this.zzss.zzvs);
    }

    @Override
    protected boolean zzc(zzec zzec2) {
        return super.zzc(zzec2) && !this.zzsA;
    }

    protected boolean zzbM() {
        boolean bl = true;
        if (!zzw.zzcM().zze(this.zzss.zzqn, this.zzss.zzqn.getPackageName(), "android.permission.INTERNET") || !zzw.zzcM().zzJ(this.zzss.zzqn)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzbN() {
        this.zzsu.zzj(this.zzss.zzvs);
        this.zzsA = false;
        this.zzbG();
        this.zzss.zzvu.zzjX();
    }

    @Override
    public void zzbO() {
        this.zzsA = true;
        this.zzbI();
    }

    @Override
    public void onPause() {
        this.zzsu.zzl(this.zzss.zzvs);
    }

    @Override
    public void onResume() {
        this.zzsu.zzm(this.zzss.zzvs);
    }

    @Override
    public void zzbP() {
        this.onAdClicked();
    }

    @Override
    public void zzbQ() {
        this.zzbN();
    }

    @Override
    public void zzbR() {
        this.zzbD();
    }

    @Override
    public void zzbS() {
        this.zzbO();
    }

    @Override
    public void zzbT() {
        if (this.zzss.zzvs != null) {
            String string2 = this.zzss.zzvs.zzLk;
            zzpk.zzbh((String)new StringBuilder(74 + String.valueOf(string2).length()).append("Mediation adapter ").append(string2).append(" refreshed, but mediation adapters should never refresh.").toString());
        }
        this.zza(this.zzss.zzvs, true);
        this.zzbJ();
    }

    @Override
    public void zzbU() {
        this.recordImpression();
    }

    private zzmk.zza zza(zzec zzec2, Bundle bundle, zzpd zzpd2) {
        int n;
        Object object;
        PackageInfo packageInfo;
        ApplicationInfo applicationInfo = this.zzss.zzqn.getApplicationInfo();
        try {
            packageInfo = zzadg.zzbi((Context)this.zzss.zzqn).getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        DisplayMetrics displayMetrics = this.zzss.zzqn.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzss.zzvo != null && this.zzss.zzvo.getParent() != null) {
            object = new int[2];
            this.zzss.zzvo.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzss.zzvo.getWidth();
            int n3 = this.zzss.zzvo.getHeight();
            int n4 = 0;
            if (this.zzss.zzvo.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= displayMetrics.widthPixels && object3 <= displayMetrics.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzw.zzcQ().zzki();
        this.zzss.zzvu = new zzpc((String)object, this.zzss.zzvl);
        this.zzss.zzvu.zzs(zzec2);
        String string2 = zzw.zzcM().zza(this.zzss.zzqn, (View)this.zzss.zzvo, this.zzss.zzvr);
        long l = 0L;
        if (this.zzss.zzvy != null) {
            try {
                l = this.zzss.zzvy.getValue();
            }
            catch (RemoteException remoteException) {
                zzpk.zzbh((String)"Cannot get correlation id, default to 0.");
            }
        }
        String string3 = UUID.randomUUID().toString();
        Bundle bundle3 = zzw.zzcQ().zza(this.zzss.zzqn, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzss.zzvE.size(); n += 1) {
            arrayList.add((String)this.zzss.zzvE.keyAt(n));
        }
        n = this.zzss.zzvz != null ? 1 : 0;
        boolean bl = this.zzss.zzvA != null && zzw.zzcQ().zzkz();
        final zzqm<Boolean> zzqm2 = zzpn.zza(new Callable<Boolean>(){

            public Boolean zzbX() {
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbX();
            }
        });
        zzqm<String> zzqm3 = zzpn.zza(new Callable<String>(){

            public String zzbY() {
                CookieManager cookieManager;
                String string2 = "";
                if (zzgd.zzFb.get().booleanValue() && (cookieManager = zzw.zzcO().zzX(zzb.this.zzss.zzqn)) != null) {
                    string2 = cookieManager.getCookie("googleads.g.doubleclick.net");
                }
                return string2;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbY();
            }
        });
        zzqm<String> zzqm4 = zzpn.zza(new Callable<String>(){

            public String zzbY() {
                zzar zzar2 = zzb.this.zzss.zzvm.zzT();
                return zzar2.zzb(zzb.this.zzss.zzqn);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbY();
            }
        });
        String string4 = null;
        if (zzpd2 != null) {
            string4 = zzpd2.zzkd();
        }
        final zzqj<zzmr> zzqj2 = new zzqj<zzmr>();
        zzqm2.zzc(new Runnable(this, n != 0, bl){
            final /* synthetic */ boolean zzsE;
            final /* synthetic */ boolean zzsF;
            {
                this.zzsE = bl;
                this.zzsF = bl2;
            }

            @Override
            public void run() {
                boolean bl = false;
                try {
                    bl = zzqm2.isDone() ? (Boolean)zzqm2.get() : false;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    zzpk.zzb((String)"Error receiving app streaming support", (Throwable)exception);
                }
                zzqj2.zzh(new zzmr(this.zzsE, this.zzsF, bl));
            }
        });
        return new zzmk.zza(bundle2, zzec2, this.zzss.zzvr, this.zzss.zzvl, applicationInfo, packageInfo, (String)object, zzw.zzcQ().getSessionId(), this.zzss.zzvn, bundle3, this.zzss.zzvK, arrayList, bundle, zzw.zzcQ().zzkm(), displayMetrics.widthPixels, displayMetrics.heightPixels, displayMetrics.density, string2, l, string3, zzgd.zzfs(), this.zzss.zzvk, this.zzss.zzvF, zzqj2, this.zzss.zzdu(), zzw.zzcM().zzcq(), zzw.zzcM().zzcs(), zzw.zzcM().zzT(this.zzss.zzqn), zzw.zzcM().zzs((View)this.zzss.zzvo), this.zzss.zzqn instanceof Activity, zzw.zzcQ().zzkr(), zzqm3, string4, zzw.zzcQ().zzkv(), zzw.zzdj().zzgr(), zzw.zzcM().zzkP(), zzw.zzcU().zzkY(), this.zzss.zzvH, zzw.zzcU().zzkZ(), zzjc.zzgC().asBundle(), zzw.zzcQ().zzm(this.zzss.zzqn, this.zzss.zzvl), zzqm4);
    }

    @Override
    public void zza(zzle zzle2) {
        zzac.zzdj((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzss.zzvz = zzle2;
    }

    @Override
    public void zza(zzli zzli2, @Nullable String string2) {
        zzac.zzdj((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzss.zzvL = new zzk(string2);
        this.zzss.zzvA = zzli2;
        if (!zzw.zzcQ().zzkl() && zzli2 != null) {
            new zzc(this.zzss.zzqn, this.zzss.zzvA, this.zzss.zzvL).zziP();
        }
    }

    @Override
    public void zza(String string2, ArrayList<String> arrayList) {
        zzd zzd2 = new zzd(string2, arrayList, this.zzss.zzqn, this.zzss.zzvn.zzba);
        if (this.zzss.zzvz == null) {
            zzpk.zzbh((String)"InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzel.zzeT().zzaf(this.zzss.zzqn)) {
                zzpk.zzbh((String)"Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzss.zzvA == null) {
                zzpk.zzbh((String)"PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzss.zzvL == null) {
                zzpk.zzbh((String)"PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzss.zzvP) {
                zzpk.zzbh((String)"An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzss.zzvP = true;
            try {
                if (!this.zzss.zzvA.isValidPurchase(string2)) {
                    this.zzss.zzvP = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                zzpk.zzbh((String)"Could not start In-App purchase.");
                this.zzss.zzvP = false;
                return;
            }
            zzw.zzda().zza(this.zzss.zzqn, this.zzss.zzvn.zzYY, new GInAppPurchaseManagerInfoParcel(this.zzss.zzqn, this.zzss.zzvL, (zzld)zzd2, this));
        } else {
            try {
                this.zzss.zzvz.zza((zzld)zzd2);
            }
            catch (RemoteException remoteException) {
                zzpk.zzbh((String)"Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string2, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzss.zzvA != null) {
                this.zzss.zzvA.zza((zzlh)new zzg(this.zzss.zzqn, string2, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            zzpk.zzbh((String)"Fail to invoke PlayStorePurchaseListener.");
        }
        zzpo.zzXC.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzw.zzda().zzd(intent);
                zzw.zzda();
                if (n == 0 && zzb.this.zzss.zzvs != null && zzb.this.zzss.zzvs.zzNH != null && zzb.this.zzss.zzvs.zzNH.zzlt() != null) {
                    zzb.this.zzss.zzvs.zzNH.zzlt().close();
                }
                zzb.this.zzss.zzvP = false;
            }
        }, 500L);
    }

    public void recordImpression() {
        this.zza(this.zzss.zzvs, false);
    }

    protected void zza(@Nullable zzpb zzpb2, boolean bl) {
        if (zzpb2 == null) {
            zzpk.zzbh((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzpb2);
        if (zzpb2.zzWc != null && zzpb2.zzWc.zzKG != null) {
            String string2 = zzw.zzdl().zzF(this.zzss.zzqn);
            zzw.zzdf().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, zzpb2, this.zzss.zzvl, bl, this.zza(string2, zzpb2.zzWc.zzKG));
            if (zzpb2.zzWc.zzKG.size() > 0) {
                zzw.zzdl().zzg(this.zzss.zzqn, string2);
            }
        }
        if (zzpb2.zzLi != null && zzpb2.zzLi.zzKt != null) {
            zzw.zzdf().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, zzpb2, this.zzss.zzvl, bl, zzpb2.zzLi.zzKt);
        }
    }

    public String getMediationAdapterClassName() {
        if (this.zzss.zzvs == null) {
            return null;
        }
        return this.zzss.zzvs.zzLk;
    }

    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }

    @Override
    public void zzbV() {
        zzw.zzcM().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzsr.pause();
            }
        });
    }

    @Override
    public void zzbW() {
        zzw.zzcM().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzsr.resume();
            }
        });
    }
}

