/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzag;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzbd;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbf;
import com.google.android.gms.internal.zzbh;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbj;
import com.google.android.gms.internal.zzbk;
import com.google.android.gms.internal.zzbl;
import com.google.android.gms.internal.zzbm;
import com.google.android.gms.internal.zzbn;
import com.google.android.gms.internal.zzbp;
import com.google.android.gms.internal.zzbq;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzbu;
import com.google.android.gms.internal.zzbv;
import com.google.android.gms.internal.zzbw;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzgd;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class zzau
extends zzas {
    protected static final Object zzpS = new Object();
    private static final String TAG = zzau.class.getSimpleName();
    protected static volatile zzbd zzpz = null;
    static boolean zzpT = false;
    private static long startTime = 0L;
    protected boolean zzpU = false;
    protected String zzpV;
    protected boolean zzpW = false;
    protected boolean zzpX = false;

    protected static synchronized void zza(Context context, boolean bl) {
        if (!zzpT) {
            startTime = zzbf.zzbb() / 1000L;
            zzpz = zzau.zzb(context, bl);
            zzpT = true;
        }
    }

    protected zzau(Context context, String string2, boolean bl) {
        super(context);
        this.zzpV = string2;
        this.zzpU = bl;
    }

    protected zzau(Context context, String string2) {
        super(context);
        this.zzpV = string2;
        this.zzpU = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static zzbd zzb(Context context, boolean bl) {
        if (zzpz == null) {
            Object object = zzpS;
            synchronized (object) {
                if (zzpz == null) {
                    zzbd zzbd2 = zzbd.zza(context, zzaz.getKey(), zzaz.zzV(), bl);
                    zzau.zza(zzbd2);
                    zzpz = zzbd2;
                }
            }
        }
        return zzpz;
    }

    private static void zza(zzbd zzbd2) {
        List<Class> list = Collections.singletonList(Context.class);
        zzbd2.zza(zzaz.zzai(), zzaz.zzaj(), list);
        zzbd2.zza(zzaz.zzas(), zzaz.zzat(), list);
        zzbd2.zza(zzaz.zzaq(), zzaz.zzar(), list);
        zzbd2.zza(zzaz.zzac(), zzaz.zzad(), list);
        zzbd2.zza(zzaz.zzam(), zzaz.zzan(), list);
        zzbd2.zza(zzaz.zzW(), zzaz.zzX(), list);
        zzbd2.zza(zzaz.zzaE(), zzaz.zzaF(), list);
        zzbd2.zza(zzaz.zzY(), zzaz.zzZ(), list);
        List<Class> list2 = Arrays.asList(MotionEvent.class, DisplayMetrics.class);
        zzbd2.zza(zzaz.zzaC(), zzaz.zzaD(), list2);
        zzbd2.zza(zzaz.zzaA(), zzaz.zzaB(), list2);
        zzbd2.zza(zzaz.zzag(), zzaz.zzah(), Collections.emptyList());
        zzbd2.zza(zzaz.zzay(), zzaz.zzaz(), Collections.emptyList());
        zzbd2.zza(zzaz.zzao(), zzaz.zzap(), Collections.emptyList());
        zzbd2.zza(zzaz.zzae(), zzaz.zzaf(), Collections.emptyList());
        zzbd2.zza(zzaz.zzak(), zzaz.zzal(), Collections.emptyList());
        zzbd2.zza(zzaz.zzaw(), zzaz.zzax(), Collections.emptyList());
        List<Class> list3 = Arrays.asList(Context.class, Boolean.TYPE);
        zzbd2.zza(zzaz.zzaa(), zzaz.zzab(), list3);
        List<Class> list4 = Arrays.asList(StackTraceElement[].class);
        zzbd2.zza(zzaz.zzau(), zzaz.zzav(), list4);
        List<Class> list5 = Arrays.asList(View.class);
        zzbd2.zza(zzaz.zzaG(), zzaz.zzaH(), list5);
    }

    static zzbe zza(zzbd zzbd2, MotionEvent motionEvent, DisplayMetrics displayMetrics) throws zzba {
        Method method = zzbd2.zzc(zzaz.zzaC(), zzaz.zzaD());
        if (method == null || motionEvent == null) {
            throw new zzba();
        }
        try {
            zzbe zzbe2 = new zzbe((String)method.invoke(null, motionEvent, displayMetrics));
            return zzbe2;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new zzba(reflectiveOperationException);
        }
    }

    @Override
    protected zzag.zza zza(Context context, zzae.zza zza2) {
        zzag.zza zza3 = new zzag.zza();
        if (!TextUtils.isEmpty((CharSequence)this.zzpV)) {
            zza3.zzba = this.zzpV;
        }
        zzbd zzbd2 = zzau.zzb(context, this.zzpU);
        zzbd2.zzaZ();
        this.zza(zzbd2, zza3, zza2);
        zzbd2.zzba();
        return zza3;
    }

    @Override
    protected zzag.zza zza(Context context, View view) {
        zzag.zza zza2 = new zzag.zza();
        if (!TextUtils.isEmpty((CharSequence)this.zzpV)) {
            zza2.zzba = this.zzpV;
        }
        zzbd zzbd2 = zzau.zzb(context, this.zzpU);
        zzbd2.zzaZ();
        this.zzb(zzbd2, zza2, view);
        zzbd2.zzba();
        return zza2;
    }

    protected List<Callable<Void>> zzb(zzbd zzbd2, zzag.zza zza2, zzae.zza zza3) {
        int n = zzbd2.zzQ();
        ArrayList<Callable<Void>> arrayList = new ArrayList<Callable<Void>>();
        arrayList.add(new zzbk(zzbd2, zzaz.zzaa(), zzaz.zzab(), zza2, n, 27, zza3));
        arrayList.add(new zzbn(zzbd2, zzaz.zzag(), zzaz.zzah(), zza2, startTime, n, 25));
        arrayList.add(new zzbs(zzbd2, zzaz.zzao(), zzaz.zzap(), zza2, n, 1));
        arrayList.add(new zzbt(zzbd2, zzaz.zzaq(), zzaz.zzar(), zza2, n, 31));
        arrayList.add(new zzbw(zzbd2, zzaz.zzay(), zzaz.zzaz(), zza2, n, 33));
        arrayList.add(new zzbj(zzbd2, zzaz.zzas(), zzaz.zzat(), zza2, n, 29));
        arrayList.add(new zzbl(zzbd2, zzaz.zzac(), zzaz.zzad(), zza2, n, 5));
        arrayList.add(new zzbr(zzbd2, zzaz.zzam(), zzaz.zzan(), zza2, n, 12));
        arrayList.add(new zzbh(zzbd2, zzaz.zzW(), zzaz.zzX(), zza2, n, 3));
        arrayList.add(new zzbm(zzbd2, zzaz.zzae(), zzaz.zzaf(), zza2, n, 44));
        arrayList.add(new zzbq(zzbd2, zzaz.zzak(), zzaz.zzal(), zza2, n, 22));
        arrayList.add(new zzbx(zzbd2, zzaz.zzaE(), zzaz.zzaF(), zza2, n, 48));
        if (zzgd.zzDQ.get().booleanValue()) {
            arrayList.add(new zzbi(zzbd2, zzaz.zzY(), zzaz.zzZ(), zza2, n, 49));
        }
        arrayList.add(new zzbv(zzbd2, zzaz.zzaw(), zzaz.zzax(), zza2, n, 51));
        return arrayList;
    }

    protected List<Callable<Void>> zza(zzbd zzbd2, zzag.zza zza2, View view) {
        ArrayList<Callable<Void>> arrayList = new ArrayList<Callable<Void>>();
        ExecutorService executorService = zzbd2.zzaI();
        if (executorService == null) {
            return arrayList;
        }
        int n = zzbd2.zzQ();
        arrayList.add(new zzbp(zzbd2, zza2));
        arrayList.add(new zzbs(zzbd2, zzaz.zzao(), zzaz.zzap(), zza2, n, 1));
        arrayList.add(new zzbn(zzbd2, zzaz.zzag(), zzaz.zzah(), zza2, startTime, n, 25));
        arrayList.add(new zzbm(zzbd2, zzaz.zzae(), zzaz.zzaf(), zza2, n, 44));
        arrayList.add(new zzbh(zzbd2, zzaz.zzW(), zzaz.zzX(), zza2, n, 3));
        arrayList.add(new zzbq(zzbd2, zzaz.zzak(), zzaz.zzal(), zza2, n, 22));
        arrayList.add(new zzbl(zzbd2, zzaz.zzac(), zzaz.zzad(), zza2, n, 5));
        arrayList.add(new zzbx(zzbd2, zzaz.zzaE(), zzaz.zzaF(), zza2, n, 48));
        if (zzgd.zzDR.get().booleanValue()) {
            arrayList.add(new zzbi(zzbd2, zzaz.zzY(), zzaz.zzZ(), zza2, n, 49));
        }
        arrayList.add(new zzbv(zzbd2, zzaz.zzaw(), zzaz.zzax(), zza2, n, 51));
        arrayList.add(new zzbu(zzbd2, zzaz.zzau(), zzaz.zzav(), zza2, n, 45, new Throwable().getStackTrace()));
        if (zzgd.zzDS.get().booleanValue()) {
            arrayList.add(new zzby(zzbd2, zzaz.zzaG(), zzaz.zzaH(), zza2, n, 57, view));
        }
        return arrayList;
    }

    protected void zza(zzbd zzbd2, zzag.zza zza2, zzae.zza zza3) {
        ExecutorService executorService = zzbd2.zzaI();
        if (executorService == null) {
            return;
        }
        List<Callable<Void>> list = this.zzb(zzbd2, zza2, zza3);
        this.zza(list);
    }

    protected void zzb(zzbd zzbd2, zzag.zza zza2, View view) {
        this.zza(zzbd2, zza2);
        List<Callable<Void>> list = this.zza(zzbd2, zza2, view);
        this.zza(list);
    }

    private void zza(zzbd zzbd2, zzag.zza zza2) {
        try {
            zzbe zzbe2 = zzau.zza(zzbd2, this.zzpF, this.zzpQ);
            zza2.zzbn = zzbe2.zzqI;
            zza2.zzbo = zzbe2.zzqJ;
            zza2.zzbp = zzbe2.zzqK;
            if (this.zzpP) {
                zza2.zzbB = zzbe2.zzcf;
                zza2.zzbC = zzbe2.zzcd;
            }
            zzag.zza.zza zza3 = new zzag.zza.zza();
            zzbe2 = this.zzb(this.zzpF);
            zza3.zzbn = zzbe2.zzqI;
            zza3.zzbo = zzbe2.zzqJ;
            zza3.zzci = zzbe2.zzqK;
            if (this.zzpP) {
                zza3.zzcd = zzbe2.zzcd;
                zza3.zzcf = zzbe2.zzcf;
                zza3.zzch = zzbe2.zzqL != 0L ? 1 : 0;
                if (this.zzpI > 0L) {
                    zza3.zzce = this.zzpQ != null ? Long.valueOf(Math.round((double)this.zzpN / (double)this.zzpI)) : null;
                    zza3.zzcg = Math.round((double)this.zzpM / (double)this.zzpI);
                }
                zza3.zzck = zzbe2.zzck;
                zza3.zzcj = zzbe2.zzcj;
                zza3.zzcl = zzbe2.zzqO != 0L ? 1 : 0;
                if (this.zzpL > 0L) {
                    zza3.zzcm = this.zzpL;
                }
            }
            zza2.zzbS = zza3;
        }
        catch (zzba zzba2) {}
        if (this.zzpH > 0L) {
            zza2.zzbG = this.zzpH;
        }
        if (this.zzpI > 0L) {
            zza2.zzbF = this.zzpI;
        }
        if (this.zzpJ > 0L) {
            zza2.zzbE = this.zzpJ;
        }
        if (this.zzpK > 0L) {
            zza2.zzbH = this.zzpK;
        }
        try {
            int n = this.zzpG.size() - 1;
            if (n > 0) {
                zza2.zzbT = new zzag.zza.zza[n];
                for (int i = 0; i < n; ++i) {
                    zzbe zzbe3 = zzau.zza(zzbd2, (MotionEvent)this.zzpG.get(i), this.zzpQ);
                    zzag.zza.zza zza4 = new zzag.zza.zza();
                    zza4.zzbn = zzbe3.zzqI;
                    zza4.zzbo = zzbe3.zzqJ;
                    zza2.zzbT[i] = zza4;
                }
            }
        }
        catch (zzba zzba3) {
            zza2.zzbT = null;
        }
    }

    protected void zza(List<Callable<Void>> list) {
        if (zzpz == null) {
            return;
        }
        ExecutorService executorService = zzpz.zzaI();
        if (executorService == null) {
            return;
        }
        if (!list.isEmpty()) {
            try {
                executorService.invokeAll(list, zzgd.zzDO.get(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Log.d((String)TAG, (String)String.format("class methods got exception: %s", zzbf.zza(interruptedException)));
            }
        }
    }

    @Override
    protected zzbe zzb(MotionEvent motionEvent) throws zzba {
        Method method = zzpz.zzc(zzaz.zzaA(), zzaz.zzaB());
        if (method == null || motionEvent == null) {
            throw new zzba();
        }
        try {
            zzbe zzbe2 = new zzbe((String)method.invoke(null, motionEvent, this.zzpQ));
            return zzbe2;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new zzba(reflectiveOperationException);
        }
    }

    @Override
    protected long zza(StackTraceElement[] stackTraceElementArray) throws zzba {
        Method method = zzpz.zzc(zzaz.zzau(), zzaz.zzav());
        if (method == null || stackTraceElementArray == null) {
            throw new zzba();
        }
        try {
            zzbb zzbb2 = new zzbb((String)method.invoke(null, new Object[]{stackTraceElementArray}));
            return zzbb2.zzqi;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new zzba(reflectiveOperationException);
        }
    }
}

