/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzcz;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzpz;
import java.lang.ref.WeakReference;
import java.util.HashSet;

@zzme
@TargetApi(value=14)
public class zzcy
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzwR = zzgd.zzDu.get();
    private final Context zzwi;
    private Application zzwS;
    private final WindowManager zzwo;
    private final PowerManager zzwp;
    private final KeyguardManager zzwq;
    @Nullable
    BroadcastReceiver zzwx;
    private WeakReference<ViewTreeObserver> zzwT;
    WeakReference<View> zzwU;
    private zzcz zzwV;
    private zzpz zzvT = new zzpz(zzwR);
    private boolean zzww = false;
    private int zzwW = -1;
    private HashSet<zzb> zzwX = new HashSet();
    private DisplayMetrics zzwY;

    public zzcy(Context context, View view) {
        this.zzwi = context.getApplicationContext();
        this.zzwo = (WindowManager)context.getSystemService("window");
        this.zzwp = (PowerManager)this.zzwi.getSystemService("power");
        this.zzwq = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzwi instanceof Application) {
            this.zzwS = (Application)this.zzwi;
            this.zzwV = new zzcz((Application)this.zzwi, this);
        }
        this.zzwY = context.getResources().getDisplayMetrics();
        this.zze(view);
    }

    public void zze(View view) {
        View view2;
        View view3 = view2 = this.zzwU != null ? (View)this.zzwU.get() : null;
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzg(view2);
        }
        this.zzwU = new WeakReference<View>(view);
        if (view != null) {
            if (zzw.zzcO().isAttachedToWindow(view)) {
                this.zzf(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    }

    public void zza(zzb zzb2) {
        this.zzwX.add(zzb2);
        this.zzl(3);
    }

    public void zzb(zzb zzb2) {
        this.zzwX.remove(zzb2);
    }

    private void zzdX() {
        zzw.zzcM();
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                zzcy.this.zzl(3);
            }
        });
    }

    public void onViewAttachedToWindow(View view) {
        this.zzwW = -1;
        this.zzf(view);
        this.zzl(3);
    }

    public void onViewDetachedFromWindow(View view) {
        this.zzwW = -1;
        this.zzl(3);
        this.zzdX();
        this.zzg(view);
    }

    private void zza(Activity activity, int n) {
        if (this.zzwU == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzwU.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzwW = n;
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzl(3);
        this.zzdX();
    }

    public void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzl(3);
        this.zzdX();
    }

    public void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzl(3);
        this.zzdX();
    }

    public void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzl(3);
        this.zzdX();
    }

    public void onActivityStopped(Activity activity) {
        this.zzl(3);
        this.zzdX();
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzl(3);
        this.zzdX();
    }

    public void onActivityDestroyed(Activity activity) {
        this.zzl(3);
        this.zzdX();
    }

    public void onGlobalLayout() {
        this.zzl(2);
        this.zzdX();
    }

    public void onScrollChanged() {
        this.zzl(1);
    }

    public void zzdY() {
        this.zzl(4);
    }

    private void zzdF() {
        if (this.zzwx != null) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        this.zzwx = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                zzcy.this.zzl(3);
            }
        };
        this.zzwi.registerReceiver(this.zzwx, intentFilter);
    }

    private void zzdG() {
        if (this.zzwx != null) {
            try {
                this.zzwi.unregisterReceiver(this.zzwx);
            }
            catch (IllegalStateException illegalStateException) {
                zzpk.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzw.zzcQ().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            this.zzwx = null;
        }
    }

    private void zzl(int n) {
        boolean bl;
        if (this.zzwX.size() == 0) {
            return;
        }
        if (this.zzwU == null) {
            return;
        }
        View view = (View)this.zzwU.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        Rect rect5 = new Rect();
        rect5.right = this.zzwo.getDefaultDisplay().getWidth();
        rect5.bottom = this.zzwo.getDefaultDisplay().getHeight();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzpk.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzwW != -1 ? this.zzwW : n2;
        boolean bl6 = bl = !bl3 && zzw.zzcM().zza(view, this.zzwp, this.zzwq) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzvT.tryAcquire() && bl == this.zzww) {
            return;
        }
        if (!bl && !this.zzww && n == 1) {
            return;
        }
        zza zza2 = new zza(zzw.zzcS().elapsedRealtime(), this.zzwp.isScreenOn(), view != null ? zzw.zzcO().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(rect5), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzwY.density, bl);
        for (zzb zzb2 : this.zzwX) {
            zzb2.zza(zza2);
        }
        this.zzww = bl;
    }

    Rect zza(Rect rect) {
        return new Rect(this.zzm(rect.left), this.zzm(rect.top), this.zzm(rect.right), this.zzm(rect.bottom));
    }

    private int zzm(int n) {
        float f = this.zzwY.density;
        return (int)((float)n / f);
    }

    private void zzf(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzwT = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzdF();
        if (this.zzwS != null) {
            try {
                this.zzwS.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzwV);
            }
            catch (Exception exception) {
                zzpk.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private void zzg(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzwT != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzwT.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzwT = null;
            }
        }
        catch (Exception exception) {
            zzpk.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzpk.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        this.zzdG();
        if (this.zzwS != null) {
            try {
                this.zzwS.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzwV);
            }
            catch (Exception exception) {
                zzpk.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    public static interface zzb {
        public void zza(zza var1);
    }

    public static class zza {
        public final long timestamp;
        public final boolean zzxa;
        public final boolean zzxb;
        public final int zzxc;
        public final Rect zzxd;
        public final Rect zzxe;
        public final Rect zzxf;
        public final boolean zzxg;
        public final Rect zzxh;
        public final boolean zzxi;
        public final Rect zzxj;
        public final float zzxk;
        public final boolean zzxl;

        public zza(long l, boolean bl, boolean bl2, int n, Rect rect, Rect rect2, Rect rect3, boolean bl3, Rect rect4, boolean bl4, Rect rect5, float f, boolean bl5) {
            this.timestamp = l;
            this.zzxa = bl;
            this.zzxb = bl2;
            this.zzxc = n;
            this.zzxd = rect;
            this.zzxe = rect2;
            this.zzxf = rect3;
            this.zzxg = bl3;
            this.zzxh = rect4;
            this.zzxi = bl4;
            this.zzxj = rect5;
            this.zzxk = f;
            this.zzxl = bl5;
        }
    }
}

