/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@zzme
public final class zzil
implements zzid {
    private final zzif zzIr;
    private final zzf zzIo;
    private final zzkr zzIp;

    public zzil(zzif zzif2, zzf zzf2, zzkr zzkr2) {
        this.zzIr = zzif2;
        this.zzIo = zzf2;
        this.zzIp = zzkr2;
    }

    @Override
    public void zza(zzqw zzqw2, Map<String, String> map) {
        String string2 = map.get("a");
        if (string2 == null) {
            zzpk.zzbh((String)"Action missing from an open GMSG.");
            return;
        }
        if (this.zzIo != null && !this.zzIo.zzcd()) {
            this.zzIo.zzx(map.get("u"));
            return;
        }
        zzqx zzqx2 = zzqw2.zzlv();
        if ("expand".equalsIgnoreCase(string2)) {
            if (zzqw2.zzlz()) {
                zzpk.zzbh((String)"Cannot expand WebView that is already expanded.");
                return;
            }
            this.zzq(false);
            zzqx2.zza(zzil.zzd(map), zzil.zze(map));
        } else if ("webapp".equalsIgnoreCase(string2)) {
            String string3 = map.get("u");
            this.zzq(false);
            if (string3 != null) {
                zzqx2.zza(zzil.zzd(map), zzil.zze(map), string3);
            } else {
                zzqx2.zza(zzil.zzd(map), zzil.zze(map), map.get("html"), map.get("baseurl"));
            }
        } else if ("in_app_purchase".equalsIgnoreCase(string2)) {
            String string4 = map.get("product_id");
            String string5 = map.get("report_urls");
            if (this.zzIr == null) {
                return;
            }
            if (string5 != null && !string5.isEmpty()) {
                String[] stringArray = string5.split(" ");
                this.zzIr.zza(string4, new ArrayList<String>(Arrays.asList(stringArray)));
            } else {
                this.zzIr.zza(string4, new ArrayList<String>());
            }
        } else if ("app".equalsIgnoreCase(string2) && "true".equalsIgnoreCase(map.get("system_browser"))) {
            this.zzq(true);
            zzil.zzf(zzqw2, map);
        } else {
            this.zzq(true);
            String string6 = map.get("intent_url");
            String string7 = map.get("u");
            Intent intent = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                try {
                    intent = Intent.parseUri((String)string6, (int)0);
                }
                catch (URISyntaxException uRISyntaxException) {
                    String string8 = String.valueOf(string6);
                    zzpk.zzb((String)(string8.length() != 0 ? "Error parsing the url: ".concat(string8) : new String("Error parsing the url: ")), (Throwable)uRISyntaxException);
                }
            }
            if (intent != null && intent.getData() != null) {
                Uri uri = intent.getData();
                String string9 = uri.toString();
                if (!TextUtils.isEmpty((CharSequence)string9)) {
                    string9 = zzw.zzcM().zza(zzqw2, string9);
                    try {
                        uri = Uri.parse((String)string9);
                    }
                    catch (Exception exception) {
                        String string10 = String.valueOf(string9);
                        zzpk.zzb((String)(string10.length() != 0 ? "Error parsing the uri: ".concat(string10) : new String("Error parsing the uri: ")), (Throwable)exception);
                    }
                }
                intent.setData(uri);
            }
            if (intent != null) {
                zzqx2.zza(new zzc(intent));
            } else {
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    string7 = zzw.zzcM().zza(zzqw2, string7);
                }
                zzqx2.zza(new zzc(map.get("i"), string7, map.get("m"), map.get("p"), map.get("c"), map.get("f"), map.get("e")));
            }
        }
    }

    private static void zzf(zzqw zzqw2, Map<String, String> map) {
        Context context = zzqw2.getContext();
        String string2 = map.get("u");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzpk.zzbh((String)"Destination url cannot be empty.");
            return;
        }
        zzqx zzqx2 = zzqw2.zzlv();
        zza zza2 = new zza(zzqw2);
        Intent intent = zza2.zza(context, map);
        try {
            zzqx2.zza(new zzc(intent));
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzpk.zzbh((String)activityNotFoundException.getMessage());
        }
    }

    private static boolean zzd(Map<String, String> map) {
        return "1".equals(map.get("custom_close"));
    }

    private static int zze(Map<String, String> map) {
        String string2 = map.get("o");
        if (string2 != null) {
            if ("p".equalsIgnoreCase(string2)) {
                return zzw.zzcO().zzkR();
            }
            if ("l".equalsIgnoreCase(string2)) {
                return zzw.zzcO().zzkQ();
            }
            if ("c".equalsIgnoreCase(string2)) {
                return zzw.zzcO().zzkS();
            }
        }
        return -1;
    }

    private void zzq(boolean bl) {
        if (this.zzIp != null) {
            this.zzIp.zzr(bl);
        }
    }

    public static class zza {
        private final zzqw zzIs;

        public zza(zzqw zzqw2) {
            this.zzIs = zzqw2;
        }

        public Intent zzf(Uri uri) {
            if (uri == null) {
                return null;
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10000000);
            intent.setData(uri);
            intent.setAction("android.intent.action.VIEW");
            return intent;
        }

        public ResolveInfo zza(Context context, Intent intent) {
            return this.zza(context, intent, new ArrayList<ResolveInfo>());
        }

        public ResolveInfo zza(Context context, Intent intent, ArrayList<ResolveInfo> arrayList) {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return null;
            }
            List list = packageManager.queryIntentActivities(intent, 65536);
            ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
            ResolveInfo resolveInfo2 = null;
            if (list != null && resolveInfo != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ResolveInfo resolveInfo3 = (ResolveInfo)list.get(i);
                    if (resolveInfo == null || !resolveInfo.activityInfo.name.equals(resolveInfo3.activityInfo.name)) continue;
                    resolveInfo2 = resolveInfo;
                    break;
                }
            }
            arrayList.addAll(list);
            return resolveInfo2;
        }

        public Intent zza(Intent intent, ResolveInfo resolveInfo) {
            Intent intent2 = new Intent(intent);
            intent2.setClassName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
            return intent2;
        }

        public Intent zza(Context context, Map<String, String> map) {
            Object object;
            ResolveInfo resolveInfo3;
            Object object2;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            String string2 = map.get("u");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            if (this.zzIs != null) {
                string2 = zzw.zzcM().zza(this.zzIs, string2);
            }
            Uri uri = Uri.parse((String)string2);
            boolean bl = Boolean.parseBoolean(map.get("use_first_package"));
            boolean bl2 = Boolean.parseBoolean(map.get("use_running_process"));
            Uri uri2 = null;
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("https").build();
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("http").build();
            }
            ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
            Intent intent = this.zzf(uri);
            Intent intent2 = this.zzf(uri2);
            ResolveInfo resolveInfo2 = this.zza(context, intent, arrayList);
            if (resolveInfo2 != null) {
                return this.zza(intent, resolveInfo2);
            }
            if (intent2 != null && (object2 = this.zza(context, intent2)) != null && (resolveInfo3 = this.zza(context, (Intent)(object = this.zza(intent, (ResolveInfo)object2)))) != null) {
                return object;
            }
            if (arrayList.size() == 0) {
                return intent;
            }
            if (bl2 && activityManager != null && (object2 = activityManager.getRunningAppProcesses()) != null) {
                for (ResolveInfo resolveInfo3 : arrayList) {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)iterator.next();
                        if (!runningAppProcessInfo.processName.equals(resolveInfo3.activityInfo.packageName)) continue;
                        return this.zza(intent, resolveInfo3);
                    }
                }
            }
            if (bl) {
                return this.zza(intent, arrayList.get(0));
            }
            return intent;
        }
    }
}

