/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@zzme
public class zzql {
    public static <A, B> zzqm<B> zza(final zzqm<A> zzqm2, final zza<A, B> zza2) {
        final zzqj zzqj2 = new zzqj();
        zzqm2.zzc(new Runnable(){

            @Override
            public void run() {
                try {
                    zzqj2.zzh(zza2.apply(zzqm2.get()));
                    return;
                }
                catch (CancellationException cancellationException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {}
                zzqj2.cancel(true);
            }
        });
        return zzqj2;
    }

    public static <T> T zza(Future<T> future, T t, int n, TimeUnit timeUnit) {
        try {
            return future.get(n, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return t;
        }
        catch (Exception exception) {
            return t;
        }
    }

    public static <V> zzqm<List<V>> zzo(final List<zzqm<V>> list) {
        final zzqj<List<V>> zzqj2 = new zzqj<List<V>>();
        final int n = list.size();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        for (zzqm<V> zzqm2 : list) {
            zzqm2.zzc(new Runnable(){

                @Override
                public void run() {
                    if (atomicInteger.incrementAndGet() >= n) {
                        try {
                            zzqj2.zzh(zzql.zzp(list));
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            zzpk.zzc((String)"Unable to convert list of futures to a future of list", (Throwable)exception);
                        }
                    }
                }
            });
        }
        return zzqj2;
    }

    private static <V> List<V> zzp(List<zzqm<V>> list) throws ExecutionException, InterruptedException {
        ArrayList arrayList = new ArrayList();
        for (zzqm<V> zzqm2 : list) {
            Object v = zzqm2.get();
            if (v == null) continue;
            arrayList.add(v);
        }
        return arrayList;
    }

    public static interface zza<D, R> {
        public R apply(D var1);
    }
}

