/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrc;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
class zzra
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzqw {
    private final zza zzZZ;
    private final Object zzrJ = new Object();
    @Nullable
    private final zzaw zzGP;
    private final zzqh zztt;
    private final zzu zzaaa;
    private final zze zzsv;
    private zzqx zzaab;
    private com.google.android.gms.ads.internal.overlay.zze zzaac;
    private zzeg zzus;
    private boolean zzaad;
    private boolean zzaae;
    private boolean zzaaf;
    private boolean zzaag;
    private Boolean zzWO;
    private int zzaah;
    private boolean zzaai = true;
    boolean zzaaj = false;
    private String zzOV = "";
    private zzrb zzaak;
    private boolean zzaal;
    private boolean zzaam;
    private zzgy zzaan;
    private int zzaao;
    private int zzaap;
    private zzgj zzaaq;
    private zzgj zzOW;
    private zzgj zzaar;
    private zzgk zzaas;
    private WeakReference<View.OnClickListener> zzaat;
    private com.google.android.gms.ads.internal.overlay.zze zzaau;
    private boolean zzaav;
    private zzqd zzvY;
    private int zzMz = -1;
    private int zzMy = -1;
    private int zzMB = -1;
    private int zzMC = -1;
    private Map<String, zzis> zzaaw;
    private final WindowManager zzwo;

    static zzra zzb(Context context, zzeg zzeg2, boolean bl, boolean bl2, @Nullable zzaw zzaw2, zzqh zzqh2, zzgl zzgl2, zzu zzu2, zze zze2) {
        zza zza2 = new zza(context);
        return new zzra(zza2, zzeg2, bl, bl2, zzaw2, zzqh2, zzgl2, zzu2, zze2);
    }

    protected zzra(zza zza2, zzeg zzeg2, boolean bl, boolean bl2, @Nullable zzaw zzaw2, zzqh zzqh2, zzgl zzgl2, zzu zzu2, zze zze2) {
        super((Context)zza2);
        this.zzZZ = zza2;
        this.zzus = zzeg2;
        this.zzaaf = bl;
        this.zzaah = -1;
        this.zzGP = zzaw2;
        this.zztt = zzqh2;
        this.zzaaa = zzu2;
        this.zzsv = zze2;
        this.zzwo = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzw.zzcM().zza((Context)zza2, zzqh2.zzba, webSettings);
        zzw.zzcO().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzmg();
        if (zzt.zzzj()) {
            this.addJavascriptInterface(new zzrc(this), "googleAdsJsInterface");
        }
        zzt.zzze();
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzvY = new zzqd(this.zzZZ.zzlr(), (View)this, this, null);
        this.zzd(zzgl2);
        zzw.zzcO().zzW((Context)zza2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzqx) {
            this.zzaab = (zzqx)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zze zzby() {
        return this.zzsv;
    }

    public boolean zzmb() {
        int n;
        int n2;
        if (!this.zzlv().zzdD() && !this.zzlv().zzlO()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzw.zzcM().zza(this.zzwo);
        int n3 = zzel.zzeT().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzel.zzeT().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzlr();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzw.zzcM().zzh(activity);
            n2 = zzel.zzeT().zzb(displayMetrics, nArray[0]);
            n = zzel.zzeT().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzMy == n3 && this.zzMz == n4 && this.zzMB == n2 && this.zzMC == n) {
            return false;
        }
        boolean bl = this.zzMy != n3 || this.zzMz != n4;
        this.zzMy = n3;
        this.zzMz = n4;
        this.zzMB = n2;
        this.zzMC = n;
        new zzkw(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzwo.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzw.zzcM().zzQ(map);
        }
        catch (JSONException jSONException) {
            zzpk.zzbh((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzpk.zzbh((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbl(String string2) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzpk.zzbh((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String string2) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Throwable throwable) {
                    zzw.zzcQ().zza(throwable, "AdWebViewImpl.loadUrl");
                    zzpk.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
                }
            } else {
                zzpk.zzbh((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbi(String string2) {
        Object object = this.zzrJ;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                zzw.zzcQ().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
                zzpk.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String string2, String string3, String string4) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzpk.zzbh((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzpk.zzbh((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzpk.zzbh((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzbm(String string2) {
        if (zzt.zzzl()) {
            if (this.zzkq() == null) {
                this.zzmc();
            }
            if (this.zzkq().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                String string3 = String.valueOf(string2);
                this.zzbl(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            }
        } else {
            String string4 = String.valueOf(string2);
            this.zzbl(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmc() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzWO = zzw.zzcQ().zzkq();
            if (this.zzWO == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zza(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zza(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zza(Boolean bl) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzWO = bl;
        }
        zzw.zzcQ().zza(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzkq() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzWO;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzj(string2, string3);
    }

    @Override
    public void zzj(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzbm(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzpk.zzbf((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzbm(stringBuilder.toString());
    }

    @Override
    public void zzlp() {
        this.zzmd();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zztt.zzba);
        this.zza("onhide", hashMap);
    }

    @Override
    public void zzM(int n) {
        if (n == 0) {
            this.zzme();
        }
        this.zzmd();
        if (this.zzaas.zzfA() != null) {
            this.zzaas.zzfA().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zztt.zzba);
        this.zza("onhide", hashMap);
    }

    private void zzmd() {
        zzgh.zza(this.zzaas.zzfA(), this.zzOW, "aeh2");
    }

    private void zzme() {
        zzgh.zza(this.zzaas.zzfA(), this.zzOW, "aebb2");
    }

    @Override
    public void zzhK() {
        if (this.zzaaq == null) {
            zzgh.zza(this.zzaas.zzfA(), this.zzOW, "aes2");
            this.zzaaq = zzgh.zzb(this.zzaas.zzfA());
            this.zzaas.zza("native:view_show", this.zzaaq);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zztt.zzba);
        this.zza("onshow", hashMap);
    }

    @Override
    public void zzlq() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzw.zzcM().zzcs()));
        hashMap.put("app_volume", String.valueOf(zzw.zzcM().zzcq()));
        hashMap.put("device_volume", String.valueOf(zzw.zzcM().zzS(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zze zzlt() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zze zzlu() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaau;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzeg zzbC() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzus;
        }
    }

    @Override
    public zzqx zzlv() {
        return this.zzaab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzlw() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaad;
        }
    }

    @Override
    public zzaw zzlx() {
        return this.zzGP;
    }

    @Override
    public zzqh zzly() {
        return this.zztt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzlz() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaaf;
        }
    }

    public void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzw.zzcM().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzpk.zzbf((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzlv().zzlO()) {
            Object object = this.zzrJ;
            synchronized (object) {
                if (this.zzaan != null) {
                    this.zzaan.zzc(motionEvent);
                }
            }
        } else if (this.zzGP != null) {
            this.zzGP.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (zzgd.zzCK.get().booleanValue()) {
            boolean bl;
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            boolean bl2 = bl = motionEvent.getActionMasked() == 8;
            if (bl && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int n, int n2) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzaaf || this.zzus.zzzB) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzus.zzzC) {
                int n3;
                if (zzgd.zzEy.get().booleanValue() || !zzt.zzzj()) {
                    super.onMeasure(n, n2);
                    return;
                }
                this.zza("/contentHeight", this.zzmf());
                String string2 = "(function() {  var height = -1;  if (document.body) { height = document.body.offsetHeight;}  else if (document.documentElement) {      height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  window.googleAdsJsInterface.notify(url);  })();";
                this.zzbm(string2);
                float f = this.zzZZ.getResources().getDisplayMetrics().density;
                int n4 = View.MeasureSpec.getSize((int)n);
                switch (this.zzaap) {
                    case -1: {
                        n3 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n3 = (int)((float)this.zzaap * f);
                    }
                }
                this.setMeasuredDimension(n4, n3);
                return;
            }
            if (this.zzus.zzzz) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzwo.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            int n9 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n9 = n6;
            }
            int n10 = Integer.MAX_VALUE;
            if (n7 == Integer.MIN_VALUE || n7 == 0x40000000) {
                n10 = n8;
            }
            if (this.zzus.widthPixels > n9 || this.zzus.heightPixels > n10) {
                float f = this.zzZZ.getResources().getDisplayMetrics().density;
                int n11 = (int)((float)this.zzus.widthPixels / f);
                int n12 = (int)((float)this.zzus.heightPixels / f);
                int n13 = (int)((float)n6 / f);
                int n14 = (int)((float)n8 / f);
                zzpk.zzbh((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n11).append("x").append(n12).append(" dp, but only has ").append(n13).append("x").append(n14).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzus.widthPixels, this.zzus.heightPixels);
            }
        }
    }

    zzid zzmf() {
        return new zzid(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zza(zzqw zzqw2, Map<String, String> map) {
                String string2;
                if (map != null && !TextUtils.isEmpty((CharSequence)(string2 = map.get("height")))) {
                    try {
                        int n = Integer.parseInt(string2);
                        Object object = zzra.this.zzrJ;
                        synchronized (object) {
                            if (zzra.this.zzaap != n) {
                                zzra.this.zzaap = n;
                                zzra.this.requestLayout();
                            }
                        }
                    }
                    catch (Exception exception) {
                        zzpk.zzc((String)"Exception occurred while getting webview content height", (Throwable)exception);
                    }
                }
            }
        };
    }

    public void onGlobalLayout() {
        boolean bl = this.zzmb();
        com.google.android.gms.ads.internal.overlay.zze zze2 = this.zzlt();
        if (zze2 != null && bl) {
            zze2.zzhJ();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, zzeg zzeg2, zzgl zzgl2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzvY.zzlf();
            this.setContext(context);
            this.zzaac = null;
            this.zzus = zzeg2;
            this.zzaaf = false;
            this.zzaad = false;
            this.zzOV = "";
            this.zzaah = -1;
            zzw.zzcO().zzm(this);
            this.loadUrl("about:blank");
            this.zzaab.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzaai = true;
            this.zzaaj = false;
            this.zzaak = null;
            this.zzd(zzgl2);
            this.zzaal = false;
            this.zzaao = 0;
            zzw.zzdj().zze(this);
            this.zzmj();
        }
    }

    private void zzd(zzgl zzgl2) {
        this.zzmk();
        this.zzaas = new zzgk(new zzgl(true, "make_wv", this.zzus.zzzy));
        this.zzaas.zzfA().zzc(zzgl2);
        this.zzOW = zzgh.zzb(this.zzaas.zzfA());
        this.zzaas.zza("native:view_create", this.zzOW);
        this.zzaar = null;
        this.zzaaq = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zze zze2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaac = zze2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(com.google.android.gms.ads.internal.overlay.zze zze2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaau = zze2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzeg zzeg2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzus = zzeg2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzJ(boolean bl) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaaf = bl;
            this.zzmg();
        }
    }

    @Override
    public void zzlI() {
        this.zzvY.zzle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzrJ;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzvY.onAttachedToWindow();
            }
            boolean bl = this.zzaal;
            if (this.zzlv() != null && this.zzlv().zzlO()) {
                bl = true;
                if (!this.zzaam) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzlv().zzlP();
                    if (onGlobalLayoutListener != null) {
                        zzw.zzdk().zza(this.getView(), onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzlv().zzlQ()) != null) {
                        zzw.zzdk().zza(this.getView(), onScrollChangedListener);
                    }
                    this.zzaam = true;
                }
            }
            this.zzO(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzvY.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzaam && this.zzlv() != null && this.zzlv().zzlO() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzlv().zzlP();
                if (onGlobalLayoutListener != null) {
                    zzw.zzcO().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzlv().zzlQ()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzaam = false;
            }
        }
        this.zzO(false);
    }

    @Override
    public void setContext(Context context) {
        this.zzZZ.setBaseContext(context);
        this.zzvY.zzl(this.zzZZ.zzlr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzK(boolean bl) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzaac != null) {
                this.zzaac.zza(this.zzaab.zzdD(), bl);
            } else {
                this.zzaad = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaah;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int n) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaah = n;
            if (this.zzaac != null) {
                this.zzaac.setRequestedOrientation(this.zzaah);
            }
        }
    }

    @Override
    public Activity zzlr() {
        return this.zzZZ.zzlr();
    }

    @Override
    public Context zzls() {
        return this.zzZZ.zzls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmg() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzaaf || this.zzus.zzzz) {
                zzpk.zzbf((String)"Enabling hardware acceleration on an overlay.");
                this.zzmi();
            } else if (Build.VERSION.SDK_INT < 18) {
                zzpk.zzbf((String)"Disabling hardware acceleration on an AdView.");
                this.zzmh();
            } else {
                zzpk.zzbf((String)"Enabling hardware acceleration on an AdView.");
                this.zzmi();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmh() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.zzaag) {
                zzw.zzcO().zzu((View)this);
            }
            this.zzaag = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmi() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzaag) {
                zzw.zzcO().zzt((View)this);
            }
            this.zzaag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzmk();
            this.zzvY.zzlf();
            if (this.zzaac != null) {
                this.zzaac.close();
                this.zzaac.onDestroy();
                this.zzaac = null;
            }
            this.zzaab.reset();
            if (this.zzaae) {
                return;
            }
            zzw.zzdj().zze(this);
            this.zzmj();
            this.zzaae = true;
            zzpk.v("Initiating WebView self destruct sequence in 3...");
            this.zzaab.zzlS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Object object = this.zzrJ;
            synchronized (object) {
                if (!this.zzaae) {
                    this.zzaab.reset();
                    zzw.zzdj().zze(this);
                    this.zzmj();
                    this.zzkC();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzlA() {
        Object object = this.zzrJ;
        synchronized (object) {
            zzpk.v("Destroying WebView!");
            this.zzkC();
            zzpo.zzXC.post(new Runnable(){

                @Override
                public void run() {
                    zzra.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzkC() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (!this.zzaav) {
                this.zzaav = true;
                zzw.zzcQ().zzkC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaae;
        }
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzlv() != null && this.zzlv().zzlZ() != null) {
            this.zzlv().zzlZ().zzce();
        }
    }

    @Override
    public void zzlJ() {
        if (this.zzaar == null) {
            this.zzaar = zzgh.zzb(this.zzaas.zzfA());
            this.zzaas.zza("native:view_load", this.zzaar);
        }
    }

    @Override
    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            zzt.zzze();
            super.onPause();
        }
        catch (Exception exception) {
            zzpk.zzb((String)"Could not pause webview.", (Throwable)exception);
        }
    }

    @Override
    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            zzt.zzze();
            super.onResume();
        }
        catch (Exception exception) {
            zzpk.zzb((String)"Could not resume webview.", (Throwable)exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzpk.zzb((String)"Could not stop loading webview.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzL(boolean bl) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaai = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzlB() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaai;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzlC() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaaj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbV() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaaj = true;
            if (this.zzaaa != null) {
                this.zzaaa.zzbV();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbW() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaaj = false;
            if (this.zzaaa != null) {
                this.zzaaa.zzbW();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmj() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaaw = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzbj(String string2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzOV = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzOV;
        }
    }

    @Override
    public zzqv zzlD() {
        return null;
    }

    @Override
    public zzgj zzlE() {
        return this.zzOW;
    }

    @Override
    public zzgk zzlF() {
        return this.zzaas;
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzaat = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public View.OnClickListener zzlK() {
        return (View.OnClickListener)this.zzaat.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzgy zzgy2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaan = zzgy2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzgy zzlL() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaan;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzrb zzlG() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaak;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzrb zzrb2) {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzaak != null) {
                zzpk.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzaak = zzrb2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzlH() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaao > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzM(boolean bl) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaao += bl ? 1 : -1;
            if (this.zzaao <= 0 && this.zzaac != null) {
                this.zzaac.zzhM();
            }
        }
    }

    private void zzmk() {
        if (this.zzaas == null) {
            return;
        }
        zzgl zzgl2 = this.zzaas.zzfA();
        if (zzgl2 != null && zzw.zzcQ().zzkk() != null) {
            zzw.zzcQ().zzkk().zza(zzgl2);
        }
    }

    @Override
    public void zzlM() {
        this.setBackgroundColor(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzcy.zza zza2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaal = zza2.zzxl;
        }
        this.zzO(zza2.zzxl);
    }

    private void zzO(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public void zza(String string2, zzid zzid2) {
        if (this.zzaab != null) {
            this.zzaab.zza(string2, zzid2);
        }
    }

    @Override
    public void zzb(String string2, zzid zzid2) {
        if (this.zzaab != null) {
            this.zzaab.zzb(string2, zzid2);
        }
    }

    @zzme
    public static class zza
    extends MutableContextWrapper {
        private Activity zzYJ;
        private Context zzwi;
        private Context zzaay;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context context) {
            this.zzwi = context.getApplicationContext();
            this.zzYJ = context instanceof Activity ? (Activity)context : null;
            this.zzaay = context;
            super.setBaseContext(this.zzwi);
        }

        public void startActivity(Intent intent) {
            if (this.zzYJ != null) {
                this.zzYJ.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzwi.startActivity(intent);
            }
        }

        public Activity zzlr() {
            return this.zzYJ;
        }

        public Object getSystemService(String string2) {
            return this.zzaay.getSystemService(string2);
        }

        public Context zzls() {
            return this.zzaay;
        }
    }
}

