/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzab;
import com.google.android.gms.ads.internal.overlay.zzac;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzas;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zznb;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzaaz
public final class zzaa
extends FrameLayout
implements zzx {
    private final zzalm zzJK;
    private final FrameLayout zzPt;
    private final zznb zzPu;
    private final zzas zzPv;
    private final long zzPw;
    @Nullable
    private zzy zzPx;
    private boolean zzPy;
    private boolean zzPz;
    private boolean zzPA;
    private boolean zzPB;
    private long zzPC;
    private long zzPD;
    private String zzJP;
    private Bitmap zzPE;
    private ImageView zzPF;
    private boolean zzPG;

    public static void zzh(zzalm zzalm2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzalm2.zza("onVideoEvent", hashMap);
    }

    public static void zzc(zzalm zzalm2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzalm2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzalm zzalm2, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string);
        zzalm2.zza("onVideoEvent", hashMap);
    }

    public zzaa(Context context, zzalm zzalm2, int n, boolean bl, zznb zznb2, zzaq zzaq2) {
        super(context);
        zzme<Constable> zzme2;
        this.zzJK = zzalm2;
        this.zzPu = zznb2;
        this.zzPt = new FrameLayout(context);
        this.addView((View)this.zzPt, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzr((Object)zzalm2.zzaj());
        this.zzPx = zzalm2.zzaj().zztq.zza(context, zzalm2, n, bl, zznb2, zzaq2);
        if (this.zzPx != null) {
            this.zzPt.addView((View)this.zzPx, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzme2 = zzmo.zzCz;
            if (((Boolean)((Object)zzbs.zzbK().zzd(zzme2))).booleanValue()) {
                this.zzga();
            }
        }
        this.zzPF = new ImageView(context);
        zzme2 = zzmo.zzCD;
        this.zzPw = zzbs.zzbK().zzd(zzme2);
        zzme2 = zzmo.zzCB;
        this.zzPB = (Boolean)((Object)zzbs.zzbK().zzd(zzme2));
        if (this.zzPu != null) {
            this.zzPu.zzh("spinner_used", this.zzPB ? "1" : "0");
        }
        this.zzPv = new zzas(this);
        if (this.zzPx != null) {
            this.zzPx.zza(this);
        }
        if (this.zzPx == null) {
            this.zzj("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzPt.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzaq(String string) {
        this.zzJP = string;
    }

    public final void zza(float f, float f2) {
        if (this.zzPx != null) {
            this.zzPx.zza(f, f2);
        }
    }

    public final void zzfX() {
        if (this.zzPx == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzJP)) {
            this.zzPx.setVideoPath(this.zzJP);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzPx == null) {
            return;
        }
        this.zzPx.pause();
    }

    public final void play() {
        if (this.zzPx == null) {
            return;
        }
        this.zzPx.play();
    }

    public final void seekTo(int n) {
        if (this.zzPx == null) {
            return;
        }
        this.zzPx.seekTo(n);
    }

    public final void zzfY() {
        if (this.zzPx == null) {
            return;
        }
        zzy zzy2 = this.zzPx;
        zzy2.zzPs.setMuted(true);
        zzy2.zzfG();
    }

    public final void zzfZ() {
        if (this.zzPx == null) {
            return;
        }
        zzy zzy2 = this.zzPx;
        zzy2.zzPs.setMuted(false);
        zzy2.zzfG();
    }

    public final void zzb(float f) {
        if (this.zzPx == null) {
            return;
        }
        float f2 = f;
        zzy zzy2 = this.zzPx;
        zzy2.zzPs.zzb(f2);
        zzy2.zzfG();
    }

    @TargetApi(value=14)
    public final void zze(MotionEvent motionEvent) {
        if (this.zzPx == null) {
            return;
        }
        this.zzPx.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzga() {
        if (this.zzPx == null) {
            return;
        }
        Context context = this.zzPx.getContext();
        TextView textView = new TextView(context);
        String string = String.valueOf(this.zzPx.zzfC());
        textView.setText((CharSequence)(string.length() != 0 ? "AdMob - ".concat(string) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzPt.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzPt.bringChildToFront((View)textView);
    }

    @Override
    public final void zzfR() {
        this.zzPv.resume();
        zzail.zzZt.post((Runnable)new zzab(this));
    }

    @Override
    public final void zzfS() {
        if (this.zzPx == null) {
            return;
        }
        if (this.zzPD == 0L) {
            float f = (float)this.zzPx.getDuration() / 1000.0f;
            int n = this.zzPx.getVideoWidth();
            int n2 = this.zzPx.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzfT() {
        zzaa zzaa2 = this;
        if (zzaa2.zzJK.zzir() != null && !zzaa2.zzPz) {
            WindowManager.LayoutParams layoutParams = zzaa2.zzJK.zzir().getWindow().getAttributes();
            boolean bl = zzaa2.zzPA = (layoutParams.flags & 0x80) != 0;
            if (!zzaa2.zzPA) {
                zzaa2.zzJK.zzir().getWindow().addFlags(128);
                zzaa2.zzPz = true;
            }
        }
        this.zzPy = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zzgd();
        this.zzPy = false;
    }

    @Override
    public final void zzfU() {
        this.zza("ended", new String[0]);
        this.zzgd();
    }

    @Override
    public final void zzj(String string, @Nullable String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public final void zzfV() {
        zzaa zzaa2 = this;
        if (zzaa2.zzPG && zzaa2.zzPE != null && !zzaa2.zzgc()) {
            zzaa2.zzPF.setImageBitmap(zzaa2.zzPE);
            zzaa2.zzPF.invalidate();
            zzaa2.zzPt.addView((View)zzaa2.zzPF, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzaa2.zzPt.bringChildToFront((View)zzaa2.zzPF);
        }
        this.zzPv.pause();
        this.zzPD = this.zzPC;
        zzail.zzZt.post((Runnable)new zzac(this));
    }

    public final void destroy() {
        this.zzPv.pause();
        if (this.zzPx != null) {
            this.zzPx.stop();
        }
        this.zzgd();
    }

    final void zzgb() {
        if (this.zzPx == null) {
            return;
        }
        long l = this.zzPx.getCurrentPosition();
        if (this.zzPC != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzPC = l;
        }
    }

    @Override
    public final void zzfW() {
        zzaa zzaa2;
        if (this.zzPy && (zzaa2 = this).zzgc()) {
            zzaa2.zzPt.removeView((View)zzaa2.zzPF);
        }
        zzaa2 = this;
        if (zzaa2.zzPE != null) {
            long l = zzbs.zzbE().elapsedRealtime();
            if (zzaa2.zzPx.getBitmap(zzaa2.zzPE) != null) {
                zzaa2.zzPG = true;
            }
            long l2 = zzbs.zzbE().elapsedRealtime() - l;
            if (zzahd.zzhL()) {
                zzahd.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzaa2.zzPw) {
                zzahd.zzaT((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzaa2.zzPB = false;
                zzaa2.zzPE = null;
                if (zzaa2.zzPu != null) {
                    zzaa2.zzPu.zzh("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzd(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzaa zzaa2 = this;
        if (zzaa2.zzPB) {
            zzme<Integer> zzme2 = zzmo.zzCC;
            n4 = Math.max(n4 / zzbs.zzbK().zzd(zzme2), 1);
            zzme2 = zzmo.zzCC;
            n3 = Math.max(n3 / zzbs.zzbK().zzd(zzme2), 1);
            if (zzaa2.zzPE == null || zzaa2.zzPE.getWidth() != n4 || zzaa2.zzPE.getHeight() != n3) {
                zzaa2.zzPE = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzaa2.zzPG = false;
            }
        }
    }

    private final boolean zzgc() {
        return this.zzPF.getParent() != null;
    }

    private final void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray2[i];
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzJK.zza("onVideoEvent", hashMap);
    }

    private final void zzgd() {
        if (this.zzJK.zzir() == null) {
            return;
        }
        if (this.zzPz && !this.zzPA) {
            this.zzJK.zzir().getWindow().clearFlags(128);
            this.zzPz = false;
        }
    }

    static /* synthetic */ void zza(zzaa zzaa2, String string, String[] stringArray) {
        zzaa2.zza(string, stringArray);
    }
}

