/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.overlay.zzan;
import com.google.android.gms.ads.internal.overlay.zzao;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;

@zzaaz
final class zzam
implements SensorEventListener {
    private final SensorManager zzPO;
    private final Object zzPP;
    private final Display zzPQ;
    private final float[] zzPR;
    private final float[] zzPS;
    private float[] zzPT;
    private Handler zzPU;
    private zzao zzPV;

    zzam(Context context) {
        this.zzPO = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzPQ = windowManager.getDefaultDisplay();
        this.zzPR = new float[9];
        this.zzPS = new float[9];
        this.zzPP = new Object();
    }

    final void start() {
        if (this.zzPU != null) {
            return;
        }
        Sensor sensor = this.zzPO.getDefaultSensor(11);
        if (sensor == null) {
            zzahd.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzPU = new Handler(handlerThread.getLooper());
        if (!this.zzPO.registerListener((SensorEventListener)this, sensor, 0, this.zzPU)) {
            zzahd.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzPU == null) {
            return;
        }
        this.zzPO.unregisterListener((SensorEventListener)this);
        this.zzPU.post((Runnable)new zzan(this));
        this.zzPU = null;
    }

    final void zza(zzao zzao2) {
        this.zzPV = zzao2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzam zzam2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzam2.zzPP;
            synchronized (object) {
                if (zzam2.zzPT == null) {
                    zzam2.zzPT = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzam2.zzPR, (float[])fArray);
            switch (zzam2.zzPQ.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzPR, (int)2, (int)129, (float[])zzam2.zzPS);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzPR, (int)129, (int)130, (float[])zzam2.zzPS);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzPR, (int)130, (int)1, (float[])zzam2.zzPS);
                    break;
                }
                default: {
                    System.arraycopy(zzam2.zzPR, 0, zzam2.zzPS, 0, 9);
                }
            }
            zzam2.zze(1, 3);
            zzam2.zze(2, 6);
            zzam2.zze(5, 7);
            Object object2 = zzam2.zzPP;
            synchronized (object2) {
                System.arraycopy(zzam2.zzPS, 0, zzam2.zzPT, 0, 9);
            }
            if (zzam2.zzPV != null) {
                zzam2.zzPV.zzfN();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzPP;
        synchronized (object) {
            if (this.zzPT == null) {
                return false;
            }
            System.arraycopy(this.zzPT, 0, fArray, 0, this.zzPT.length);
            return true;
        }
    }

    private final void zze(int n, int n2) {
        float f = this.zzPS[n];
        this.zzPS[n] = this.zzPS[n2];
        this.zzPS[n2] = f;
    }
}

