/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzam;
import com.google.android.gms.ads.internal.overlay.zzao;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzaaz
@TargetApi(value=14)
public final class zzap
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzao {
    private static final float[] zzPW = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzam zzPX;
    private final float[] zzPT;
    private final float[] zzPY;
    private final float[] zzPZ;
    private final float[] zzQa;
    private final float[] zzQb;
    private final float[] zzQc;
    private final float[] zzQd;
    private float zzQe;
    private float zzQf;
    private float zzQg;
    private int zzsa;
    private int zzrZ;
    private SurfaceTexture zzQh;
    private SurfaceTexture zzQi;
    private int zzQj;
    private int zzQk;
    private int zzQl;
    private FloatBuffer zzQm = ByteBuffer.allocateDirect(zzPW.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzQn;
    private final Object zzQo;
    private EGL10 zzQp;
    private EGLDisplay zzQq;
    private EGLContext zzQr;
    private EGLSurface zzQs;
    private volatile boolean zzQt;
    private volatile boolean zzQu;

    public zzap(Context context) {
        super("SphericalVideoProcessor");
        this.zzQm.put(zzPW).position(0);
        this.zzPT = new float[9];
        this.zzPY = new float[9];
        this.zzPZ = new float[9];
        this.zzQa = new float[9];
        this.zzQb = new float[9];
        this.zzQc = new float[9];
        this.zzQd = new float[9];
        this.zzQe = Float.NaN;
        this.zzPX = new zzam(context);
        this.zzPX.zza(this);
        this.zzQn = new CountDownLatch(1);
        this.zzQo = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzrZ = n;
        this.zzsa = n2;
        this.zzQi = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzf(int n, int n2) {
        Object object = this.zzQo;
        synchronized (object) {
            this.zzrZ = n;
            this.zzsa = n2;
            this.zzQt = true;
            this.zzQo.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzge() {
        Object object = this.zzQo;
        synchronized (object) {
            this.zzQu = true;
            this.zzQi = null;
            this.zzQo.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzgf() {
        if (this.zzQi == null) {
            return null;
        }
        try {
            this.zzQn.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzQh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzQl;
        Object object = this.zzQo;
        synchronized (object) {
            this.zzQo.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzfN() {
        Object object = this.zzQo;
        synchronized (object) {
            this.zzQo.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string;
        zzme<String> zzme2;
        Object object;
        Object object2;
        boolean bl2;
        if (this.zzQi == null) {
            zzahd.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzQn.countDown();
            return;
        }
        zzap zzap2 = this;
        this.zzQp = (EGL10)EGLContext.getEGL();
        zzap2.zzQq = zzap2.zzQp.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzap2.zzQq == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzap2.zzQp.eglInitialize(zzap2.zzQq, nArray)) {
                bl2 = false;
            } else {
                object2 = zzap2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                int[] nArray3 = new int[1];
                object = ((zzap)object2).zzQp.eglChooseConfig(((zzap)object2).zzQq, nArray2, eGLConfigArray, 1, nArray3) && nArray3[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray4 = new int[]{12440, 2, 12344};
                    zzap2.zzQr = zzap2.zzQp.eglCreateContext(zzap2.zzQq, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray4);
                    if (zzap2.zzQr == null || zzap2.zzQr == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzap2.zzQs = zzap2.zzQp.eglCreateWindowSurface(zzap2.zzQq, (EGLConfig)object, (Object)zzap2.zzQi, null);
                        bl2 = zzap2.zzQs == null || zzap2.zzQs == EGL10.EGL_NO_SURFACE ? false : zzap2.zzQp.eglMakeCurrent(zzap2.zzQq, zzap2.zzQs, zzap2.zzQs, zzap2.zzQr);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzap2 = this;
        zzme<String> zzme3 = zzme2 = zzmo.zzEq;
        if (!zzbs.zzbK().zzd(zzme3).equals(zzme2.zzdH())) {
            zzme3 = zzme2;
            string = zzbs.zzbK().zzd(zzme3);
        } else {
            string = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzap.zzc(35633, string);
        if (n2 == 0) {
            n = 0;
        } else {
            String string2;
            zzme3 = zzme2 = zzmo.zzEr;
            if (!zzbs.zzbK().zzd(zzme3).equals(zzme2.zzdH())) {
                zzme3 = zzme2;
                string2 = zzbs.zzbK().zzd(zzme3);
            } else {
                string2 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzap.zzc(35632, string2);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzap.zzar("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzap.zzar("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzap.zzar("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzap.zzar("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzap.zzar("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzap.zzar("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzap.zzar("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzQj = n;
        GLES20.glUseProgram((int)zzap2.zzQj);
        zzap.zzar("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzap2.zzQj, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzap2.zzQm);
        zzap.zzar("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzap.zzar("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzap.zzar("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzap.zzar("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzap.zzar("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzap.zzar("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzap.zzar("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzap.zzar("texParameteri");
        zzap2.zzQk = GLES20.glGetUniformLocation((int)zzap2.zzQj, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzap2.zzQk, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzQj != 0;
        if (!bl3 || !bl) {
            String string3 = GLUtils.getEGLErrorString((int)this.zzQp.eglGetError());
            String string4 = String.valueOf(string3);
            String string5 = string4.length() != 0 ? "EGL initialization failed: ".concat(string4) : new String("EGL initialization failed: ");
            zzahd.e((String)string5);
            zzbs.zzbC().zza(new Throwable(string5), "SphericalVideoProcessor.run.1");
            this.zzgh();
            this.zzQn.countDown();
            return;
        }
        this.zzQh = new SurfaceTexture(n7);
        this.zzQh.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzQn.countDown();
        this.zzPX.start();
        try {
            this.zzQt = true;
            while (!this.zzQu) {
                this.zzgg();
                if (this.zzQt) {
                    zzap2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzap2.zzrZ, (int)zzap2.zzsa);
                    zzap.zzar("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzap2.zzQj, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzap2.zzQj, (String)"uFOVy");
                    if (zzap2.zzrZ > zzap2.zzsa) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzap2.zzsa / (float)zzap2.zzrZ));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzap2.zzrZ / (float)zzap2.zzsa));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzQt = false;
                }
                try {
                    Object object3 = this.zzQo;
                    synchronized (object3) {
                        if (!this.zzQu && !this.zzQt && this.zzQl == 0) {
                            this.zzQo.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzahd.zzaT((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzahd.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbs.zzbC().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzPX.stop();
            this.zzQh.setOnFrameAvailableListener(null);
            this.zzQh = null;
            this.zzgh();
        }
    }

    private final void zzgg() {
        while (this.zzQl > 0) {
            this.zzQh.updateTexImage();
            --this.zzQl;
        }
        if (this.zzPX.zza(this.zzPT)) {
            if (Float.isNaN(this.zzQe)) {
                float[] fArray = this.zzPT;
                float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
                float[] fArray3 = this.zzPT;
                float[] fArray4 = new float[]{fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1] + fArray3[2] * fArray2[2], fArray3[3] * fArray2[0] + fArray3[4] * fArray2[1] + fArray3[5] * fArray2[2], fArray3[6] * fArray2[0] + fArray3[7] * fArray2[1] + fArray3[8] * fArray2[2]};
                this.zzQe = -((float)Math.atan2(fArray4[1], fArray4[0]) - 1.5707964f);
            }
            zzap.zzb(this.zzQc, this.zzQe + this.zzQf);
        } else {
            zzap.zza(this.zzPT, -1.5707964f);
            zzap.zzb(this.zzQc, this.zzQf);
        }
        zzap.zza(this.zzPY, 1.5707964f);
        zzap.zza(this.zzPZ, this.zzQc, this.zzPY);
        zzap.zza(this.zzQa, this.zzPT, this.zzPZ);
        zzap.zza(this.zzQb, this.zzQg);
        zzap.zza(this.zzQd, this.zzQb, this.zzQa);
        GLES20.glUniformMatrix3fv((int)this.zzQk, (int)1, (boolean)false, (float[])this.zzQd, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        zzap.zzar("drawArrays");
        GLES20.glFinish();
        this.zzQp.eglSwapBuffers(this.zzQq, this.zzQs);
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzrZ > this.zzsa) {
            f4 = 1.7453293f * f / (float)this.zzrZ;
            f3 = 1.7453293f * f2 / (float)this.zzrZ;
        } else {
            f4 = 1.7453293f * f / (float)this.zzsa;
            f3 = 1.7453293f * f2 / (float)this.zzsa;
        }
        this.zzQf -= f4;
        this.zzQg -= f3;
        if (this.zzQg < -1.5707964f) {
            this.zzQg = -1.5707964f;
        }
        if (this.zzQg > 1.5707964f) {
            this.zzQg = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzc(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        zzap.zzar("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string);
            zzap.zzar("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzap.zzar("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzap.zzar("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzap.zzar("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    private final boolean zzgh() {
        boolean bl = false;
        if (this.zzQs != null && this.zzQs != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzQp.eglMakeCurrent(this.zzQq, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzQp.eglDestroySurface(this.zzQq, this.zzQs);
            this.zzQs = null;
        }
        if (this.zzQr != null) {
            bl |= this.zzQp.eglDestroyContext(this.zzQq, this.zzQr);
            this.zzQr = null;
        }
        if (this.zzQq != null) {
            bl |= this.zzQp.eglTerminate(this.zzQq);
            this.zzQq = null;
        }
        return bl;
    }

    private static void zzar(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string).length()).append(string).append(": glError ").append(n).toString());
        }
    }
}

