/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.overlay.zzag;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzbi;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.ads.internal.zzbu;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzk;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzabb;
import com.google.android.gms.internal.zzaec;
import com.google.android.gms.internal.zzaeh;
import com.google.android.gms.internal.zzaep;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagl;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzags;
import com.google.android.gms.internal.zzagt;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjl;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.internal.zzys;
import com.google.android.gms.internal.zzza;
import com.google.android.gms.internal.zzzk;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zzaaz
public abstract class zza
extends zzka
implements zzag,
zzabb,
zzagy,
zzim,
zzqk,
zzzk {
    protected zznb zzsN;
    private zzmz zzsO;
    private zzmz zzsP;
    protected boolean zzsQ = false;
    protected final zzbi zzsR;
    protected final zzbt zzsS;
    @Nullable
    protected transient zzir zzsT;
    protected final zzfh zzsU;
    protected final zzv zzsV;

    public final zzv zzaj() {
        return this.zzsV;
    }

    zza(zzbt zzbt2, @Nullable zzbi zzbi2, zzv zzv2) {
        this.zzsS = zzbt2;
        this.zzsR = new zzbi(this);
        this.zzsV = zzv2;
        zzbs.zzby().zzE(this.zzsS.zzqG);
        zzbs.zzbC().zzd(this.zzsS.zzqG, this.zzsS.zzvW);
        zzbs.zzbD().initialize(this.zzsS.zzqG);
        this.zzsU = zzbs.zzbC().zzhF();
        zzbs.zzbB().initialize(this.zzsS.zzqG);
        zza zza2 = this;
        zzme<Long> zzme2 = zzmo.zzFH;
        if (zzbs.zzbK().zzd(zzme2).booleanValue()) {
            CountDownLatch countDownLatch;
            Timer timer = new Timer();
            zzme2 = zzmo.zzFJ;
            CountDownLatch countDownLatch2 = countDownLatch = new CountDownLatch((Integer)((Object)zzbs.zzbK().zzd(zzme2)));
            Timer timer2 = timer;
            zzme2 = zza2;
            zzb zzb2 = new zzb((zza)((Object)zzme2), countDownLatch2, timer2);
            zzme2 = zzmo.zzFI;
            timer.schedule((TimerTask)zzb2, 0L, (long)zzbs.zzbK().zzd(zzme2));
        }
    }

    public void destroy() {
        zzbt zzbt2;
        zzbr.zzcz((String)"destroy must be called on the main UI thread.");
        this.zzsR.cancel();
        this.zzsU.zzh(this.zzsS.zzwb);
        zzbt zzbt3 = zzbt2 = this.zzsS;
        if (zzbt2.zzvX != null) {
            zzbt3.zzvX.zzcf();
        }
        zzbt2.zzwf = null;
        zzbt2.zzwg = null;
        zzbt2.zzwr = null;
        zzbt2.zzwh = null;
        zzbt2.zze(false);
        if (zzbt2.zzvX != null) {
            zzbt2.zzvX.removeAllViews();
        }
        zzbt2.zzbZ();
        zzbt2.zzca();
        zzbt2.zzwb = null;
    }

    public final IObjectWrapper zzak() {
        zzbr.zzcz((String)"getAdFrame must be called on the main UI thread.");
        return zzn.zzw((Object)((Object)this.zzsS.zzvX));
    }

    @Nullable
    public final zziv zzal() {
        zzbr.zzcz((String)"getAdSize must be called on the main UI thread.");
        if (this.zzsS.zzwa == null) {
            return null;
        }
        return new zzlv(this.zzsS.zzwa);
    }

    public final boolean isReady() {
        zzbr.zzcz((String)"isLoaded must be called on the main UI thread.");
        return this.zzsS.zzvY == null && this.zzsS.zzvZ == null && this.zzsS.zzwb != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    public boolean zza(zzir zzir2) {
        zzbr.zzcz((String)"loadAd must be called on the main UI thread.");
        zzbs.zzbD().zzcW();
        Object object = zzmo.zzDU;
        if (zzbs.zzbK().zzd(object).booleanValue()) {
            zzir.zzh((zzir)zzir2);
        }
        Object object2 = zzir2;
        zzir zzir3 = zzir2 = zzk.zzaI((Context)this.zzsS.zzqG) && object2.zzzY != null ? new zzis(object2).zza(null).zzdi() : object2;
        if (this.zzsS.zzvY != null || this.zzsS.zzvZ != null) {
            if (this.zzsT != null) {
                zzahd.zzaT((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzahd.zzaT((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzsT = zzir2;
            return false;
        }
        zzahd.zzaS((String)"Starting ad request.");
        object = this;
        object2 = zzmo.zzCT;
        this.zzsN = new zznb((Boolean)zzbs.zzbK().zzd(object2), "load_ad", ((zza)object).zzsS.zzwa.zzAv);
        ((zza)object).zzsO = new zzmz(-1L, null, null);
        ((zza)object).zzsP = new zzmz(-1L, null, null);
        this.zzsO = this.zzsN.zzdR();
        if (zzir2.zzzT) {
            zzahd.zzaS((String)"This request is sent from a test device.");
        } else {
            zzji.zzdr();
            String string = String.valueOf(zzakk.zzV((Context)this.zzsS.zzqG));
            zzahd.zzaS((String)new StringBuilder(71 + String.valueOf(string).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string).append("\") to get test ads on this device.").toString());
        }
        this.zzsR.zzf(zzir2);
        this.zzsQ = this.zza(zzir2, this.zzsN);
        return this.zzsQ;
    }

    protected abstract boolean zza(zzir var1, zznb var2);

    @Override
    public final void zza(zzags zzags2) {
        long l;
        if (zzags2.zzYa.zzTu != -1L && !TextUtils.isEmpty((CharSequence)zzags2.zzYa.zzTD) && (l = zza.zzr(zzags2.zzYa.zzTD)) != -1L) {
            zzmz zzmz2 = this.zzsN.zzc(zzags2.zzYa.zzTu + l);
            this.zzsN.zza(zzmz2, "stc");
        }
        this.zzsN.zzO(zzags2.zzYa.zzTD);
        this.zzsN.zza(this.zzsO, "arf");
        this.zzsP = this.zzsN.zzdR();
        this.zzsN.zzh("gqi", zzags2.zzYa.zzTE);
        this.zzsS.zzvY = null;
        this.zzsS.zzwc = zzags2;
        zzags2.zzXZ.zza(new zzc(this, zzags2));
        zzags2.zzXZ.zzde();
        this.zza(zzags2, this.zzsN);
    }

    protected abstract void zza(zzags var1, zznb var2);

    boolean zza(zzagr zzagr2) {
        return false;
    }

    @Override
    public void zzb(zzagr zzagr2) {
        this.zzsN.zza(this.zzsP, "awr");
        this.zzsS.zzvZ = null;
        if (zzagr2.errorCode != -2 && zzagr2.errorCode != 3) {
            zzbs.zzbC().zzb(this.zzsS.zzbY());
        }
        if (zzagr2.errorCode == -1) {
            this.zzsQ = false;
            return;
        }
        if (this.zza(zzagr2)) {
            zzahd.zzaC((String)"Ad refresh scheduled.");
        }
        if (zzagr2.errorCode != -2) {
            this.zze(zzagr2.errorCode);
            return;
        }
        if (this.zzsS.zzwu == null) {
            this.zzsS.zzwu = new zzagz(this.zzsS.zzvU);
        }
        this.zzsU.zzg(this.zzsS.zzwb);
        if (this.zza(this.zzsS.zzwb, zzagr2)) {
            this.zzsS.zzwb = zzagr2;
            zzbt zzbt2 = this.zzsS;
            if (zzbt2.zzwd != null) {
                if (zzbt2.zzwb != null) {
                    zzbt2.zzwd.zzh(zzbt2.zzwb.zzXT);
                    zzbt2.zzwd.zzi(zzbt2.zzwb.zzXU);
                    zzbt2.zzwd.zzw(zzbt2.zzwb.zzTq);
                }
                zzbt2.zzwd.zzv(zzbt2.zzwa.zzAw);
            }
            this.zzsN.zzh("is_mraid", this.zzsS.zzwb.zzcm() ? "1" : "0");
            this.zzsN.zzh("is_mediation", this.zzsS.zzwb.zzTq ? "1" : "0");
            if (this.zzsS.zzwb.zzPi != null && this.zzsS.zzwb.zzPi.zziv() != null) {
                this.zzsN.zzh("is_delay_pl", this.zzsS.zzwb.zzPi.zziv().zziR() ? "1" : "0");
            }
            this.zzsN.zza(this.zzsO, "ttc");
            if (zzbs.zzbC().zzhq() != null) {
                zzbs.zzbC().zzhq().zza(this.zzsN);
            }
            this.zzav();
            if (this.zzsS.zzcb()) {
                this.zzar();
            }
        }
        if (zzagr2.zzMh != null) {
            zzbs.zzby().zza(this.zzsS.zzqG, zzagr2.zzMh);
        }
    }

    protected abstract boolean zza(@Nullable zzagr var1, zzagr var2);

    public void onAdClicked() {
        if (this.zzsS.zzwb == null) {
            zzahd.zzaT((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzahd.zzaC((String)"Pinging click URLs.");
        if (this.zzsS.zzwd != null) {
            this.zzsS.zzwd.zzhc();
        }
        if (this.zzsS.zzwb.zzMe != null) {
            zzbs.zzby();
            zzail.zza(this.zzsS.zzqG, this.zzsS.zzvW.zzaS, this.zzb(this.zzsS.zzwb.zzMe));
        }
        if (this.zzsS.zzwe != null) {
            try {
                this.zzsS.zzwe.onAdClicked();
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public final void zzam() {
        this.zzap();
    }

    @Override
    public final void onAppEvent(String string, @Nullable String string2) {
        if (this.zzsS.zzwg != null) {
            try {
                this.zzsS.zzwg.onAppEvent(string, string2);
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public final void zzan() {
        zzbr.zzcz((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzsS.zzwb == null) {
            zzahd.zzaT((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzahd.zzaC((String)"Pinging manual tracking URLs.");
        if (this.zzsS.zzwb.zzTs != null && !this.zzsS.zzwb.zzXX) {
            zzbs.zzby();
            zzail.zza(this.zzsS.zzqG, this.zzsS.zzvW.zzaS, this.zzsS.zzwb.zzTs);
            this.zzsS.zzwb.zzXX = true;
        }
    }

    public void pause() {
        zzbr.zzcz((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        zzbr.zzcz((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzb(zzir zzir2) {
        if (this.zzsS.zzvX == null) {
            return false;
        }
        ViewParent viewParent = this.zzsS.zzvX.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzbs.zzby().zza(view, view.getContext());
    }

    public final void zza(zzjo zzjo2) {
        zzbr.zzcz((String)"setAdListener must be called on the main UI thread.");
        this.zzsS.zzwf = zzjo2;
    }

    public final void zza(zzaep zzaep2) {
        zzbr.zzcz((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzsS.zzws = zzaep2;
    }

    public final void setUserId(String string) {
        zzahd.zzaT((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public final void zza(zzjl zzjl2) {
        zzbr.zzcz((String)"setAdListener must be called on the main UI thread.");
        this.zzsS.zzwe = zzjl2;
    }

    public final void zza(zziv zziv2) {
        zzbr.zzcz((String)"setAdSize must be called on the main UI thread.");
        this.zzsS.zzwa = zziv2;
        if (this.zzsS.zzwb != null && this.zzsS.zzwb.zzPi != null && this.zzsS.zzww == 0) {
            this.zzsS.zzwb.zzPi.zza(zziv2);
        }
        if (this.zzsS.zzvX == null) {
            return;
        }
        if (this.zzsS.zzvX.getChildCount() > 1) {
            this.zzsS.zzvX.removeView(this.zzsS.zzvX.getNextView());
        }
        this.zzsS.zzvX.setMinimumWidth(zziv2.widthPixels);
        this.zzsS.zzvX.setMinimumHeight(zziv2.heightPixels);
        this.zzsS.zzvX.requestLayout();
    }

    public final void zza(zzke zzke2) {
        zzbr.zzcz((String)"setAppEventListener must be called on the main UI thread.");
        this.zzsS.zzwg = zzke2;
    }

    public void zza(zzys zzys2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    public void zza(zznh zznh2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public final void zza(zzza zzza2, String string) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    public final void zza(zzkk zzkk2) {
        zzbr.zzcz((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzsS.zzwh = zzkk2;
    }

    public final void stopLoading() {
        zzbr.zzcz((String)"stopLoading must be called on the main UI thread.");
        this.zzsQ = false;
        this.zzsS.zze(true);
    }

    public final boolean isLoading() {
        return this.zzsQ;
    }

    public zzks getVideoController() {
        return null;
    }

    public final void zza(@Nullable zzlx zzlx2) {
        zzbr.zzcz((String)"setVideoOptions must be called on the main UI thread.");
        this.zzsS.zzwn = zzlx2;
    }

    public final void zza(@Nullable zzky zzky2) {
        zzbr.zzcz((String)"setIconAdOptions must be called on the main UI thread.");
        this.zzsS.zzwo = zzky2;
    }

    public void setImmersiveMode(boolean bl) {
        throw new IllegalStateException("onImmersiveModeUpdated is not supported for current ad type");
    }

    private static long zzr(String string) {
        int n = string.indexOf("ufe");
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        try {
            return Long.parseLong(string.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzahd.zzaT((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzahd.zzaT((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected final void zzb(View view) {
        zzbu zzbu2 = this.zzsS.zzvX;
        if (zzbu2 != null) {
            zzbu2.addView(view, zzbs.zzbA().zzhV());
        }
    }

    protected void zzao() {
        zzahd.zzaS((String)"Ad closing.");
        if (this.zzsS.zzwf != null) {
            try {
                this.zzsS.zzwf.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzsS.zzws != null) {
            try {
                this.zzsS.zzws.onRewardedVideoAdClosed();
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected final void zzap() {
        zzahd.zzaS((String)"Ad leaving application.");
        if (this.zzsS.zzwf != null) {
            try {
                this.zzsS.zzwf.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzsS.zzws != null) {
            try {
                this.zzsS.zzws.onRewardedVideoAdLeftApplication();
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected final void zzaq() {
        zzahd.zzaS((String)"Ad opening.");
        if (this.zzsS.zzwf != null) {
            try {
                this.zzsS.zzwf.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzsS.zzws != null) {
            try {
                this.zzsS.zzws.onRewardedVideoAdOpened();
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzar() {
        zzahd.zzaS((String)"Ad finished loading.");
        this.zzsQ = false;
        if (this.zzsS.zzwf != null) {
            try {
                this.zzsS.zzwf.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzsS.zzws != null) {
            try {
                this.zzsS.zzws.onRewardedVideoAdLoaded();
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zze(int n) {
        zzahd.zzaT((String)new StringBuilder(30).append("Failed to load ad: ").append(n).toString());
        this.zzsQ = false;
        if (this.zzsS.zzwf != null) {
            try {
                this.zzsS.zzwf.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzsS.zzws != null) {
            try {
                this.zzsS.zzws.onRewardedVideoAdFailedToLoad(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    public final void zzas() {
        zzahd.zzaS((String)"Ad impression.");
        if (this.zzsS.zzwf != null) {
            try {
                this.zzsS.zzwf.onAdImpression();
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call AdListener.onAdImpression().", (Throwable)remoteException);
            }
        }
    }

    public final void zzat() {
        zzahd.zzaS((String)"Ad clicked.");
        if (this.zzsS.zzwf != null) {
            try {
                this.zzsS.zzwf.onAdClicked();
                return;
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not call AdListener.onAdClicked().", (Throwable)remoteException);
            }
        }
    }

    protected final void zzau() {
        if (this.zzsS.zzws == null) {
            return;
        }
        try {
            this.zzsS.zzws.onRewardedVideoStarted();
            return;
        }
        catch (RemoteException remoteException) {
            zzahd.zzc((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
            return;
        }
    }

    protected final void zza(@Nullable zzafq zzafq2) {
        if (this.zzsS.zzws == null) {
            return;
        }
        try {
            String string = "";
            int n = 1;
            if (zzafq2 != null) {
                string = zzafq2.type;
                n = zzafq2.zzWY;
            }
            this.zzsS.zzws.zza((zzaeh)new zzaec(string, n));
            return;
        }
        catch (RemoteException remoteException) {
            zzahd.zzc((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
            return;
        }
    }

    public final void zzav() {
        zzagr zzagr2 = this.zzsS.zzwb;
        zza zza2 = this;
        if (zzagr2 == null || TextUtils.isEmpty((CharSequence)zzagr2.zzTM) || zzagr2.zzXY || !zzbs.zzbG().zzib()) {
            return;
        }
        zzahd.zzaC((String)"Sending troubleshooting signals to the server.");
        zzbs.zzbG().zza(zza2.zzsS.zzqG, zza2.zzsS.zzvW.zzaS, zzagr2.zzTM, zza2.zzsS.zzvU);
        zzagr2.zzXY = true;
    }

    @Override
    public final void zza(HashSet<zzagt> hashSet) {
        this.zzsS.zza(hashSet);
    }

    protected final List<String> zzb(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(zzagl.zzb(string, this.zzsS.zzqG));
        }
        return arrayList;
    }

    public String getAdUnitId() {
        return this.zzsS.zzvU;
    }

    public final zzke zzaw() {
        return this.zzsS.zzwg;
    }

    public final zzjo zzax() {
        return this.zzsS.zzwf;
    }
}

