/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzach;
import com.google.android.gms.internal.zzaci;
import com.google.android.gms.internal.zzahd;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzaaz
public final class zzacg
extends zza {
    public static final Parcelable.Creator<zzacg> CREATOR = new zzaci();
    private ParcelFileDescriptor zzTR;
    private Parcelable zzTS;
    private boolean zzTT;

    zzacg(ParcelFileDescriptor parcelFileDescriptor) {
        this.zzTR = parcelFileDescriptor;
        this.zzTS = null;
        this.zzTT = true;
    }

    public zzacg(SafeParcelable safeParcelable) {
        this.zzTR = null;
        this.zzTS = safeParcelable;
        this.zzTT = false;
    }

    public final <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzTT) {
            byte[] byArray;
            if (this.zzTR == null) {
                zzahd.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzTR));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzp.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzTS = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzTT = false;
        }
        return (T)((SafeParcelable)this.zzTS);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        if (this.zzTR == null) {
            byte[] byArray;
            Parcel parcel2 = Parcel.obtain();
            try {
                this.zzTS.writeToParcel(parcel2, 0);
                byArray = parcel2.marshall();
            }
            finally {
                parcel2.recycle();
            }
            this.zzTR = this.zzc(byArray);
        }
        Parcel parcel3 = parcel;
        zzacg zzacg2 = this;
        int n2 = zzd.zze((Parcel)parcel3);
        zzd.zza((Parcel)parcel3, (int)2, (Parcelable)zzacg2.zzTR, (int)n, (boolean)false);
        zzd.zzI((Parcel)parcel3, (int)n2);
    }

    private final <T> ParcelFileDescriptor zzc(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzach zzach2 = new zzach(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzach2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzahd.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbs.zzbC().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzp.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

