/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.zzbl;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzaiq;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzalh;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzaln;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzamc;
import com.google.android.gms.internal.zzamd;
import com.google.android.gms.internal.zzame;
import com.google.android.gms.internal.zzamh;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.internal.zzyg;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzaaz
final class zzama
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzalm {
    private final zzamd zzabU;
    private final Object mLock = new Object();
    @Nullable
    private final zzcu zzIf;
    private final zzakq zztZ;
    private final zzbl zzabV;
    private final zzv zzsV;
    private zzaln zzabW;
    private zzm zzabX;
    private zziv zzvc;
    private boolean zzabY;
    private boolean zzabZ;
    private boolean zzaca;
    private boolean zzacb;
    private Boolean zzYC;
    private int zzacc;
    private boolean zzacd = true;
    private boolean zzace = false;
    private String zzQz = "";
    private zzame zzacf;
    private boolean zzacg;
    private boolean zzach;
    private zznw zzaci;
    private int zzacj;
    private int zzack;
    private zzmz zzacl;
    private zzmz zzQA;
    private zzmz zzacm;
    private zzna zzacn;
    private WeakReference<View.OnClickListener> zzaco;
    private zzm zzacp;
    private boolean zzacq;
    private zzakj zzwF;
    private int zzOb = -1;
    private int zzOa = -1;
    private int zzOd = -1;
    private int zzOe = -1;
    private Map<String, zzsb> zzacr;
    private final WindowManager zzwU;
    private final zzig zzacs;

    static zzama zzb(Context context, zziv zziv2, boolean bl, boolean bl2, @Nullable zzcu zzcu2, zzakq zzakq2, zznb zznb2, zzbl zzbl2, zzv zzv2, zzig zzig2) {
        zzamd zzamd2 = new zzamd(context);
        return new zzama(zzamd2, zziv2, bl, bl2, zzcu2, zzakq2, zznb2, zzbl2, zzv2, zzig2);
    }

    private zzama(zzamd zzamd2, zziv zziv2, boolean bl, boolean bl2, @Nullable zzcu zzcu2, zzakq zzakq2, zznb zznb2, zzbl zzbl2, zzv zzv2, zzig zzig2) {
        super((Context)zzamd2);
        this.zzabU = zzamd2;
        this.zzvc = zziv2;
        this.zzaca = bl;
        this.zzacc = -1;
        this.zzIf = zzcu2;
        this.zztZ = zzakq2;
        this.zzabV = zzbl2;
        this.zzsV = zzv2;
        this.zzwU = (WindowManager)this.getContext().getSystemService("window");
        this.zzacs = zzig2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzahd.zzb((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        WebSettings webSettings2 = webSettings;
        String string2 = zzakq2.zzaS;
        zzamd zzamd3 = zzamd2;
        zzail zzail2 = zzbs.zzby();
        webSettings2.setUserAgentString(zzail2.zzs((Context)zzamd3, string2));
        zzbs.zzbA().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzjc();
        if (zzs.zzrZ()) {
            this.addJavascriptInterface(new zzamh(this), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzwF = new zzakj(this.zzabU.zzir(), (View)this, this, null);
        this.zzd(zznb2);
        zzbs.zzbA().zzR((Context)zzamd2);
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzaln) {
            this.zzabW = (zzaln)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zzv zzaj() {
        return this.zzsV;
    }

    private final boolean zzja() {
        int n;
        int n2;
        if (!this.zzabW.zzcm() && !this.zzabW.zziO()) {
            return false;
        }
        zzbs.zzby();
        DisplayMetrics displayMetrics = zzail.zza(this.zzwU);
        zzji.zzdr();
        int n3 = zzakk.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzji.zzdr();
        int n4 = zzakk.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.heightPixels);
        Activity activity = this.zzabU.zzir();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbs.zzby();
            int[] nArray = zzail.zzf(activity);
            zzji.zzdr();
            n2 = zzakk.zzb((DisplayMetrics)displayMetrics, (int)nArray[0]);
            zzji.zzdr();
            n = zzakk.zzb((DisplayMetrics)displayMetrics, (int)nArray[1]);
        }
        if (this.zzOa == n3 && this.zzOb == n4 && this.zzOd == n2 && this.zzOe == n) {
            return false;
        }
        boolean bl = this.zzOa != n3 || this.zzOb != n4;
        this.zzOa = n3;
        this.zzOb = n4;
        this.zzOd = n2;
        this.zzOe = n;
        new zzyg(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzwU.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzbs.zzby().zzj(map);
        }
        catch (JSONException jSONException) {
            zzahd.zzaT((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public final void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzahd.zzaT((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzaW(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzahd.zzaT((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadUrl(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Throwable throwable) {
                    zzbs.zzbC().zza(throwable, "AdWebViewImpl.loadUrl");
                    zzahd.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
                }
            } else {
                zzahd.zzaT((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaU(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                zzbs.zzbC().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
                zzahd.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadData(String string2, String string3, String string4) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzahd.zzaT((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzahd.zzaT((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzaX(String string2) {
        if (zzs.zzsb()) {
            Object object;
            zzama zzama2;
            if (this.zzhv() == null) {
                zzama2 = this;
                object = zzama2.mLock;
                synchronized (object) {
                    zzama2.zzYC = zzbs.zzbC().zzhv();
                    if (zzama2.zzYC == null) {
                        try {
                            String string3 = "(function(){})()";
                            zzama2.evaluateJavascript(string3, null);
                            zzama2.zza(true);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzama2.zza(false);
                        }
                    }
                }
            }
            if (this.zzhv().booleanValue()) {
                object = string2;
                zzama2 = this;
                Object object2 = zzama2.mLock;
                synchronized (object2) {
                    if (!zzama2.isDestroyed()) {
                        zzama2.evaluateJavascript((String)object, null);
                    } else {
                        zzahd.zzaT((String)"The webview is destroyed. Ignoring action.");
                    }
                    return;
                }
            }
            String string4 = String.valueOf(string2);
            this.zzaW(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
            return;
        }
        String string5 = String.valueOf(string2);
        this.zzaW(string5.length() != 0 ? "javascript:".concat(string5) : new String("javascript:"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzYC = bl;
        }
        zzbs.zzbC().zza(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Boolean zzhv() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzYC;
        }
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzi(string2, string3);
    }

    @Override
    public final void zzi(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzaX(string4);
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzahd.zzaC((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzaX(stringBuilder.toString());
    }

    @Override
    public final void zzip() {
        this.zzjb();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zztZ.zzaS);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzA(int n) {
        if (n == 0) {
            zzama zzama2 = this;
            zzmu.zza(zzama2.zzacn.zzdQ(), zzama2.zzQA, "aebb2");
        }
        this.zzjb();
        if (this.zzacn.zzdQ() != null) {
            this.zzacn.zzdQ().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zztZ.zzaS);
        this.zza("onhide", hashMap);
    }

    private final void zzjb() {
        zzmu.zza(this.zzacn.zzdQ(), this.zzQA, "aeh2");
    }

    @Override
    public final void zzfO() {
        if (this.zzacl == null) {
            zzmu.zza(this.zzacn.zzdQ(), this.zzQA, "aes2");
            this.zzacl = zzmu.zzb(this.zzacn.zzdQ());
            this.zzacn.zza("native:view_show", this.zzacl);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zztZ.zzaS);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zziq() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        zzbs.zzby();
        hashMap.put("app_muted", String.valueOf(zzail.zzbg()));
        zzbs.zzby();
        hashMap.put("app_volume", String.valueOf(zzail.zzbe()));
        zzbs.zzby();
        hashMap.put("device_volume", String.valueOf(zzail.zzM(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzm zzit() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzabX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzm zziu() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zziv zzal() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzvc;
        }
    }

    @Override
    public final zzaln zziv() {
        return this.zzabW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zziw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzabY;
        }
    }

    @Override
    public final zzcu zzix() {
        return this.zzIf;
    }

    @Override
    public final zzakq zziy() {
        return this.zztZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zziz() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaca;
        }
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbs.zzby();
            zzail.zzb(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzahd.zzaC((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzabW.zziO()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.zzaci != null) {
                    this.zzaci.zzc(motionEvent);
                }
            }
        } else if (this.zzIf != null) {
            this.zzIf.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzme<Boolean> zzme2 = zzmo.zzDI;
        if (zzbs.zzbK().zzd(zzme2).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected final void onMeasure(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzaca || this.zzvc.zzAy) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzvc.zzAz) {
                int n3;
                Object object2 = zzmo.zzFG;
                if (zzbs.zzbK().zzd(object2).booleanValue() || !zzs.zzrZ()) {
                    super.onMeasure(n, n2);
                    return;
                }
                object2 = this;
                this.zza("/contentHeight", new zzamb((zzama)object2));
                String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
                this.zzaX(string2);
                float f = this.zzabU.getResources().getDisplayMetrics().density;
                int n4 = View.MeasureSpec.getSize((int)n);
                switch (this.zzack) {
                    case -1: {
                        n3 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n3 = (int)((float)this.zzack * f);
                    }
                }
                this.setMeasuredDimension(n4, n3);
                return;
            }
            if (this.zzvc.zzAw) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzwU.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            int n9 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n9 = n6;
            }
            int n10 = Integer.MAX_VALUE;
            if (n7 == Integer.MIN_VALUE || n7 == 0x40000000) {
                n10 = n8;
            }
            if (this.zzvc.widthPixels > n9 || this.zzvc.heightPixels > n10) {
                float f = this.zzabU.getResources().getDisplayMetrics().density;
                int n11 = (int)((float)this.zzvc.widthPixels / f);
                int n12 = (int)((float)this.zzvc.heightPixels / f);
                int n13 = (int)((float)n6 / f);
                int n14 = (int)((float)n8 / f);
                zzahd.zzaT((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n11).append("x").append(n12).append(" dp, but only has ").append(n13).append("x").append(n14).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzvc.widthPixels, this.zzvc.heightPixels);
            }
            return;
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzja();
        zzm zzm2 = this.zzit();
        if (zzm2 != null && bl) {
            zzm2.zzfN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(Context context, zziv zziv2, zznb zznb2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzwF.zzig();
            this.setContext(context);
            this.zzabX = null;
            this.zzvc = zziv2;
            this.zzaca = false;
            this.zzabY = false;
            this.zzQz = "";
            this.zzacc = -1;
            zzbs.zzbA();
            zzaiq.zzl(this);
            this.loadUrl("about:blank");
            this.zzabW.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzacd = true;
            this.zzace = false;
            this.zzacf = null;
            this.zzd(zznb2);
            this.zzacg = false;
            this.zzacj = 0;
            zzbs.zzbV();
            zzsa.zze(this);
            this.zzje();
            return;
        }
    }

    private final void zzd(zznb zznb2) {
        this.zzjf();
        this.zzacn = new zzna(new zznb(true, "make_wv", this.zzvc.zzAv));
        this.zzacn.zzdQ().zzc(zznb2);
        this.zzQA = zzmu.zzb(this.zzacn.zzdQ());
        this.zzacn.zza("native:view_create", this.zzQA);
        this.zzacm = null;
        this.zzacl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zzm zzm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzabX = zzm2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(zzm zzm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacp = zzm2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zziv zziv2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzvc = zziv2;
            this.requestLayout();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzA(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl2 = bl != this.zzaca;
            this.zzaca = bl;
            this.zzjc();
            if (bl2) {
                new zzyg(this).zzap(bl ? "expanded" : "default");
            }
            return;
        }
    }

    @Override
    public final void zziI() {
        this.zzwF.zzif();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onAttachedToWindow() {
        Object object = this.mLock;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzwF.onAttachedToWindow();
            }
            boolean bl = this.zzacg;
            if (this.zzabW != null && this.zzabW.zziO()) {
                bl = true;
                if (!this.zzach) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzabW.zziP();
                    if (onGlobalLayoutListener != null) {
                        zzbs.zzbW();
                        zzalh.zza((View)this, onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzabW.zziQ()) != null) {
                        zzbs.zzbW();
                        zzalh.zza((View)this, onScrollChangedListener);
                    }
                    this.zzach = true;
                }
                this.zzja();
            }
            this.zzF(bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzwF.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzach && this.zzabW != null && this.zzabW.zziO() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzabW.zziP();
                if (onGlobalLayoutListener != null) {
                    zzbs.zzbA().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzabW.zziQ()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzach = false;
            }
        }
        this.zzF(false);
    }

    @Override
    public final void setContext(Context context) {
        this.zzabU.setBaseContext(context);
        this.zzwF.zzi(this.zzabU.zzir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzB(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzabX != null) {
                this.zzabX.zza(this.zzabW.zzcm(), bl);
            } else {
                this.zzabY = bl;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getRequestedOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setRequestedOrientation(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacc = n;
            if (this.zzabX != null) {
                this.zzabX.setRequestedOrientation(this.zzacc);
            }
            return;
        }
    }

    @Override
    public final Activity zzir() {
        return this.zzabU.zzir();
    }

    @Override
    public final Context zzis() {
        return this.zzabU.zzis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzjc() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzaca || this.zzvc.zzAw) {
                zzahd.zzaC((String)"Enabling hardware acceleration on an overlay.");
                this.zzjd();
            } else if (Build.VERSION.SDK_INT < 18) {
                zzahd.zzaC((String)"Disabling hardware acceleration on an AdView.");
                zzama zzama2 = this;
                Object object2 = zzama2.mLock;
                synchronized (object2) {
                    if (!zzama2.zzacb) {
                        zzbs.zzbA().zzr((View)zzama2);
                    }
                    zzama2.zzacb = true;
                }
            } else {
                zzahd.zzaC((String)"Enabling hardware acceleration on an AdView.");
                this.zzjd();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzjd() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzacb) {
                zzbs.zzbA().zzq((View)this);
            }
            this.zzacb = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzjf();
            this.zzwF.zzig();
            if (this.zzabX != null) {
                this.zzabX.close();
                this.zzabX.onDestroy();
                this.zzabX = null;
            }
            this.zzabW.reset();
            if (this.zzabZ) {
                return;
            }
            zzbs.zzbV();
            zzsa.zze(this);
            this.zzje();
            this.zzabZ = true;
            zzahd.v("Initiating WebView self destruct sequence in 3...");
            this.zzabW.zziS();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            if (this.mLock != null) {
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.zzabZ) {
                        this.zzabW.reset();
                        zzbs.zzbV();
                        zzsa.zze(this);
                        this.zzje();
                        this.zzhH();
                    }
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zziA() {
        Object object = this.mLock;
        synchronized (object) {
            zzahd.v("Destroying WebView!");
            this.zzhH();
            zzail.zzZt.post((Runnable)new zzamc(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzhH() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzacq) {
                this.zzacq = true;
                zzbs.zzbC().zzhH();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzabZ;
        }
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzabW != null && this.zzabW.zziZ() != null) {
            this.zzabW.zziZ().zzaR();
        }
    }

    @Override
    public final void zziJ() {
        if (this.zzacm == null) {
            this.zzacm = zzmu.zzb(this.zzacn.zzdQ());
            this.zzacn.zza("native:view_load", this.zzacm);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzahd.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzahd.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzahd.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzC(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacd = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zziB() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zziC() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaI() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzace = true;
            if (this.zzabV != null) {
                this.zzabV.zzaI();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaJ() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzace = false;
            if (this.zzabV != null) {
                this.zzabV.zzaJ();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzje() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacr = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaV(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzQz = string2 == null ? "" : string2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getRequestId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzQz;
        }
    }

    @Override
    public final zzall zziD() {
        return null;
    }

    @Override
    public final zzmz zziE() {
        return this.zzQA;
    }

    @Override
    public final zzna zziF() {
        return this.zzacn;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzaco = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener zziK() {
        return (View.OnClickListener)this.zzaco.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zznw zznw2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzaci = zznw2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zznw zziL() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaci;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzame zziG() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzame zzame2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzacf != null) {
                zzahd.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzacf = zzame2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zziH() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzacj > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzD(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacj += bl ? 1 : -1;
            if (this.zzacj <= 0 && this.zzabX != null) {
                this.zzabX.zzfQ();
            }
            return;
        }
    }

    private final void zzjf() {
        if (this.zzacn == null) {
            return;
        }
        zznb zznb2 = this.zzacn.zzdQ();
        if (zznb2 != null && zzbs.zzbC().zzhq() != null) {
            zzbs.zzbC().zzhq().zza(zznb2);
        }
    }

    @Override
    public final void zziM() {
        this.setBackgroundColor(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzgh zzgh2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzacg = zzgh2.zzxV;
        }
        this.zzF(zzgh2.zzxV);
    }

    private final void zzF(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzrd zzrd2) {
        if (this.zzabW != null) {
            this.zzabW.zza(string2, zzrd2);
        }
    }

    @Override
    public final void zzb(String string2, zzrd zzrd2) {
        if (this.zzabW != null) {
            this.zzabW.zzb(string2, zzrd2);
        }
    }

    static /* synthetic */ Object zza(zzama zzama2) {
        return zzama2.mLock;
    }

    static /* synthetic */ int zzb(zzama zzama2) {
        return zzama2.zzack;
    }

    static /* synthetic */ int zza(zzama zzama2, int n) {
        zzama2.zzack = n;
        return zzama2.zzack;
    }

    static /* synthetic */ void zzc(zzama zzama2) {
        super.destroy();
    }
}

