/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzakd;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzfg;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zziv;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzaaz
public final class zzfi
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object mLock = new Object();
    private final WeakReference<zzagr> zzwQ;
    private WeakReference<ViewTreeObserver> zzwR;
    private final zzgs zzwS;
    protected final zzfg zzwT;
    private final Context mApplicationContext;
    private final WindowManager zzwU;
    private final PowerManager zzwV;
    private final KeyguardManager zzwW;
    private final DisplayMetrics zzwX;
    @Nullable
    private zzfp zzwY;
    private boolean zzwZ;
    private boolean zzuY = false;
    private boolean zzxa = false;
    private boolean zzxb;
    private boolean zzxc;
    private boolean zzxd;
    @Nullable
    private BroadcastReceiver zzxe;
    private final HashSet<Object> zzxf = new HashSet();
    private zzakd zzwA;
    private final HashSet<zzgd> zzxg = new HashSet();
    private final Rect zzxh = new Rect();
    private final zzfl zzxi;
    private float zzxj;

    public zzfi(Context context, zziv zziv2, zzagr zzagr2, zzakq zzakq2, zzgs zzgs2) {
        this.zzwQ = new WeakReference<zzagr>(zzagr2);
        this.zzwS = zzgs2;
        this.zzwR = new WeakReference<Object>(null);
        this.zzxb = true;
        this.zzxd = false;
        this.zzwA = new zzakd(200L);
        this.zzwT = new zzfg(UUID.randomUUID().toString(), zzakq2, zziv2.zzAv, zzagr2.zzXN, zzagr2.zzcm(), zziv2.zzAy);
        this.zzwU = (WindowManager)context.getSystemService("window");
        this.zzwV = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzwW = (KeyguardManager)context.getSystemService("keyguard");
        this.mApplicationContext = context;
        this.zzxi = new zzfl(this, new Handler());
        this.mApplicationContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzxi);
        this.zzwX = context.getResources().getDisplayMetrics();
        Display display = this.zzwU.getDefaultDisplay();
        this.zzxh.right = display.getWidth();
        this.zzxh.bottom = display.getHeight();
        this.zzco();
    }

    public final void zzco() {
        zzbs.zzby();
        this.zzxj = zzail.zzM(this.mApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcp() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzxb) {
                this.zzxc = true;
                try {
                    JSONObject jSONObject = this.zzct();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzahd.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzahd.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzwT.zzcl());
                zzahd.zzaC((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzg(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzgd> iterator = this.zzxg.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzcx()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzxb) {
                return;
            }
            View view = this.zzwS.zzcu();
            boolean bl3 = view != null && zzbs.zzby().zza(view, this.zzwV, this.zzwW);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzwS.zzcv()) {
                this.zzcp();
                return;
            }
            if (n == 1 && !this.zzwA.tryAcquire() && bl == this.zzxd) {
                return;
            }
            if (!bl && !this.zzxd && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzxd = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzahd.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzfi zzfi2 = this;
            View view2 = zzfi2.zzwS.zzcw().zzcu();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzfi2.zzwR.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzfi2.zzcs();
                    if (!zzfi2.zzwZ || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzfi2.zzwZ = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzfi2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzfi2);
                    }
                    zzfi2.zzwR = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzcq();
            return;
        }
    }

    private final void zzcq() {
        if (this.zzwY != null) {
            this.zzwY.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcr() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzxb;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zzb(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzwT.zzcl());
    }

    final void zzb(zzalm zzalm2, Map<String, String> map) {
        this.zzg(3);
    }

    final void zza(zzgd zzgd2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzwT.zzcl());
        zzahd.zzaC((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzgd2);
    }

    final void zzc(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        if (!"1".equals(map.get("isVisible"))) {
            "true".equals(map.get("isVisible"));
        }
        Iterator<Object> iterator = this.zzxf.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private final void zzcs() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzwR.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzct() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = jSONObject.put("afmaVersion", (Object)this.zzwT.zzcj()).put("activeViewJSON", (Object)this.zzwT.zzck()).put("timestamp", zzbs.zzbE().elapsedRealtime()).put("adFormat", (Object)this.zzwT.zzci()).put("hashCode", (Object)this.zzwT.zzcl()).put("isMraid", this.zzwT.zzcm()).put("isStopped", this.zzxa).put("isPaused", this.zzuY).put("isNative", this.zzwT.zzcn()).put("isScreenOn", this.isScreenOn());
        zzbs.zzby();
        JSONObject jSONObject3 = jSONObject2.put("appMuted", zzail.zzbg());
        zzbs.zzby();
        jSONObject3.put("appVolume", (double)zzail.zzbe()).put("deviceVolume", (double)this.zzxj);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzfi.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzfi zzfi2 = this;
            ArrayList<zzgd> arrayList = new ArrayList<zzgd>(zzfi2.zzxg);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzgd zzgd2 = arrayList.get(i);
                zzgd2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzahd.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzgd zzgd2) {
        if (this.zzxg.isEmpty()) {
            zzfi zzfi2 = this;
            Object object = zzfi2.mLock;
            synchronized (object) {
                if (zzfi2.zzxe != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzfi2.zzxe = new zzfj(zzfi2);
                    zzfi2.mApplicationContext.registerReceiver(zzfi2.zzxe, intentFilter);
                }
            }
            this.zzg(3);
        }
        this.zzxg.add(zzgd2);
        try {
            JSONObject jSONObject = zzfi.zza(this.zza(this.zzwS.zzcu(), null));
            zzgd2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzahd.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzgd zzgd2) {
        this.zzxg.remove(zzgd2);
        zzgd2.zzcy();
        if (this.zzxg.isEmpty()) {
            zzfi zzfi2 = this;
            Object object = zzfi2.mLock;
            synchronized (object) {
                zzfi2.zzcs();
                zzfi zzfi3 = zzfi2;
                Object object2 = zzfi3.mLock;
                synchronized (object2) {
                    if (zzfi3.zzxe != null) {
                        try {
                            zzfi3.mApplicationContext.unregisterReceiver(zzfi3.zzxe);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzahd.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbs.zzbC().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzfi3.zzxe = null;
                    }
                }
                zzfi2.mApplicationContext.getContentResolver().unregisterContentObserver((ContentObserver)zzfi2.zzxi);
                zzfi2.zzxb = false;
                zzfi2.zzcq();
                zzfi3 = zzfi2;
                ArrayList<zzgd> arrayList = new ArrayList<zzgd>(zzfi3.zzxg);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzgd zzgd3 = arrayList.get(i);
                    zzgd zzgd4 = zzgd3;
                    zzfi3.zzb(zzgd4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzfi zzfi2 = this;
            return zzfi2.zzct().put("isAttachedToWindow", false).put("isScreenOn", zzfi2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbs.zzbA().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzahd.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzct();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzfi.zza(this.zzxh.top, this.zzwX)).put("bottom", zzfi.zza(this.zzxh.bottom, this.zzwX)).put("left", zzfi.zza(this.zzxh.left, this.zzwX)).put("right", zzfi.zza(this.zzxh.right, this.zzwX))).put("adBox", (Object)new JSONObject().put("top", zzfi.zza(rect.top, this.zzwX)).put("bottom", zzfi.zza(rect.bottom, this.zzwX)).put("left", zzfi.zza(rect.left, this.zzwX)).put("right", zzfi.zza(rect.right, this.zzwX))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzfi.zza(rect2.top, this.zzwX)).put("bottom", zzfi.zza(rect2.bottom, this.zzwX)).put("left", zzfi.zza(rect2.left, this.zzwX)).put("right", zzfi.zza(rect2.right, this.zzwX))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzfi.zza(rect3.top, this.zzwX)).put("bottom", zzfi.zza(rect3.bottom, this.zzwX)).put("left", zzfi.zza(rect3.left, this.zzwX)).put("right", zzfi.zza(rect3.right, this.zzwX))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzfi.zza(rect4.top, this.zzwX)).put("bottom", zzfi.zza(rect4.bottom, this.zzwX)).put("left", zzfi.zza(rect4.left, this.zzwX)).put("right", zzfi.zza(rect4.right, this.zzwX))).put("screenDensity", (double)this.zzwX.density);
        if (bl == null) {
            bl = zzbs.zzby().zza(view, this.zzwV, this.zzwW);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzwV.isInteractive();
        }
        return this.zzwV.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzg(1);
    }

    public final void onGlobalLayout() {
        this.zzg(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfp zzfp2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzwY = zzfp2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzxa = true;
            this.zzg(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzuY = true;
            this.zzg(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzuY = false;
            this.zzg(3);
            return;
        }
    }
}

