/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzxx;
import com.google.android.gms.internal.zzyg;
import com.google.android.gms.internal.zzyh;
import java.util.Map;
import java.util.Set;

@zzaaz
public final class zzxw
extends zzyg {
    private static Set<String> zzNA = zzg.zzb((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzNB = "top-right";
    private boolean zzNC = true;
    private int zzND = 0;
    private int zzNE = 0;
    private int zzsa = -1;
    private int zzNF = 0;
    private int zzNG = 0;
    private int zzrZ = -1;
    private final Object mLock = new Object();
    private final zzalm zzJK;
    private final Activity zzNq;
    private zziv zzvc;
    private ImageView zzNH;
    private LinearLayout zzNI;
    private zzyh zzNJ;
    private PopupWindow zzNK;
    private RelativeLayout zzNL;
    private ViewGroup zzNM;

    public zzxw(zzalm zzalm2, zzyh zzyh2) {
        super(zzalm2, "resize");
        this.zzJK = zzalm2;
        this.zzNq = zzalm2.zzir();
        this.zzNJ = zzyh2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzNq == null) {
                this.zzan("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzJK.zzal() == null) {
                this.zzan("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzJK.zzal().zzAw) {
                this.zzan("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzJK.zziz()) {
                this.zzan("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzxw zzxw2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbs.zzby();
                zzxw2.zzrZ = zzail.zzaJ(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbs.zzby();
                zzxw2.zzsa = zzail.zzaJ(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbs.zzby();
                zzxw2.zzNF = zzail.zzaJ(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbs.zzby();
                zzxw2.zzNG = zzail.zzaJ(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzxw2.zzNC = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzxw2.zzNB = string2;
            }
            zzxw2 = this;
            if (!(zzxw2.zzrZ >= 0 && zzxw2.zzsa >= 0)) {
                this.zzan("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzNq.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzan("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzfA();
            if (nArray == null) {
                this.zzan("Resize location out of screen or close button is not visible.");
                return;
            }
            zzji.zzdr();
            int n = zzakk.zzc((Context)this.zzNq, (int)this.zzrZ);
            zzji.zzdr();
            int n2 = zzakk.zzc((Context)this.zzNq, (int)this.zzsa);
            ViewParent viewParent = this.zzJK.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzJK.getView());
                if (this.zzNK == null) {
                    this.zzNM = (ViewGroup)viewParent;
                    zzbs.zzby();
                    bitmap = zzail.zzl(this.zzJK.getView());
                    this.zzNH = new ImageView((Context)this.zzNq);
                    this.zzNH.setImageBitmap(bitmap);
                    this.zzvc = this.zzJK.zzal();
                    this.zzNM.addView((View)this.zzNH);
                } else {
                    this.zzNK.dismiss();
                }
            } else {
                this.zzan("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzNL = new RelativeLayout((Context)this.zzNq);
            this.zzNL.setBackgroundColor(0);
            this.zzNL.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbs.zzby();
            this.zzNK = zzail.zza((View)this.zzNL, n, n2, false);
            this.zzNK.setOutsideTouchable(true);
            this.zzNK.setTouchable(true);
            this.zzNK.setClippingEnabled(!this.zzNC);
            this.zzNL.addView(this.zzJK.getView(), -1, -1);
            this.zzNI = new LinearLayout((Context)this.zzNq);
            zzji.zzdr();
            int n3 = zzakk.zzc((Context)this.zzNq, (int)50);
            zzji.zzdr();
            bitmap = new RelativeLayout.LayoutParams(n3, zzakk.zzc((Context)this.zzNq, (int)50));
            switch (this.zzNB) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzNI.setOnClickListener((View.OnClickListener)new zzxx(this));
            this.zzNI.setContentDescription((CharSequence)"Close button");
            this.zzNL.addView((View)this.zzNI, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzji.zzdr();
                int n4 = zzakk.zzc((Context)this.zzNq, (int)nArray[0]);
                zzji.zzdr();
                this.zzNK.showAtLocation(view, 0, n4, zzakk.zzc((Context)this.zzNq, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzan(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                this.zzNL.removeView(this.zzJK.getView());
                if (this.zzNM != null) {
                    this.zzNM.removeView((View)this.zzNH);
                    this.zzNM.addView(this.zzJK.getView());
                    this.zzJK.zza(this.zzvc);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzxw2 = this;
            if (zzxw2.zzNJ != null) {
                zzxw2.zzNJ.zza(n6, n5, zzxw2.zzrZ, zzxw2.zzsa);
            }
            this.zzJK.zza(new zziv((Context)this.zzNq, new AdSize(this.zzrZ, this.zzsa)));
            this.zza(nArray[0], nArray[1]);
            this.zzap("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzNK != null) {
                this.zzNK.dismiss();
                this.zzNL.removeView(this.zzJK.getView());
                if (this.zzNM != null) {
                    this.zzNM.removeView((View)this.zzNH);
                    this.zzNM.addView(this.zzJK.getView());
                    this.zzJK.zza(this.zzvc);
                }
                if (bl) {
                    this.zzap("default");
                    if (this.zzNJ != null) {
                        this.zzNJ.zzaM();
                    }
                }
                this.zzNK = null;
                this.zzNL = null;
                this.zzNM = null;
                this.zzNI = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzfA() {
        zzxw zzxw2 = this;
        int[] nArray = zzbs.zzby().zzg(zzxw2.zzNq);
        int[] nArray2 = zzbs.zzby().zzh(zzxw2.zzNq);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzxw2.zzrZ < 50 || zzxw2.zzrZ > n) {
            zzahd.zzaT((String)"Width is too small or too large.");
            return null;
        }
        if (zzxw2.zzsa < 50 || zzxw2.zzsa > n2) {
            zzahd.zzaT((String)"Height is too small or too large.");
            return null;
        }
        if (zzxw2.zzsa == n2 && zzxw2.zzrZ == n) {
            zzahd.zzaT((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzxw2.zzNC) {
            int n3;
            int n4;
            switch (zzxw2.zzNB) {
                case "top-left": {
                    n4 = zzxw2.zzND + zzxw2.zzNF;
                    n3 = zzxw2.zzNE + zzxw2.zzNG;
                    break;
                }
                case "top-center": {
                    n4 = zzxw2.zzND + zzxw2.zzNF + zzxw2.zzrZ / 2 - 25;
                    n3 = zzxw2.zzNE + zzxw2.zzNG;
                    break;
                }
                case "center": {
                    n4 = zzxw2.zzND + zzxw2.zzNF + zzxw2.zzrZ / 2 - 25;
                    n3 = zzxw2.zzNE + zzxw2.zzNG + zzxw2.zzsa / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzxw2.zzND + zzxw2.zzNF;
                    n3 = zzxw2.zzNE + zzxw2.zzNG + zzxw2.zzsa - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzxw2.zzND + zzxw2.zzNF + zzxw2.zzrZ / 2 - 25;
                    n3 = zzxw2.zzNE + zzxw2.zzNG + zzxw2.zzsa - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzxw2.zzND + zzxw2.zzNF + zzxw2.zzrZ - 50;
                    n3 = zzxw2.zzNE + zzxw2.zzNG + zzxw2.zzsa - 50;
                    break;
                }
                default: {
                    n4 = zzxw2.zzND + zzxw2.zzNF + zzxw2.zzrZ - 50;
                    n3 = zzxw2.zzNE + zzxw2.zzNG;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzNC) {
            return new int[]{this.zzND + this.zzNF, this.zzNE + this.zzNG};
        }
        int[] nArray3 = zzbs.zzby().zzg(this.zzNq);
        int[] nArray4 = zzbs.zzby().zzh(this.zzNq);
        int n5 = nArray3[0];
        int n6 = this.zzND + this.zzNF;
        int n7 = this.zzNE + this.zzNG;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzrZ > n5) {
            n6 = n5 - this.zzrZ;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzsa <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzsa;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzND = n;
            this.zzNE = n2;
            if (this.zzNK != null && bl) {
                int[] nArray = this.zzfA();
                if (nArray != null) {
                    zzji.zzdr();
                    int n3 = zzakk.zzc((Context)this.zzNq, (int)nArray[0]);
                    zzji.zzdr();
                    this.zzNK.update(n3, zzakk.zzc((Context)this.zzNq, (int)nArray[1]), this.zzNK.getWidth(), this.zzNK.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzk(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbs.zzby().zzh(this.zzNq)[0];
        this.zzb(n, n2 - n3, this.zzrZ, this.zzsa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzfB() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzNK != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzND = n;
        this.zzNE = n2;
    }
}

