/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzya;
import com.google.android.gms.internal.zzyb;
import com.google.android.gms.internal.zzyg;
import java.util.Map;

@zzaaz
public final class zzxz
extends zzyg {
    private final Map<String, String> zzHd;
    private final Context mContext;

    public zzxz(zzalm zzalm2, Map<String, String> map) {
        super(zzalm2, "storePicture");
        this.zzHd = map;
        this.mContext = zzalm2.zzir();
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzan("Activity context is not available");
            return;
        }
        zzbs.zzby();
        if (!zzail.zzH(this.mContext).zzdF()) {
            this.zzan("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzHd.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzan("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzan(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzbs.zzby();
        if (!zzail.zzaK(string4)) {
            String string5 = String.valueOf(string4);
            this.zzan(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzbs.zzbC().getResources();
        zzbs.zzby();
        AlertDialog.Builder builder = zzail.zzG(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzya(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzyb(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzxz zzxz2) {
        return zzxz2.mContext;
    }
}

