/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzam;
import com.google.android.gms.ads.internal.overlay.zzao;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzzn;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzzn
@TargetApi(value=14)
public final class zzap
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzao {
    private static final float[] zzPU = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzam zzPV;
    private final float[] zzPR;
    private final float[] zzPW;
    private final float[] zzPX;
    private final float[] zzPY;
    private final float[] zzPZ;
    private final float[] zzQa;
    private final float[] zzQb;
    private float zzQc;
    private float zzQd;
    private float zzQe;
    private int zzrX;
    private int zzrW;
    private SurfaceTexture zzQf;
    private SurfaceTexture zzQg;
    private int zzQh;
    private int zzQi;
    private int zzQj;
    private FloatBuffer zzQk = ByteBuffer.allocateDirect(zzPU.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzQl;
    private final Object zzQm;
    private EGL10 zzQn;
    private EGLDisplay zzQo;
    private EGLContext zzQp;
    private EGLSurface zzQq;
    private volatile boolean zzQr;
    private volatile boolean zzQs;

    public zzap(Context context) {
        super("SphericalVideoProcessor");
        this.zzQk.put(zzPU).position(0);
        this.zzPR = new float[9];
        this.zzPW = new float[9];
        this.zzPX = new float[9];
        this.zzPY = new float[9];
        this.zzPZ = new float[9];
        this.zzQa = new float[9];
        this.zzQb = new float[9];
        this.zzQc = Float.NaN;
        this.zzPV = new zzam(context);
        this.zzPV.zza(this);
        this.zzQl = new CountDownLatch(1);
        this.zzQm = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzrW = n;
        this.zzrX = n2;
        this.zzQg = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzf(int n, int n2) {
        Object object = this.zzQm;
        synchronized (object) {
            this.zzrW = n;
            this.zzrX = n2;
            this.zzQr = true;
            this.zzQm.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgf() {
        Object object = this.zzQm;
        synchronized (object) {
            this.zzQs = true;
            this.zzQg = null;
            this.zzQm.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzgg() {
        if (this.zzQg == null) {
            return null;
        }
        try {
            this.zzQl.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzQf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzQj;
        Object object = this.zzQm;
        synchronized (object) {
            this.zzQm.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzfO() {
        Object object = this.zzQm;
        synchronized (object) {
            this.zzQm.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string;
        zzme<String> zzme2;
        Object object;
        Object object2;
        boolean bl2;
        if (this.zzQg == null) {
            zzafr.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzQl.countDown();
            return;
        }
        zzap zzap2 = this;
        this.zzQn = (EGL10)EGLContext.getEGL();
        zzap2.zzQo = zzap2.zzQn.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzap2.zzQo == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzap2.zzQn.eglInitialize(zzap2.zzQo, nArray)) {
                bl2 = false;
            } else {
                object2 = zzap2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                int[] nArray3 = new int[1];
                object = ((zzap)object2).zzQn.eglChooseConfig(((zzap)object2).zzQo, nArray2, eGLConfigArray, 1, nArray3) && nArray3[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray4 = new int[]{12440, 2, 12344};
                    zzap2.zzQp = zzap2.zzQn.eglCreateContext(zzap2.zzQo, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray4);
                    if (zzap2.zzQp == null || zzap2.zzQp == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzap2.zzQq = zzap2.zzQn.eglCreateWindowSurface(zzap2.zzQo, (EGLConfig)object, (Object)zzap2.zzQg, null);
                        bl2 = zzap2.zzQq == null || zzap2.zzQq == EGL10.EGL_NO_SURFACE ? false : zzap2.zzQn.eglMakeCurrent(zzap2.zzQo, zzap2.zzQq, zzap2.zzQq, zzap2.zzQp);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzap2 = this;
        zzme<String> zzme3 = zzme2 = zzmo.zzEn;
        if (!zzbs.zzbL().zzd(zzme3).equals(zzme2.zzdI())) {
            zzme3 = zzme2;
            string = zzbs.zzbL().zzd(zzme3);
        } else {
            string = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzap.zzc(35633, string);
        if (n2 == 0) {
            n = 0;
        } else {
            String string2;
            zzme3 = zzme2 = zzmo.zzEo;
            if (!zzbs.zzbL().zzd(zzme3).equals(zzme2.zzdI())) {
                zzme3 = zzme2;
                string2 = zzbs.zzbL().zzd(zzme3);
            } else {
                string2 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzap.zzc(35632, string2);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzap.zzar("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzap.zzar("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzap.zzar("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzap.zzar("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzap.zzar("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzap.zzar("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzap.zzar("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzQh = n;
        GLES20.glUseProgram((int)zzap2.zzQh);
        zzap.zzar("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzap2.zzQh, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzap2.zzQk);
        zzap.zzar("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzap.zzar("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzap.zzar("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzap.zzar("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzap.zzar("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzap.zzar("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzap.zzar("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzap.zzar("texParameteri");
        zzap2.zzQi = GLES20.glGetUniformLocation((int)zzap2.zzQh, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzap2.zzQi, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzQh != 0;
        if (!bl3 || !bl) {
            String string3 = GLUtils.getEGLErrorString((int)this.zzQn.eglGetError());
            String string4 = String.valueOf(string3);
            String string5 = string4.length() != 0 ? "EGL initialization failed: ".concat(string4) : new String("EGL initialization failed: ");
            zzafr.e((String)string5);
            zzbs.zzbD().zza(new Throwable(string5), "SphericalVideoProcessor.run.1");
            this.zzgi();
            this.zzQl.countDown();
            return;
        }
        this.zzQf = new SurfaceTexture(n7);
        this.zzQf.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzQl.countDown();
        this.zzPV.start();
        try {
            this.zzQr = true;
            while (!this.zzQs) {
                this.zzgh();
                if (this.zzQr) {
                    zzap2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzap2.zzrW, (int)zzap2.zzrX);
                    zzap.zzar("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzap2.zzQh, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzap2.zzQh, (String)"uFOVy");
                    if (zzap2.zzrW > zzap2.zzrX) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzap2.zzrX / (float)zzap2.zzrW));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzap2.zzrW / (float)zzap2.zzrX));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzQr = false;
                }
                try {
                    Object object3 = this.zzQm;
                    synchronized (object3) {
                        if (!this.zzQs && !this.zzQr && this.zzQj == 0) {
                            this.zzQm.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzafr.zzaT((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzafr.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbs.zzbD().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzPV.stop();
            this.zzQf.setOnFrameAvailableListener(null);
            this.zzQf = null;
            this.zzgi();
        }
    }

    private final void zzgh() {
        while (this.zzQj > 0) {
            this.zzQf.updateTexImage();
            --this.zzQj;
        }
        if (this.zzPV.zza(this.zzPR)) {
            if (Float.isNaN(this.zzQc)) {
                float[] fArray = this.zzPR;
                float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
                float[] fArray3 = this.zzPR;
                float[] fArray4 = new float[]{fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1] + fArray3[2] * fArray2[2], fArray3[3] * fArray2[0] + fArray3[4] * fArray2[1] + fArray3[5] * fArray2[2], fArray3[6] * fArray2[0] + fArray3[7] * fArray2[1] + fArray3[8] * fArray2[2]};
                this.zzQc = -((float)Math.atan2(fArray4[1], fArray4[0]) - 1.5707964f);
            }
            zzap.zzb(this.zzQa, this.zzQc + this.zzQd);
        } else {
            zzap.zza(this.zzPR, -1.5707964f);
            zzap.zzb(this.zzQa, this.zzQd);
        }
        zzap.zza(this.zzPW, 1.5707964f);
        zzap.zza(this.zzPX, this.zzQa, this.zzPW);
        zzap.zza(this.zzPY, this.zzPR, this.zzPX);
        zzap.zza(this.zzPZ, this.zzQe);
        zzap.zza(this.zzQb, this.zzPZ, this.zzPY);
        GLES20.glUniformMatrix3fv((int)this.zzQi, (int)1, (boolean)false, (float[])this.zzQb, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        zzap.zzar("drawArrays");
        GLES20.glFinish();
        this.zzQn.eglSwapBuffers(this.zzQo, this.zzQq);
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzrW > this.zzrX) {
            f4 = 1.7453293f * f / (float)this.zzrW;
            f3 = 1.7453293f * f2 / (float)this.zzrW;
        } else {
            f4 = 1.7453293f * f / (float)this.zzrX;
            f3 = 1.7453293f * f2 / (float)this.zzrX;
        }
        this.zzQd -= f4;
        this.zzQe -= f3;
        if (this.zzQe < -1.5707964f) {
            this.zzQe = -1.5707964f;
        }
        if (this.zzQe > 1.5707964f) {
            this.zzQe = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzc(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        zzap.zzar("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string);
            zzap.zzar("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzap.zzar("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzap.zzar("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzap.zzar("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    private final boolean zzgi() {
        boolean bl = false;
        if (this.zzQq != null && this.zzQq != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzQn.eglMakeCurrent(this.zzQo, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzQn.eglDestroySurface(this.zzQo, this.zzQq);
            this.zzQq = null;
        }
        if (this.zzQp != null) {
            bl |= this.zzQn.eglDestroyContext(this.zzQo, this.zzQp);
            this.zzQp = null;
        }
        if (this.zzQo != null) {
            bl |= this.zzQn.eglTerminate(this.zzQo);
            this.zzQo = null;
        }
        return bl;
    }

    private static void zzar(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string).length()).append(string).append(": glError ").append(n).toString());
        }
    }
}

