/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.adp;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzazn;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbv;
import com.google.android.gms.internal.zzcaq;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzcw;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdd;
import com.google.android.gms.internal.zzde;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzea;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdb {
    private static final String TAG = zzdb.class.getSimpleName();
    protected Context zzqD;
    private Context zzqE;
    private ExecutorService zzqF;
    private DexClassLoader zzqG;
    private zzcw zzqH;
    private byte[] zzqI;
    private volatile AdvertisingIdClient zzqJ = null;
    private volatile boolean zzqk = false;
    private Future zzqK = null;
    private volatile zzax zzqL = null;
    private Future zzqM = null;
    private zzcn zzqN;
    private GoogleApiClient zzqO = null;
    protected boolean zzqP = false;
    private static Object zzqQ = new Object();
    private boolean zzqR = false;
    private static zze zzqS = null;
    protected boolean zzqT = false;
    private Map<Pair<String, String>, zzea> zzqU;
    private boolean zzqV = false;

    public static zzdb zza(Context context, String string2, String string3, boolean bl) {
        zzdb zzdb2 = new zzdb(context);
        try {
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdb zzdb3 = zzdb2;
            zzdb2.zzqF = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            Object object = zzdb3;
            zzdb3.zzqk = bl3;
            if (bl3) {
                ((zzdb)object).zzqK = ((zzdb)object).zzqF.submit(new zzdc((zzdb)object));
            }
            zzdb zzdb4 = zzdb3;
            zzdb4.zzqF.execute(new zzde(zzdb4));
            try {
                zzqS = zze.zzoW();
                zzdb4.zzqP = zze.zzau((Context)zzdb4.zzqD) > 0;
                boolean bl4 = zzdb4.zzqR = zzqS.isGooglePlayServicesAvailable(zzdb4.zzqD) == 0;
                if (zzdb4.zzqD.getApplicationContext() != null) {
                    zzdb4.zzqO = new GoogleApiClient.Builder(zzdb4.zzqD).addApi(zzazn.API).build();
                }
            }
            catch (Throwable throwable) {}
            zzdb3.zza(0, true);
            if (zzdg.zzS()) {
                object = zzmo.zzFa;
                if (((Boolean)zzbs.zzbL().zzd(object)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            String string6 = string5;
            zzdb4 = zzdb3;
            zzdb3.zzqH = new zzcw(null);
            try {
                zzdb4.zzqI = zzdb4.zzqH.zzl(string6);
            }
            catch (zzcx zzcx2) {
                throw new zzcy(zzcx2);
            }
            string6 = string4;
            zzdb4 = zzdb3;
            try {
                String string7;
                File file = zzdb4.zzqD.getCacheDir();
                if (file == null && (file = zzdb4.zzqD.getDir("dex", 0)) == null) {
                    throw new zzcy();
                }
                String string8 = string7 = "1489418796403";
                File file2 = file;
                String string9 = string6;
                zzdb zzdb5 = zzdb4;
                File file3 = new File(String.format("%s/%s.jar", file2, string8));
                if (!file3.exists()) {
                    byte[] byArray = zzdb5.zzqH.zza(zzdb5.zzqI, string9);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdb4.zzb(file, string7);
                try {
                    zzdb4.zzqG = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdb4.zzqD.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdb.zza(file4);
                    zzdb4.zza(file, string7);
                    zzdb.zzm(String.format("%s/%s.dex", file, string7));
                    throw throwable;
                }
                zzdb.zza(file4);
                zzdb4.zza(file, string7);
                zzdb.zzm(String.format("%s/%s.dex", file, string7));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzcy(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzcy(iOException);
            }
            catch (zzcx zzcx3) {
                throw new zzcy(zzcx3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzcy(nullPointerException);
            }
            zzdb3.zzqN = new zzcn(zzdb3);
            zzdb3.zzqV = true;
        }
        catch (zzcy zzcy2) {}
        return zzdb2;
    }

    public final Context getContext() {
        return this.zzqD;
    }

    public final boolean isInitialized() {
        return this.zzqV;
    }

    public final Context getApplicationContext() {
        return this.zzqE;
    }

    public final ExecutorService zzC() {
        return this.zzqF;
    }

    public final DexClassLoader zzD() {
        return this.zzqG;
    }

    public final zzcw zzE() {
        return this.zzqH;
    }

    public final byte[] zzF() {
        return this.zzqI;
    }

    public final GoogleApiClient zzG() {
        return this.zzqO;
    }

    public final boolean zzH() {
        return this.zzqP;
    }

    public final zzcn zzI() {
        return this.zzqN;
    }

    public final boolean zzJ() {
        return this.zzqR;
    }

    public final zzax zzK() {
        return this.zzqL;
    }

    public final Future zzL() {
        return this.zzqM;
    }

    private zzdb(Context context) {
        this.zzqD = context;
        this.zzqE = context.getApplicationContext();
        this.zzqU = new HashMap<Pair<String, String>, zzea>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdb.zza(file2);
            return;
        }
        zzbc zzbc2 = new zzbc();
        new zzbc().zzcG = Build.VERSION.SDK.getBytes();
        zzbc2.zzcF = string2.getBytes();
        byte[] byArray2 = this.zzqH.zzc(this.zzqI, byArray).getBytes();
        zzbc2.data = byArray2;
        zzbc2.zzcE = zzbv.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = adp.zzc((adp)zzbc2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdb.zza(file2);
        return;
        catch (zzcx | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdb.zza(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdb.zza(file2);
            throw throwable;
        }
    }

    private static void zzm(String string2) {
        zzdb.zza(new File(string2));
    }

    private static void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbc zzbc2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdb.zza(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzdb.zza(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzbc2 = (zzbc)adp.zza((adp)new zzbc(), (byte[])byArray2);
                if (string2.equals(new String(zzbc2.zzcF)) && Arrays.equals(zzbc2.zzcE, zzbv.zzb(zzbc2.data)) && Arrays.equals(zzbc2.zzcG, Build.VERSION.SDK.getBytes())) break block30;
                zzdb.zza(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzqH.zza(this.zzqI, new String(zzbc2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcx | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzqU.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzqU.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzea(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zzc(String string2, String string3) {
        zzea zzea2 = this.zzqU.get(new Pair((Object)string2, (Object)string3));
        if (zzea2 == null) {
            return null;
        }
        return zzea2.zzY();
    }

    private final void zzM() {
        try {
            if (this.zzqJ == null && this.zzqE != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzqE);
                advertisingIdClient.start();
                this.zzqJ = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzqJ = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzqR) {
            return;
        }
        Future<?> future = this.zzqF.submit(new zzdd(this, n, bl));
        if (n == 0) {
            this.zzqM = future;
        }
    }

    @VisibleForTesting
    final zzax zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzN();
    }

    private static boolean zza(int n, zzax zzax2) {
        if (n < 4) {
            if (zzax2 == null) {
                return true;
            }
            zzme<Boolean> zzme2 = zzmo.zzFd;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && (zzax2.zzaT == null || zzax2.zzaT.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzme2 = zzmo.zzFe;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && (zzax2.zzbZ == null || zzax2.zzbZ.zzcx == null || zzax2.zzbZ.zzcx == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzax zzN() {
        zzax zzax2 = null;
        try {
            PackageInfo packageInfo = this.zzqD.getPackageManager().getPackageInfo(this.zzqD.getPackageName(), 0);
            zzax2 = zzcaq.zzn((Context)this.zzqD, (String)this.zzqD.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzax2;
    }

    public final AdvertisingIdClient zzO() {
        if (!this.zzqk) {
            return null;
        }
        if (this.zzqJ != null) {
            return this.zzqJ;
        }
        if (this.zzqK != null) {
            try {
                this.zzqK.get(2000L, TimeUnit.MILLISECONDS);
                this.zzqK = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzqK.cancel(true);
            }
        }
        return this.zzqJ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzP() {
        try {
            Object object = zzqQ;
            synchronized (object) {
                if (this.zzqT) {
                    return;
                }
                if (this.zzqR && this.zzqO != null) {
                    this.zzqO.connect();
                    this.zzqT = true;
                } else {
                    this.zzqT = false;
                }
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzQ() {
        Object object = zzqQ;
        synchronized (object) {
            if (this.zzqT && this.zzqO != null) {
                this.zzqO.disconnect();
                this.zzqT = false;
            }
            return;
        }
    }

    public final int zzy() {
        int n = Integer.MIN_VALUE;
        if (this.zzqN != null) {
            n = zzcn.zzy();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdb zzdb2) {
        zzdb2.zzM();
    }

    static /* synthetic */ zzax zza(zzdb zzdb2, zzax zzax2) {
        zzdb2.zzqL = zzax2;
        return zzdb2.zzqL;
    }

    static /* synthetic */ boolean zzb(int n, zzax zzax2) {
        return zzdb.zza(n, zzax2);
    }
}

