/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzagt;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.internal.zzrh;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.internal.zzrj;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.internal.zzzn;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
public final class zzre
implements zzrd {
    private final Context mContext;
    private final zzaje zztW;

    public zzre(Context context, zzaje zzaje2) {
        this.mContext = context;
        this.zztW = zzaje2;
    }

    private static zzri zzc(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzafr.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zzrh> arrayList = new ArrayList<zzrh>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zzrh(string5, string6));
        }
        return new zzri(string2, uRL, arrayList, string4);
    }

    private static JSONObject zza(zzrk zzrk2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzrk2.zzey());
            if (zzrk2.getBody() != null) {
                jSONObject.put("body", (Object)zzrk2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zzrh zzrh2 : zzrk2.zzeD()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zzrh2.getKey()).put("value", (Object)zzrh2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzrk2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzafr.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    private final zzrj zza(zzri zzri2) {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object2;
            Object object3;
            httpURLConnection = (HttpURLConnection)zzri2.zzez().openConnection();
            zzbs.zzbz().zza(this.mContext, this.zztW.zzaP, false, httpURLConnection);
            ArrayList<zzrh> arrayList = zzri2.zzeA();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzrh zzrh2 = arrayList.get(i);
                object3 = zzrh2;
                httpURLConnection.addRequestProperty(((zzrh)object3).getKey(), ((zzrh)object3).getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzri2.zzeB())) {
                httpURLConnection.setDoOutput(true);
                object2 = zzri2.zzeB().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object2).length);
                object3 = new BufferedOutputStream(httpURLConnection.getOutputStream());
                ((FilterOutputStream)object3).write((byte[])object2);
                ((FilterOutputStream)object3).close();
            }
            object2 = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry object4 : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : (List)object4.getValue()) {
                        ((ArrayList)object2).add(new zzrh((String)object4.getKey(), string2));
                    }
                }
            }
            String string3 = zzri2.zzey();
            int n2 = httpURLConnection.getResponseCode();
            zzbs.zzbz();
            object3 = new zzrk(string3, n2, (List<zzrh>)object2, zzagz.zza(new InputStreamReader(httpURLConnection.getInputStream())));
            zzrj zzrj2 = new zzrj(this, true, (zzrk)object3, null);
            return zzrj2;
        }
        catch (Exception exception) {
            zzrj zzrj2 = new zzrj(this, false, null, exception.toString());
            return zzrj2;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public final JSONObject zzR(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            zzafr.e((String)"The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzri zzri2 = zzre.zzc(jSONObject);
            zzrj zzrj2 = this.zza(zzri2);
            if (zzrj2.isSuccess()) {
                JSONObject jSONObject3 = zzre.zza(zzrj2.zzeC());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzrj2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jSONObject2;
    }

    @Override
    public final void zza(zzaka zzaka2, Map<String, String> map) {
        zzagt.zza(new zzrf(this, map, zzaka2));
    }
}

