/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.internal.zzaav;
import com.google.android.gms.internal.zzaaw;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzzn;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzzn
public final class zzaau
extends zza {
    public static final Parcelable.Creator<zzaau> CREATOR = new zzaaw();
    private ParcelFileDescriptor zzTP;
    private Parcelable zzTQ;
    private boolean zzTR;

    zzaau(ParcelFileDescriptor parcelFileDescriptor) {
        this.zzTP = parcelFileDescriptor;
        this.zzTQ = null;
        this.zzTR = true;
    }

    public zzaau(SafeParcelable safeParcelable) {
        this.zzTP = null;
        this.zzTQ = safeParcelable;
        this.zzTR = false;
    }

    public final <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzTR) {
            byte[] byArray;
            if (this.zzTP == null) {
                zzafr.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzTP));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzn.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzTQ = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzTR = false;
        }
        return (T)((SafeParcelable)this.zzTQ);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        if (this.zzTP == null) {
            byte[] byArray;
            Parcel parcel2 = Parcel.obtain();
            try {
                this.zzTQ.writeToParcel(parcel2, 0);
                byArray = parcel2.marshall();
            }
            finally {
                parcel2.recycle();
            }
            this.zzTP = this.zzc(byArray);
        }
        Parcel parcel3 = parcel;
        zzaau zzaau2 = this;
        int n2 = zzd.zze((Parcel)parcel3);
        zzd.zza((Parcel)parcel3, (int)2, (Parcelable)zzaau2.zzTP, (int)n, (boolean)false);
        zzd.zzI((Parcel)parcel3, (int)n2);
    }

    private final <T> ParcelFileDescriptor zzc(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzaav zzaav2 = new zzaav(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzaav2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzafr.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbs.zzbD().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzn.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

