/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzajm;
import com.google.android.gms.internal.zzajn;
import com.google.android.gms.internal.zzzn;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzzn
public class zzajg<T>
implements zzajm<T> {
    private final Object mLock = new Object();
    private T mValue;
    private Throwable zzaaS;
    private boolean zzaaT;
    private boolean zzMP;
    private final zzajn zzaaU = new zzajn();

    @Override
    public final void zzc(Runnable runnable) {
        this.zzaaU.zzc(runnable);
    }

    @Override
    public final void zzd(Runnable runnable) {
        this.zzaaU.zzd(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzg(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzMP) {
                return;
            }
            if (this.zzim()) {
                zzbs.zzbD().zza(new IllegalStateException("Provided CallbackFuture with multiple values."), "CallbackFuture.provideValue");
                return;
            }
            this.zzaaT = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzaaU.zzin();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzMP) {
                return;
            }
            if (this.zzim()) {
                zzbs.zzbD().zza(new IllegalStateException("Provided CallbackFuture with multiple values."), "CallbackFuture.provideException");
                return;
            }
            this.zzaaS = throwable;
            this.mLock.notifyAll();
            this.zzaaU.zzin();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzim()) {
                this.mLock.wait();
            }
            if (this.zzaaS != null) {
                throw new ExecutionException(this.zzaaS);
            }
            if (this.zzMP) {
                throw new CancellationException("CallbackFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzim()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzaaS != null) {
                throw new ExecutionException(this.zzaaS);
            }
            if (!this.zzaaT) {
                throw new TimeoutException("CallbackFuture timed out.");
            }
            if (this.zzMP) {
                throw new CancellationException("CallbackFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzim()) {
                return false;
            }
            this.zzMP = true;
            this.zzaaT = true;
            this.mLock.notifyAll();
            this.zzaaU.zzin();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzMP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzim();
        }
    }

    private final boolean zzim() {
        return this.zzaaS != null || this.zzaaT;
    }
}

