/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzakx;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzakz;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzalb;
import com.google.android.gms.internal.zzalc;
import com.google.android.gms.internal.zzzn;

@zzzn
@TargetApi(value=11)
public class zzakw
extends WebChromeClient {
    private final zzaka zzJH;

    private static boolean zza(Context context, String string2, String string3, String string4, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle((CharSequence)string2);
            if (bl) {
                JsPromptResult jsPromptResult2 = jsPromptResult;
                String string5 = string4;
                String string6 = string3;
                AlertDialog.Builder builder2 = builder;
                Context context2 = context;
                LinearLayout linearLayout = new LinearLayout(context2);
                linearLayout.setOrientation(1);
                TextView textView = new TextView(context2);
                textView.setText((CharSequence)string6);
                EditText editText = new EditText(context2);
                editText.setText((CharSequence)string5);
                linearLayout.addView((View)textView);
                linearLayout.addView((View)editText);
                builder2.setView((View)linearLayout).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzalc(jsPromptResult2, editText)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzalb(jsPromptResult2)).setOnCancelListener((DialogInterface.OnCancelListener)new zzala(jsPromptResult2)).create().show();
            } else {
                JsResult jsResult2 = jsResult;
                String string7 = string3;
                builder.setMessage((CharSequence)string7).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzakz(jsResult2)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzaky(jsResult2)).setOnCancelListener((DialogInterface.OnCancelListener)new zzakx(jsResult2)).create().show();
            }
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzafr.zzc((String)"Fail to display Dialog.", (Throwable)badTokenException);
        }
        return true;
    }

    public zzakw(zzaka zzaka2) {
        this.zzJH = zzaka2;
    }

    public final boolean onCreateWindow(WebView webView, boolean bl, boolean bl2, Message message) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)message.obj;
        WebView webView2 = new WebView(webView.getContext());
        webView2.setWebViewClient((WebViewClient)this.zzJH.zziw());
        webViewTransport.setWebView(webView2);
        message.sendToTarget();
        return true;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof zzaka)) {
            zzafr.zzaT((String)"Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        zzm zzm2 = ((zzaka)webView).zziu();
        if (zzm2 == null) {
            zzafr.zzaT((String)"Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        zzm2.close();
    }

    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = String.valueOf(consoleMessage.message());
        String string3 = String.valueOf(consoleMessage.sourceId());
        int n = consoleMessage.lineNumber();
        String string4 = new StringBuilder(19 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("JS: ").append(string2).append(" (").append(string3).append(":").append(n).append(")").toString();
        if (string4.contains("Application Cache")) {
            return super.onConsoleMessage(consoleMessage);
        }
        switch (consoleMessage.messageLevel()) {
            case ERROR: {
                zzafr.e((String)string4);
                break;
            }
            case WARNING: {
                zzafr.zzaT((String)string4);
                break;
            }
            case LOG: 
            case TIP: {
                zzafr.zzaS((String)string4);
                break;
            }
            case DEBUG: {
                zzafr.zzaC((String)string4);
                break;
            }
            default: {
                zzafr.zzaS((String)string4);
            }
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public final void onExceededDatabaseQuota(String string2, String string3, long l, long l2, long l3, WebStorage.QuotaUpdater quotaUpdater) {
        long l4;
        long l5 = 0x500000L - l3;
        if (l5 <= 0L) {
            quotaUpdater.updateQuota(l);
            return;
        }
        if (l == 0L) {
            l4 = l2 <= l5 && l2 <= 0x100000L ? l2 : 0L;
        } else {
            long l6;
            long l7;
            if (l2 == 0L) {
                l7 = Math.min(131072L, l5);
                l6 = Math.min(l + l7, 0x100000L);
            } else {
                l7 = Math.min(0x100000L - l, l5);
                l6 = l2 <= l7 ? l + l2 : l;
            }
            l4 = l6;
        }
        quotaUpdater.updateQuota(l4);
    }

    public final void onHideCustomView() {
        zzm zzm2 = this.zzJH.zziu();
        if (zzm2 == null) {
            zzafr.zzaT((String)"Could not get ad overlay when hiding custom view.");
            return;
        }
        zzm2.zzfI();
    }

    private static Context zza(WebView webView) {
        if (!(webView instanceof zzaka)) {
            return webView.getContext();
        }
        zzaka zzaka2 = (zzaka)webView;
        Activity activity = zzaka2.zzis();
        if (activity != null) {
            return activity;
        }
        return zzaka2.getContext();
    }

    public final boolean onJsAlert(WebView webView, String string2, String string3, JsResult jsResult) {
        return zzakw.zza(zzakw.zza(webView), string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String string2, String string3, JsResult jsResult) {
        return zzakw.zza(zzakw.zza(webView), string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String string2, String string3, JsResult jsResult) {
        return zzakw.zza(zzakw.zza(webView), string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
        return zzakw.zza(zzakw.zza(webView), string2, string3, string4, null, jsPromptResult, true);
    }

    public final void onReachedMaxAppCacheSize(long l, long l2, WebStorage.QuotaUpdater quotaUpdater) {
        long l3 = 0x500000L - l2;
        long l4 = l + 131072L;
        if (l3 < l4) {
            quotaUpdater.updateQuota(0L);
            return;
        }
        quotaUpdater.updateQuota(l4);
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zza(view, -1, customViewCallback);
    }

    /*
     * Unable to fully structure code
     */
    public final void onGeolocationPermissionsShowPrompt(String var1_1, GeolocationPermissions.Callback var2_2) {
        block2: {
            if (var2_2 == null) break block2;
            var3_3 = this;
            zzbs.zzbz();
            if (zzagz.zzc(var3_3.zzJH.getContext(), var3_3.zzJH.getContext().getPackageName(), "android.permission.ACCESS_FINE_LOCATION")) ** GOTO lbl-1000
            zzbs.zzbz();
            if (zzagz.zzc(var3_3.zzJH.getContext(), var3_3.zzJH.getContext().getPackageName(), "android.permission.ACCESS_COARSE_LOCATION")) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            var2_2.invoke(var1_1, v0, true);
        }
    }

    protected final void zza(View view, int n, WebChromeClient.CustomViewCallback customViewCallback) {
        zzm zzm2 = this.zzJH.zziu();
        if (zzm2 == null) {
            zzafr.zzaT((String)"Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        zzm2.zza(view, customViewCallback);
        zzm2.setRequestedOrientation(n);
    }
}

