/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzwi;
import com.google.android.gms.internal.zzwj;
import com.google.android.gms.internal.zzwu;
import com.google.android.gms.internal.zzzn;
import java.util.Map;

@zzzn
public final class zzwh
extends zzwu {
    private final Map<String, String> zzHa;
    private final Context mContext;
    private String zzNs;
    private long zzNt;
    private long zzNu;
    private String zzNv;
    private String zzNw;

    public zzwh(zzaka zzaka2, Map<String, String> map) {
        super(zzaka2, "createCalendarEvent");
        this.zzHa = map;
        this.mContext = zzaka2.zzis();
        zzwh zzwh2 = this;
        zzwh2.zzNs = zzwh2.zzal("description");
        zzwh2.zzNv = zzwh2.zzal("summary");
        zzwh2.zzNt = zzwh2.zzam("start_ticks");
        zzwh2.zzNu = zzwh2.zzam("end_ticks");
        zzwh2.zzNw = zzwh2.zzal("location");
    }

    private final String zzal(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzHa.get(string2))) {
            return "";
        }
        return this.zzHa.get(string2);
    }

    private final long zzam(String string2) {
        String string3 = this.zzHa.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzan("Activity context is not available.");
            return;
        }
        zzbs.zzbz();
        if (!zzagz.zzH(this.mContext).zzdH()) {
            this.zzan("This feature is not available on the device.");
            return;
        }
        zzbs.zzbz();
        AlertDialog.Builder builder = zzagz.zzG(this.mContext);
        Resources resources = zzbs.zzbD().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzwi(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzwj(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzNs);
        intent.putExtra("eventLocation", this.zzNw);
        intent.putExtra("description", this.zzNv);
        if (this.zzNt > -1L) {
            intent.putExtra("beginTime", this.zzNt);
        }
        if (this.zzNu > -1L) {
            intent.putExtra("endTime", this.zzNu);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzwh zzwh2) {
        return zzwh2.mContext;
    }
}

