/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzab;
import com.google.android.gms.ads.internal.overlay.zzac;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzas;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzzt;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzzt
public final class zzaa
extends FrameLayout
implements zzx {
    private final zzakk zzbvz;
    private final FrameLayout zzchk;
    private final zznh zzchl;
    private final zzas zzchm;
    private final long zzchn;
    @Nullable
    private zzy zzcho;
    private boolean zzchp;
    private boolean zzchq;
    private boolean zzchr;
    private boolean zzchs;
    private long zzcht;
    private long zzchu;
    private String zzbwe;
    private Bitmap zzchv;
    private ImageView zzchw;
    private boolean zzchx;

    public static void zzh(zzakk zzakk2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzakk2.zza("onVideoEvent", hashMap);
    }

    public static void zzc(zzakk zzakk2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzakk2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzakk zzakk2, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string);
        zzakk2.zza("onVideoEvent", hashMap);
    }

    public zzaa(Context context, zzakk zzakk2, int n, boolean bl, zznh zznh2, zzaq zzaq2) {
        super(context);
        zzmk<Constable> zzmk2;
        this.zzbvz = zzakk2;
        this.zzchl = zznh2;
        this.zzchk = new FrameLayout(context);
        this.addView((View)this.zzchk, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzr((Object)zzakk2.zzbj());
        this.zzcho = zzakk2.zzbj().zzanq.zza(context, zzakk2, n, bl, zznh2, zzaq2);
        if (this.zzcho != null) {
            this.zzchk.addView((View)this.zzcho, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzmk2 = zzmu.zzbgu;
            if (((Boolean)((Object)zzbv.zzen().zzd(zzmk2))).booleanValue()) {
                this.zzne();
            }
        }
        this.zzchw = new ImageView(context);
        zzmk2 = zzmu.zzbgy;
        this.zzchn = zzbv.zzen().zzd(zzmk2);
        zzmk2 = zzmu.zzbgw;
        this.zzchs = (Boolean)((Object)zzbv.zzen().zzd(zzmk2));
        if (this.zzchl != null) {
            this.zzchl.zzh("spinner_used", this.zzchs ? "1" : "0");
        }
        this.zzchm = new zzas(this);
        if (this.zzcho != null) {
            this.zzcho.zza(this);
        }
        if (this.zzcho == null) {
            this.zzj("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzchk.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzbq(String string) {
        this.zzbwe = string;
    }

    public final void zza(float f, float f2) {
        if (this.zzcho != null) {
            this.zzcho.zza(f, f2);
        }
    }

    public final void zznb() {
        if (this.zzcho == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzbwe)) {
            this.zzcho.setVideoPath(this.zzbwe);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzcho == null) {
            return;
        }
        this.zzcho.pause();
    }

    public final void play() {
        if (this.zzcho == null) {
            return;
        }
        this.zzcho.play();
    }

    public final void seekTo(int n) {
        if (this.zzcho == null) {
            return;
        }
        this.zzcho.seekTo(n);
    }

    public final void zznc() {
        if (this.zzcho == null) {
            return;
        }
        zzy zzy2 = this.zzcho;
        zzy2.zzchj.setMuted(true);
        zzy2.zzmk();
    }

    public final void zznd() {
        if (this.zzcho == null) {
            return;
        }
        zzy zzy2 = this.zzcho;
        zzy2.zzchj.setMuted(false);
        zzy2.zzmk();
    }

    public final void zzb(float f) {
        if (this.zzcho == null) {
            return;
        }
        float f2 = f;
        zzy zzy2 = this.zzcho;
        zzy2.zzchj.zzb(f2);
        zzy2.zzmk();
    }

    @TargetApi(value=14)
    public final void zze(MotionEvent motionEvent) {
        if (this.zzcho == null) {
            return;
        }
        this.zzcho.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzne() {
        if (this.zzcho == null) {
            return;
        }
        Context context = this.zzcho.getContext();
        TextView textView = new TextView(context);
        String string = String.valueOf(this.zzcho.zzmg());
        textView.setText((CharSequence)(string.length() != 0 ? "AdMob - ".concat(string) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzchk.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzchk.bringChildToFront((View)textView);
    }

    @Override
    public final void zzmv() {
        this.zzchm.resume();
        zzahf.zzdbo.post((Runnable)new zzab(this));
    }

    @Override
    public final void zzmw() {
        if (this.zzcho == null) {
            return;
        }
        if (this.zzchu == 0L) {
            float f = (float)this.zzcho.getDuration() / 1000.0f;
            int n = this.zzcho.getVideoWidth();
            int n2 = this.zzcho.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzmx() {
        zzaa zzaa2 = this;
        if (zzaa2.zzbvz.zzrx() != null && !zzaa2.zzchq) {
            WindowManager.LayoutParams layoutParams = zzaa2.zzbvz.zzrx().getWindow().getAttributes();
            boolean bl = zzaa2.zzchr = (layoutParams.flags & 0x80) != 0;
            if (!zzaa2.zzchr) {
                zzaa2.zzbvz.zzrx().getWindow().addFlags(128);
                zzaa2.zzchq = true;
            }
        }
        this.zzchp = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zznh();
        this.zzchp = false;
    }

    @Override
    public final void zzmy() {
        this.zza("ended", new String[0]);
        this.zznh();
    }

    @Override
    public final void zzj(String string, @Nullable String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public final void zzmz() {
        zzaa zzaa2 = this;
        if (zzaa2.zzchx && zzaa2.zzchv != null && !zzaa2.zzng()) {
            zzaa2.zzchw.setImageBitmap(zzaa2.zzchv);
            zzaa2.zzchw.invalidate();
            zzaa2.zzchk.addView((View)zzaa2.zzchw, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzaa2.zzchk.bringChildToFront((View)zzaa2.zzchw);
        }
        this.zzchm.pause();
        this.zzchu = this.zzcht;
        zzahf.zzdbo.post((Runnable)new zzac(this));
    }

    public final void destroy() {
        this.zzchm.pause();
        if (this.zzcho != null) {
            this.zzcho.stop();
        }
        this.zznh();
    }

    final void zznf() {
        if (this.zzcho == null) {
            return;
        }
        long l = this.zzcho.getCurrentPosition();
        if (this.zzcht != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzcht = l;
        }
    }

    @Override
    public final void zzna() {
        zzaa zzaa2;
        if (this.zzchp && (zzaa2 = this).zzng()) {
            zzaa2.zzchk.removeView((View)zzaa2.zzchw);
        }
        zzaa2 = this;
        if (zzaa2.zzchv != null) {
            long l = zzbv.zzeg().elapsedRealtime();
            if (zzaa2.zzcho.getBitmap(zzaa2.zzchv) != null) {
                zzaa2.zzchx = true;
            }
            long l2 = zzbv.zzeg().elapsedRealtime() - l;
            if (zzafx.zzqr()) {
                zzafx.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzaa2.zzchn) {
                zzafx.zzcs((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzaa2.zzchs = false;
                zzaa2.zzchv = null;
                if (zzaa2.zzchl != null) {
                    zzaa2.zzchl.zzh("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzd(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzaa zzaa2 = this;
        if (zzaa2.zzchs) {
            zzmk<Integer> zzmk2 = zzmu.zzbgx;
            n4 = Math.max(n4 / zzbv.zzen().zzd(zzmk2), 1);
            zzmk2 = zzmu.zzbgx;
            n3 = Math.max(n3 / zzbv.zzen().zzd(zzmk2), 1);
            if (zzaa2.zzchv == null || zzaa2.zzchv.getWidth() != n4 || zzaa2.zzchv.getHeight() != n3) {
                zzaa2.zzchv = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzaa2.zzchx = false;
            }
        }
    }

    private final boolean zzng() {
        return this.zzchw.getParent() != null;
    }

    private final void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray2[i];
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzbvz.zza("onVideoEvent", hashMap);
    }

    private final void zznh() {
        if (this.zzbvz.zzrx() == null) {
            return;
        }
        if (this.zzchq && !this.zzchr) {
            this.zzbvz.zzrx().getWindow().clearFlags(128);
            this.zzchq = false;
        }
    }

    static /* synthetic */ void zza(zzaa zzaa2, String string, String[] stringArray) {
        zzaa2.zza(string, stringArray);
    }
}

