/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.overlay.zzan;
import com.google.android.gms.ads.internal.overlay.zzao;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzzt;

@zzzt
final class zzam
implements SensorEventListener {
    private final SensorManager zzcif;
    private final Object zzcig;
    private final Display zzcih;
    private final float[] zzcii;
    private final float[] zzcij;
    private float[] zzcik;
    private Handler zzcil;
    private zzao zzcim;

    zzam(Context context) {
        this.zzcif = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzcih = windowManager.getDefaultDisplay();
        this.zzcii = new float[9];
        this.zzcij = new float[9];
        this.zzcig = new Object();
    }

    final void start() {
        if (this.zzcil != null) {
            return;
        }
        Sensor sensor = this.zzcif.getDefaultSensor(11);
        if (sensor == null) {
            zzafx.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzcil = new Handler(handlerThread.getLooper());
        if (!this.zzcif.registerListener((SensorEventListener)this, sensor, 0, this.zzcil)) {
            zzafx.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzcil == null) {
            return;
        }
        this.zzcif.unregisterListener((SensorEventListener)this);
        this.zzcil.post((Runnable)new zzan(this));
        this.zzcil = null;
    }

    final void zza(zzao zzao2) {
        this.zzcim = zzao2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzam zzam2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzam2.zzcig;
            synchronized (object) {
                if (zzam2.zzcik == null) {
                    zzam2.zzcik = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzam2.zzcii, (float[])fArray);
            switch (zzam2.zzcih.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzcii, (int)2, (int)129, (float[])zzam2.zzcij);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzcii, (int)129, (int)130, (float[])zzam2.zzcij);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzcii, (int)130, (int)1, (float[])zzam2.zzcij);
                    break;
                }
                default: {
                    System.arraycopy(zzam2.zzcii, 0, zzam2.zzcij, 0, 9);
                }
            }
            zzam2.zze(1, 3);
            zzam2.zze(2, 6);
            zzam2.zze(5, 7);
            Object object2 = zzam2.zzcig;
            synchronized (object2) {
                System.arraycopy(zzam2.zzcij, 0, zzam2.zzcik, 0, 9);
            }
            if (zzam2.zzcim != null) {
                zzam2.zzcim.zzmr();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzcig;
        synchronized (object) {
            if (this.zzcik == null) {
                return false;
            }
            System.arraycopy(this.zzcik, 0, fArray, 0, this.zzcik.length);
            return true;
        }
    }

    private final void zze(int n, int n2) {
        float f = this.zzcij[n];
        this.zzcij[n] = this.zzcij[n2];
        this.zzcij[n2] = f;
    }
}

