/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzam;
import com.google.android.gms.ads.internal.overlay.zzao;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzzt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzzt
@TargetApi(value=14)
public final class zzap
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzao {
    private static final float[] zzcin = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzam zzcio;
    private final float[] zzcik;
    private final float[] zzcip;
    private final float[] zzciq;
    private final float[] zzcir;
    private final float[] zzcis;
    private final float[] zzcit;
    private final float[] zzciu;
    private float zzciv;
    private float zzciw;
    private float zzcix;
    private int zzakw;
    private int zzakv;
    private SurfaceTexture zzciy;
    private SurfaceTexture zzciz;
    private int zzcja;
    private int zzcjb;
    private int zzcjc;
    private FloatBuffer zzcjd = ByteBuffer.allocateDirect(zzcin.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzcje;
    private final Object zzcjf;
    private EGL10 zzcjg;
    private EGLDisplay zzcjh;
    private EGLContext zzcji;
    private EGLSurface zzcjj;
    private volatile boolean zzcjk;
    private volatile boolean zzcjl;

    public zzap(Context context) {
        super("SphericalVideoProcessor");
        this.zzcjd.put(zzcin).position(0);
        this.zzcik = new float[9];
        this.zzcip = new float[9];
        this.zzciq = new float[9];
        this.zzcir = new float[9];
        this.zzcis = new float[9];
        this.zzcit = new float[9];
        this.zzciu = new float[9];
        this.zzciv = Float.NaN;
        this.zzcio = new zzam(context);
        this.zzcio.zza(this);
        this.zzcje = new CountDownLatch(1);
        this.zzcjf = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzakv = n;
        this.zzakw = n2;
        this.zzciz = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzf(int n, int n2) {
        Object object = this.zzcjf;
        synchronized (object) {
            this.zzakv = n;
            this.zzakw = n2;
            this.zzcjk = true;
            this.zzcjf.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzni() {
        Object object = this.zzcjf;
        synchronized (object) {
            this.zzcjl = true;
            this.zzciz = null;
            this.zzcjf.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zznj() {
        if (this.zzciz == null) {
            return null;
        }
        try {
            this.zzcje.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzciy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzcjc;
        Object object = this.zzcjf;
        synchronized (object) {
            this.zzcjf.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzmr() {
        Object object = this.zzcjf;
        synchronized (object) {
            this.zzcjf.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string;
        zzmk<String> zzmk2;
        Object object;
        Object object2;
        boolean bl2;
        if (this.zzciz == null) {
            zzafx.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzcje.countDown();
            return;
        }
        zzap zzap2 = this;
        this.zzcjg = (EGL10)EGLContext.getEGL();
        zzap2.zzcjh = zzap2.zzcjg.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzap2.zzcjh == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzap2.zzcjg.eglInitialize(zzap2.zzcjh, nArray)) {
                bl2 = false;
            } else {
                object2 = zzap2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                int[] nArray3 = new int[1];
                object = ((zzap)object2).zzcjg.eglChooseConfig(((zzap)object2).zzcjh, nArray2, eGLConfigArray, 1, nArray3) && nArray3[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray4 = new int[]{12440, 2, 12344};
                    zzap2.zzcji = zzap2.zzcjg.eglCreateContext(zzap2.zzcjh, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray4);
                    if (zzap2.zzcji == null || zzap2.zzcji == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzap2.zzcjj = zzap2.zzcjg.eglCreateWindowSurface(zzap2.zzcjh, (EGLConfig)object, (Object)zzap2.zzciz, null);
                        bl2 = zzap2.zzcjj == null || zzap2.zzcjj == EGL10.EGL_NO_SURFACE ? false : zzap2.zzcjg.eglMakeCurrent(zzap2.zzcjh, zzap2.zzcjj, zzap2.zzcjj, zzap2.zzcji);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzap2 = this;
        zzmk<String> zzmk3 = zzmk2 = zzmu.zzbkp;
        if (!zzbv.zzen().zzd(zzmk3).equals(zzmk2.zzik())) {
            zzmk3 = zzmk2;
            string = zzbv.zzen().zzd(zzmk3);
        } else {
            string = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzap.zzc(35633, string);
        if (n2 == 0) {
            n = 0;
        } else {
            String string2;
            zzmk3 = zzmk2 = zzmu.zzbkq;
            if (!zzbv.zzen().zzd(zzmk3).equals(zzmk2.zzik())) {
                zzmk3 = zzmk2;
                string2 = zzbv.zzen().zzd(zzmk3);
            } else {
                string2 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzap.zzc(35632, string2);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzap.zzbr("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzap.zzbr("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzap.zzbr("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzap.zzbr("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzap.zzbr("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzap.zzbr("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzap.zzbr("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzcja = n;
        GLES20.glUseProgram((int)zzap2.zzcja);
        zzap.zzbr("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzap2.zzcja, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzap2.zzcjd);
        zzap.zzbr("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzap.zzbr("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzap.zzbr("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzap.zzbr("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzap.zzbr("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzap.zzbr("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzap.zzbr("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzap.zzbr("texParameteri");
        zzap2.zzcjb = GLES20.glGetUniformLocation((int)zzap2.zzcja, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzap2.zzcjb, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzcja != 0;
        if (!bl3 || !bl) {
            String string3 = GLUtils.getEGLErrorString((int)this.zzcjg.eglGetError());
            String string4 = String.valueOf(string3);
            String string5 = string4.length() != 0 ? "EGL initialization failed: ".concat(string4) : new String("EGL initialization failed: ");
            zzafx.e((String)string5);
            zzbv.zzee().zza(new Throwable(string5), "SphericalVideoProcessor.run.1");
            this.zznl();
            this.zzcje.countDown();
            return;
        }
        this.zzciy = new SurfaceTexture(n7);
        this.zzciy.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzcje.countDown();
        this.zzcio.start();
        try {
            this.zzcjk = true;
            while (!this.zzcjl) {
                this.zznk();
                if (this.zzcjk) {
                    zzap2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzap2.zzakv, (int)zzap2.zzakw);
                    zzap.zzbr("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzap2.zzcja, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzap2.zzcja, (String)"uFOVy");
                    if (zzap2.zzakv > zzap2.zzakw) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzap2.zzakw / (float)zzap2.zzakv));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzap2.zzakv / (float)zzap2.zzakw));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzcjk = false;
                }
                try {
                    Object object3 = this.zzcjf;
                    synchronized (object3) {
                        if (!this.zzcjl && !this.zzcjk && this.zzcjc == 0) {
                            this.zzcjf.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzafx.zzcs((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzafx.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbv.zzee().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzcio.stop();
            this.zzciy.setOnFrameAvailableListener(null);
            this.zzciy = null;
            this.zznl();
        }
    }

    private final void zznk() {
        while (this.zzcjc > 0) {
            this.zzciy.updateTexImage();
            --this.zzcjc;
        }
        if (this.zzcio.zza(this.zzcik)) {
            if (Float.isNaN(this.zzciv)) {
                float[] fArray = this.zzcik;
                float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
                float[] fArray3 = this.zzcik;
                float[] fArray4 = new float[]{fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1] + fArray3[2] * fArray2[2], fArray3[3] * fArray2[0] + fArray3[4] * fArray2[1] + fArray3[5] * fArray2[2], fArray3[6] * fArray2[0] + fArray3[7] * fArray2[1] + fArray3[8] * fArray2[2]};
                this.zzciv = -((float)Math.atan2(fArray4[1], fArray4[0]) - 1.5707964f);
            }
            zzap.zzb(this.zzcit, this.zzciv + this.zzciw);
        } else {
            zzap.zza(this.zzcik, -1.5707964f);
            zzap.zzb(this.zzcit, this.zzciw);
        }
        zzap.zza(this.zzcip, 1.5707964f);
        zzap.zza(this.zzciq, this.zzcit, this.zzcip);
        zzap.zza(this.zzcir, this.zzcik, this.zzciq);
        zzap.zza(this.zzcis, this.zzcix);
        zzap.zza(this.zzciu, this.zzcis, this.zzcir);
        GLES20.glUniformMatrix3fv((int)this.zzcjb, (int)1, (boolean)false, (float[])this.zzciu, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        zzap.zzbr("drawArrays");
        GLES20.glFinish();
        this.zzcjg.eglSwapBuffers(this.zzcjh, this.zzcjj);
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzakv > this.zzakw) {
            f4 = 1.7453293f * f / (float)this.zzakv;
            f3 = 1.7453293f * f2 / (float)this.zzakv;
        } else {
            f4 = 1.7453293f * f / (float)this.zzakw;
            f3 = 1.7453293f * f2 / (float)this.zzakw;
        }
        this.zzciw -= f4;
        this.zzcix -= f3;
        if (this.zzcix < -1.5707964f) {
            this.zzcix = -1.5707964f;
        }
        if (this.zzcix > 1.5707964f) {
            this.zzcix = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzc(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        zzap.zzbr("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string);
            zzap.zzbr("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzap.zzbr("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzap.zzbr("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzap.zzbr("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    private final boolean zznl() {
        boolean bl = false;
        if (this.zzcjj != null && this.zzcjj != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzcjg.eglMakeCurrent(this.zzcjh, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzcjg.eglDestroySurface(this.zzcjh, this.zzcjj);
            this.zzcjj = null;
        }
        if (this.zzcji != null) {
            bl |= this.zzcjg.eglDestroyContext(this.zzcjh, this.zzcji);
            this.zzcji = null;
        }
        if (this.zzcjh != null) {
            bl |= this.zzcjg.eglTerminate(this.zzcjh);
            this.zzcjh = null;
        }
        return bl;
    }

    private static void zzbr(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string).length()).append(string).append(": glError ").append(n).toString());
        }
    }
}

