/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.zzbo;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzahk;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzakf;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzakz;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzalb;
import com.google.android.gms.internal.zzalc;
import com.google.android.gms.internal.zzalf;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zznf;
import com.google.android.gms.internal.zzng;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzoc;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzsk;
import com.google.android.gms.internal.zzsl;
import com.google.android.gms.internal.zzxd;
import com.google.android.gms.internal.zzzt;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzt
final class zzaky
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzakk {
    private final zzalb zzdgs;
    private final Object mLock = new Object();
    @Nullable
    private final zzcv zzbsr;
    private final zzajk zzapc;
    private final zzbo zzdgt;
    private final zzv zzamv;
    private zzakl zzdgu;
    private zzm zzdgv;
    private zzjb zzaro;
    private boolean zzdgw;
    private boolean zzdgx;
    private boolean zzdgy;
    private boolean zzdgz;
    private Boolean zzczr;
    private int zzdha;
    private boolean zzdhb = true;
    private boolean zzdhc = false;
    private String zzcjq = "";
    private zzalc zzdhd;
    private boolean zzdhe;
    private boolean zzdhf;
    private zzoc zzdhg;
    private int zzdhh;
    private int zzdhi;
    private zznf zzdhj;
    private zznf zzcjr;
    private zznf zzdhk;
    private zzng zzdhl;
    private WeakReference<View.OnClickListener> zzdhm;
    private zzm zzdhn;
    private boolean zzdho;
    private zzajd zzaus;
    private int zzces = -1;
    private int zzcer = -1;
    private int zzceu = -1;
    private int zzcev = -1;
    private Map<String, zzsl> zzdhp;
    private final WindowManager zzavh;
    private final zzil zzdhq;

    static zzaky zzb(Context context, zzjb zzjb2, boolean bl, boolean bl2, @Nullable zzcv zzcv2, zzajk zzajk2, zznh zznh2, zzbo zzbo2, zzv zzv2, zzil zzil2) {
        zzalb zzalb2 = new zzalb(context);
        return new zzaky(zzalb2, zzjb2, bl, bl2, zzcv2, zzajk2, zznh2, zzbo2, zzv2, zzil2);
    }

    private zzaky(zzalb zzalb2, zzjb zzjb2, boolean bl, boolean bl2, @Nullable zzcv zzcv2, zzajk zzajk2, zznh zznh2, zzbo zzbo2, zzv zzv2, zzil zzil2) {
        super((Context)zzalb2);
        this.zzdgs = zzalb2;
        this.zzaro = zzjb2;
        this.zzdgy = bl;
        this.zzdha = -1;
        this.zzbsr = zzcv2;
        this.zzapc = zzajk2;
        this.zzdgt = zzbo2;
        this.zzamv = zzv2;
        this.zzavh = (WindowManager)this.getContext().getSystemService("window");
        this.zzdhq = zzil2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzafx.zzb((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        WebSettings webSettings2 = webSettings;
        String string2 = zzajk2.zzcp;
        zzalb zzalb3 = zzalb2;
        zzahf zzahf2 = zzbv.zzea();
        webSettings2.setUserAgentString(zzahf2.zzs((Context)zzalb3, string2));
        zzbv.zzec().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzti();
        if (zzp.zzalf()) {
            this.addJavascriptInterface(new zzalf(this), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzaus = new zzajd(this.zzdgs.zzrx(), (View)this, this, null);
        this.zzd(zznh2);
        zzbv.zzec().zzau((Context)zzalb2);
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzakl) {
            this.zzdgu = (zzakl)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final zzv zzbj() {
        return this.zzamv;
    }

    private final boolean zztg() {
        int n;
        int n2;
        if (!this.zzdgu.zzfo() && !this.zzdgu.zzsu()) {
            return false;
        }
        zzbv.zzea();
        DisplayMetrics displayMetrics = zzahf.zza(this.zzavh);
        zzjo.zzhu();
        int n3 = zzaje.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzjo.zzhu();
        int n4 = zzaje.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.heightPixels);
        Activity activity = this.zzdgs.zzrx();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbv.zzea();
            int[] nArray = zzahf.zzf(activity);
            zzjo.zzhu();
            n2 = zzaje.zzb((DisplayMetrics)displayMetrics, (int)nArray[0]);
            zzjo.zzhu();
            n = zzaje.zzb((DisplayMetrics)displayMetrics, (int)nArray[1]);
        }
        if (this.zzcer == n3 && this.zzces == n4 && this.zzceu == n2 && this.zzcev == n) {
            return false;
        }
        boolean bl = this.zzcer != n3 || this.zzces != n4;
        this.zzcer = n3;
        this.zzces = n4;
        this.zzceu = n2;
        this.zzcev = n;
        new zzxd(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzavh.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzbv.zzea().zzk(map);
        }
        catch (JSONException jSONException) {
            zzafx.zzcs((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public final void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzafx.zzcs((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzcv(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzafx.zzcs((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadUrl(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
                    zzbv.zzee().zza(throwable, "AdWebViewImpl.loadUrl");
                    zzafx.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
                }
            } else {
                zzafx.zzcs((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzct(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
                zzbv.zzee().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
                zzafx.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadData(String string2, String string3, String string4) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzafx.zzcs((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzafx.zzcs((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzcw(String string2) {
        if (zzp.zzalh()) {
            Object object;
            zzaky zzaky2;
            if (this.zzpy() == null) {
                zzaky2 = this;
                object = zzaky2.mLock;
                synchronized (object) {
                    zzaky2.zzczr = zzbv.zzee().zzpy();
                    if (zzaky2.zzczr == null) {
                        try {
                            String string3 = "(function(){})()";
                            zzaky2.evaluateJavascript(string3, null);
                            zzaky2.zza(true);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzaky2.zza(false);
                        }
                    }
                }
            }
            if (this.zzpy().booleanValue()) {
                object = string2;
                zzaky2 = this;
                Object object2 = zzaky2.mLock;
                synchronized (object2) {
                    if (!zzaky2.isDestroyed()) {
                        zzaky2.evaluateJavascript((String)object, null);
                    } else {
                        zzafx.zzcs((String)"The webview is destroyed. Ignoring action.");
                    }
                    return;
                }
            }
            String string4 = String.valueOf(string2);
            this.zzcv(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
            return;
        }
        String string5 = String.valueOf(string2);
        this.zzcv(string5.length() != 0 ? "javascript:".concat(string5) : new String("javascript:"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzczr = bl;
        }
        zzbv.zzee().zza(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Boolean zzpy() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzczr;
        }
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzi(string2, string3);
    }

    @Override
    public final void zzi(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzcw(string4);
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzafx.zzcb((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzcw(stringBuilder.toString());
    }

    @Override
    public final void zzrv() {
        this.zzth();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzapc.zzcp);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzae(int n) {
        if (n == 0) {
            zzaky zzaky2 = this;
            zzna.zza(zzaky2.zzdhl.zzit(), zzaky2.zzcjr, "aebb2");
        }
        this.zzth();
        if (this.zzdhl.zzit() != null) {
            this.zzdhl.zzit().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzapc.zzcp);
        this.zza("onhide", hashMap);
    }

    private final void zzth() {
        zzna.zza(this.zzdhl.zzit(), this.zzcjr, "aeh2");
    }

    @Override
    public final void zzms() {
        if (this.zzdhj == null) {
            zzna.zza(this.zzdhl.zzit(), this.zzcjr, "aes2");
            this.zzdhj = zzna.zzb(this.zzdhl.zzit());
            this.zzdhl.zza("native:view_show", this.zzdhj);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzapc.zzcp);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zzrw() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        zzbv.zzea();
        hashMap.put("app_muted", String.valueOf(zzahf.zzdg()));
        zzbv.zzea();
        hashMap.put("app_volume", String.valueOf(zzahf.zzde()));
        zzbv.zzea();
        hashMap.put("device_volume", String.valueOf(zzahf.zzap(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzm zzrz() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdgv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzm zzsa() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzjb zzbl() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaro;
        }
    }

    @Override
    public final zzakl zzsb() {
        return this.zzdgu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsc() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdgw;
        }
    }

    @Override
    public final zzcv zzsd() {
        return this.zzbsr;
    }

    @Override
    public final zzajk zzse() {
        return this.zzapc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsf() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdgy;
        }
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbv.zzea();
            zzahf.zzb(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzafx.zzcb((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzdgu.zzsu()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.zzdhg != null) {
                    this.zzdhg.zzc(motionEvent);
                }
            }
        } else if (this.zzbsr != null) {
            this.zzbsr.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzmk<Boolean> zzmk2 = zzmu.zzbjh;
        if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected final void onMeasure(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzdgy || this.zzaro.zzbct) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzaro.zzbcu) {
                int n3;
                Object object2 = zzmu.zzbnf;
                if (zzbv.zzen().zzd(object2).booleanValue() || !zzp.zzalf()) {
                    super.onMeasure(n, n2);
                    return;
                }
                object2 = this;
                this.zza("/contentHeight", new zzakz((zzaky)object2));
                String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
                this.zzcw(string2);
                float f = this.zzdgs.getResources().getDisplayMetrics().density;
                int n4 = View.MeasureSpec.getSize((int)n);
                switch (this.zzdhi) {
                    case -1: {
                        n3 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n3 = (int)((float)this.zzdhi * f);
                    }
                }
                this.setMeasuredDimension(n4, n3);
                return;
            }
            if (this.zzaro.zzbcr) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzavh.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            int n9 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n9 = n6;
            }
            int n10 = Integer.MAX_VALUE;
            if (n7 == Integer.MIN_VALUE || n7 == 0x40000000) {
                n10 = n8;
            }
            if (this.zzaro.widthPixels > n9 || this.zzaro.heightPixels > n10) {
                float f = this.zzdgs.getResources().getDisplayMetrics().density;
                int n11 = (int)((float)this.zzaro.widthPixels / f);
                int n12 = (int)((float)this.zzaro.heightPixels / f);
                int n13 = (int)((float)n6 / f);
                int n14 = (int)((float)n8 / f);
                zzafx.zzcs((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n11).append("x").append(n12).append(" dp, but only has ").append(n13).append("x").append(n14).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzaro.widthPixels, this.zzaro.heightPixels);
            }
            return;
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zztg();
        zzm zzm2 = this.zzrz();
        if (zzm2 != null && bl) {
            zzm2.zzmr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(Context context, zzjb zzjb2, zznh zznh2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzaus.zzrm();
            this.setContext(context);
            this.zzdgv = null;
            this.zzaro = zzjb2;
            this.zzdgy = false;
            this.zzdgw = false;
            this.zzcjq = "";
            this.zzdha = -1;
            zzbv.zzec();
            zzahk.zzl(this);
            this.loadUrl("about:blank");
            this.zzdgu.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzdhb = true;
            this.zzdhc = false;
            this.zzdhd = null;
            this.zzd(zznh2);
            this.zzdhe = false;
            this.zzdhh = 0;
            zzbv.zzex();
            zzsk.zze(this);
            this.zztk();
            return;
        }
    }

    private final void zzd(zznh zznh2) {
        this.zztl();
        this.zzdhl = new zzng(new zznh(true, "make_wv", this.zzaro.zzbcq));
        this.zzdhl.zzit().zzc(zznh2);
        this.zzcjr = zzna.zzb(this.zzdhl.zzit());
        this.zzdhl.zza("native:view_create", this.zzcjr);
        this.zzdhk = null;
        this.zzdhj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zzm zzm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdgv = zzm2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(zzm zzm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhn = zzm2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzjb zzjb2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzaro = zzjb2;
            this.requestLayout();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzab(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl2 = bl != this.zzdgy;
            this.zzdgy = bl;
            this.zzti();
            if (bl2) {
                new zzxd(this).zzbp(bl ? "expanded" : "default");
            }
            return;
        }
    }

    @Override
    public final void zzso() {
        this.zzaus.zzrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onAttachedToWindow() {
        Object object = this.mLock;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzaus.onAttachedToWindow();
            }
            boolean bl = this.zzdhe;
            if (this.zzdgu != null && this.zzdgu.zzsu()) {
                bl = true;
                if (!this.zzdhf) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdgu.zzsv();
                    if (onGlobalLayoutListener != null) {
                        zzbv.zzey();
                        zzaky zzaky2 = this;
                        if (zzaky2 == null) {
                            throw null;
                        }
                        zzakf.zza((View)zzaky2, onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzdgu.zzsw()) != null) {
                        zzbv.zzey();
                        zzaky zzaky3 = this;
                        if (zzaky3 == null) {
                            throw null;
                        }
                        zzakf.zza((View)zzaky3, onScrollChangedListener);
                    }
                    this.zzdhf = true;
                }
                this.zztg();
            }
            this.zzag(bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzaus.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzdhf && this.zzdgu != null && this.zzdgu.zzsu() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdgu.zzsv();
                if (onGlobalLayoutListener != null) {
                    zzbv.zzec().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdgu.zzsw()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzdhf = false;
            }
        }
        this.zzag(false);
    }

    @Override
    public final void setContext(Context context) {
        this.zzdgs.setBaseContext(context);
        this.zzaus.zzi(this.zzdgs.zzrx());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzac(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdgv != null) {
                this.zzdgv.zza(this.zzdgu.zzfo(), bl);
            } else {
                this.zzdgw = bl;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getRequestedOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdha;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setRequestedOrientation(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdha = n;
            if (this.zzdgv != null) {
                this.zzdgv.setRequestedOrientation(this.zzdha);
            }
            return;
        }
    }

    @Override
    public final Activity zzrx() {
        return this.zzdgs.zzrx();
    }

    @Override
    public final Context zzry() {
        return this.zzdgs.zzry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzti() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdgy || this.zzaro.zzbcr) {
                zzafx.zzcb((String)"Enabling hardware acceleration on an overlay.");
                this.zztj();
            } else if (Build.VERSION.SDK_INT < 18) {
                zzafx.zzcb((String)"Disabling hardware acceleration on an AdView.");
                zzaky zzaky2 = this;
                Object object2 = zzaky2.mLock;
                synchronized (object2) {
                    if (!zzaky2.zzdgz) {
                        zzbv.zzec().zzr((View)zzaky2);
                    }
                    zzaky2.zzdgz = true;
                }
            } else {
                zzafx.zzcb((String)"Enabling hardware acceleration on an AdView.");
                this.zztj();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zztj() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdgz) {
                zzbv.zzec().zzq((View)this);
            }
            this.zzdgz = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.zztl();
            this.zzaus.zzrm();
            if (this.zzdgv != null) {
                this.zzdgv.close();
                this.zzdgv.onDestroy();
                this.zzdgv = null;
            }
            this.zzdgu.reset();
            if (this.zzdgx) {
                return;
            }
            zzbv.zzex();
            zzsk.zze(this);
            this.zztk();
            this.zzdgx = true;
            zzafx.v("Initiating WebView self destruct sequence in 3...");
            this.zzdgu.zzsy();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            if (this.mLock != null) {
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.zzdgx) {
                        this.zzdgu.reset();
                        zzbv.zzex();
                        zzsk.zze(this);
                        this.zztk();
                        this.zzqm();
                    }
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzsg() {
        Object object = this.mLock;
        synchronized (object) {
            zzafx.v("Destroying WebView!");
            this.zzqm();
            zzahf.zzdbo.post((Runnable)new zzala(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzqm() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzdho) {
                this.zzdho = true;
                zzbv.zzee().zzqm();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdgx;
        }
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzdgu != null && this.zzdgu.zztf() != null) {
            this.zzdgu.zztf().zzcr();
        }
    }

    @Override
    public final void zzsp() {
        if (this.zzdhk == null) {
            this.zzdhk = zzna.zzb(this.zzdhl.zzit());
            this.zzdhl.zza("native:view_load", this.zzdhk);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzafx.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzafx.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzafx.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzad(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhb = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsh() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsi() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzci() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhc = true;
            if (this.zzdgt != null) {
                this.zzdgt.zzci();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcj() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhc = false;
            if (this.zzdgt != null) {
                this.zzdgt.zzcj();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zztk() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhp = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcu(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcjq = string2 == null ? "" : string2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getRequestId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcjq;
        }
    }

    @Override
    public final zzakj zzsj() {
        return null;
    }

    @Override
    public final zznf zzsk() {
        return this.zzcjr;
    }

    @Override
    public final zzng zzsl() {
        return this.zzdhl;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzdhm = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener zzsq() {
        return (View.OnClickListener)this.zzdhm.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zzoc zzoc2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhg = zzoc2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzoc zzsr() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzalc zzsm() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzalc zzalc2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdhd != null) {
                zzafx.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzdhd = zzalc2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsn() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhh > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzae(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhh += bl ? 1 : -1;
            if (this.zzdhh <= 0 && this.zzdgv != null) {
                this.zzdgv.zzmu();
            }
            return;
        }
    }

    private final void zztl() {
        if (this.zzdhl == null) {
            return;
        }
        zznh zznh2 = this.zzdhl.zzit();
        if (zznh2 != null && zzbv.zzee().zzpt() != null) {
            zzbv.zzee().zzpt().zza(zznh2);
        }
    }

    @Override
    public final void zzss() {
        this.setBackgroundColor(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzgl zzgl2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhe = zzgl2.zzaxi;
        }
        this.zzag(zzgl2.zzaxi);
    }

    private final void zzag(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzrn zzrn2) {
        if (this.zzdgu != null) {
            this.zzdgu.zza(string2, zzrn2);
        }
    }

    @Override
    public final void zzb(String string2, zzrn zzrn2) {
        if (this.zzdgu != null) {
            this.zzdgu.zzb(string2, zzrn2);
        }
    }

    static /* synthetic */ Object zza(zzaky zzaky2) {
        return zzaky2.mLock;
    }

    static /* synthetic */ int zzb(zzaky zzaky2) {
        return zzaky2.zzdhi;
    }

    static /* synthetic */ int zza(zzaky zzaky2, int n) {
        zzaky2.zzdhi = n;
        return zzaky2.zzdhi;
    }

    static /* synthetic */ void zzc(zzaky zzaky2) {
        super.destroy();
    }
}

