/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdge;
import com.google.android.gms.internal.zzdgk;
import com.google.android.gms.internal.zzdgn;
import com.google.android.gms.internal.zzdgr;
import com.google.android.gms.internal.zzdgw;
import com.google.android.gms.internal.zzdio;
import com.google.android.gms.internal.zzdip;
import com.google.android.gms.internal.zzdiq;
import com.google.android.gms.internal.zzedv;
import com.google.android.gms.internal.zzefc;
import com.google.android.gms.internal.zzefj;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

final class zzdhs
implements zzdgn<zzdgr, zzdgk.zza, zzdgk.zzb> {
    zzdhs() {
    }

    private final zzdgr zzaf(zzedv zzedv2) throws GeneralSecurityException {
        try {
            zzdgk.zza zza2 = zzdgk.zza.zzn(zzedv2);
            return this.zzc(zza2);
        }
        catch (zzefc zzefc2) {
            throw new GeneralSecurityException("invalid Hmac key");
        }
    }

    private final zzdgr zzc(zzdgk.zza zza2) throws GeneralSecurityException {
        zzdgk.zza zza3 = zza2;
        zzdiq.zzp(zza3.getVersion(), 0);
        if (zza3.zzbjv().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdhs.zzc(zza3.zzbli());
        zzdge zzdge2 = zza2.zzbli().zzblo();
        byte[] byArray = zza2.zzbjv().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zza2.zzbli().zzblp();
        switch (zzdge2) {
            case zzkyx: {
                return new zzdio("HMACSHA1", secretKeySpec, n);
            }
            case zzkyz: {
                return new zzdio("HMACSHA256", secretKeySpec, n);
            }
            case zzkza: {
                return new zzdio("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    private final zzdgk.zza zzag(zzedv zzedv2) throws GeneralSecurityException {
        try {
            zzdgk.zzb zzb2 = zzdgk.zzb.zzp(zzedv2);
            return this.zza(zzb2);
        }
        catch (zzefc zzefc2) {
            throw new GeneralSecurityException("invalid Hmac key format", zzefc2);
        }
    }

    @Override
    private final zzdgk.zza zza(zzdgk.zzb zzb2) throws GeneralSecurityException {
        zzdgk.zzb zzb3 = zzb2;
        if (zzb3.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdhs.zzc(zzb3.zzbli());
        return (zzdgk.zza)zzdgk.zza.zzblj().zzfe(0).zzb(zzb2.zzbli()).zzo(zzedv.zzaq((byte[])zzdip.zzfn(zzb2.getKeySize()))).zzccv();
    }

    @Override
    public final zzdgw.zza zzs(zzedv zzedv2) throws GeneralSecurityException {
        zzedv zzedv3 = zzedv2;
        zzdgk.zza zza2 = this.zzag(zzedv3);
        return (zzdgw.zza)zzdgw.zza.zzbmh().zznw("type.googleapis.com/google.cloud.crypto.tink.HmacKey").zzw(zza2.zzcbm()).zzb(zzdgw.zza.zzb.zzlat).zzccv();
    }

    private static void zzc(zzdgk.zzc zzc2) throws GeneralSecurityException {
        if (zzc2.zzblp() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzc2.zzblo()) {
            case zzkyx: {
                if (zzc2.zzblp() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzkyz: {
                if (zzc2.zzblp() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzkza: {
                if (zzc2.zzblp() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ zzefj zzb(zzefj zzefj2) throws GeneralSecurityException {
        return this.zza((zzdgk.zzb)zzefj2);
    }

    @Override
    public final /* synthetic */ zzefj zzr(zzedv zzedv2) throws GeneralSecurityException {
        return this.zzag(zzedv2);
    }

    @Override
    public final /* synthetic */ Object zza(zzefj zzefj2) throws GeneralSecurityException {
        return this.zzc((zzdgk.zza)zzefj2);
    }

    @Override
    public final /* synthetic */ Object zzq(zzedv zzedv2) throws GeneralSecurityException {
        return this.zzaf(zzedv2);
    }
}

