/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzgx;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhf;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzzr;
import com.google.android.gms.internal.zzzt;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzt
@TargetApi(value=14)
public final class zzhd
extends Thread {
    private boolean mStarted = false;
    private boolean zzayn = false;
    private boolean zzbk = false;
    private final Object mLock;
    private final zzgy zzayo;
    private final zzzr zzayp;
    private final int zzayq;
    private final int zzaxm;
    private final int zzayr;
    private final int zzaxo;
    private final int zzays;
    private final int zzayt;
    private final int zzayu;
    private final int zzayv;
    private final String zzayw;
    private final boolean zzayx;

    public zzhd(zzgy zzgy2, zzzr zzzr2) {
        this.zzayo = zzgy2;
        this.zzayp = zzzr2;
        this.mLock = new Object();
        zzmk<Object> zzmk2 = zzmu.zzbhv;
        this.zzaxm = zzbv.zzen().zzd(zzmk2);
        zzmk2 = zzmu.zzbhw;
        this.zzayr = zzbv.zzen().zzd(zzmk2);
        zzmk2 = zzmu.zzbhx;
        this.zzaxo = zzbv.zzen().zzd(zzmk2);
        zzmk2 = zzmu.zzbhy;
        this.zzays = zzbv.zzen().zzd(zzmk2);
        zzmk2 = zzmu.zzbib;
        this.zzayt = zzbv.zzen().zzd(zzmk2);
        zzmk2 = zzmu.zzbid;
        this.zzayu = zzbv.zzen().zzd(zzmk2);
        zzmk2 = zzmu.zzbie;
        this.zzayv = zzbv.zzen().zzd(zzmk2);
        zzmk2 = zzmu.zzbhz;
        this.zzayq = zzbv.zzen().zzd(zzmk2);
        zzmk2 = zzmu.zzbig;
        this.zzayw = (String)((Object)zzbv.zzen().zzd(zzmk2));
        zzmk2 = zzmu.zzbii;
        this.zzayx = (Boolean)((Object)zzbv.zzen().zzd(zzmk2));
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgn() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                zzafx.zzcb((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzhd.zzgo()) {
                    object = zzbv.zzed().getActivity();
                    if (object == null) {
                        zzafx.zzcb((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzgq();
                    } else {
                        Activity activity = object;
                        zzhd zzhd2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzbv.zzee().zza(exception, "ContentFetchTask.extractContent");
                                zzafx.zzcb((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzhd zzhd3 = zzhd2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzhe(zzhd3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzafx.zzcb((String)"ContentFetchTask: sleeping");
                    this.zzgq();
                }
                Thread.sleep(this.zzayq * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzafx.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzafx.zzb((String)"Error in ContentFetchTask", (Throwable)exception);
                this.zzayp.zza(exception, "ContentFetchTask.run");
            }
            object = this.mLock;
            synchronized (object) {
                while (this.zzayn) {
                    try {
                        zzafx.zzcb((String)"ContentFetchTask: waiting");
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    final void zzf(View view) {
        try {
            zzgx zzgx2 = new zzgx(this.zzaxm, this.zzayr, this.zzaxo, this.zzays, this.zzayt, this.zzayu, this.zzayv);
            zzhh zzhh2 = this.zza(view, zzgx2);
            zzgx2.zzgk();
            if (zzhh2.zzazf == 0 && zzhh2.zzazg == 0) {
                return;
            }
            if (zzhh2.zzazg == 0 && zzgx2.zzgl() == 0) {
                return;
            }
            if (zzhh2.zzazg == 0 && this.zzayo.zza(zzgx2)) {
                return;
            }
            this.zzayo.zzc(zzgx2);
            return;
        }
        catch (Exception exception) {
            zzafx.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzayp.zza(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    private static boolean zzgo() {
        try {
            Context context = zzbv.zzed().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbv.zzee().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    private final zzhh zza(@Nullable View view, zzgx zzgx2) {
        Object object;
        if (view == null) {
            return new zzhh(this, 0, 0);
        }
        Context context = zzbv.zzed().getContext();
        if (context != null) {
            object = zzmu.zzbif;
            int n = context.getResources().getIdentifier(zzbv.zzen().zzd(object), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzayw) && string2 != null && string2.equals(this.zzayw)) {
                return new zzhh(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzgx2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzhh(this, 1, 0);
            }
            return new zzhh(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzakk)) {
            boolean bl2;
            zzgx2.zzgj();
            zzgx zzgx3 = zzgx2;
            WebView webView = (WebView)view;
            object = this;
            if (!zzp.zzalh()) {
                bl2 = false;
            } else {
                zzgx3.zzgj();
                webView.post((Runnable)new zzhf((zzhd)object, zzgx3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzhh(this, 0, 1);
            }
            return new zzhh(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzhh zzhh2 = this.zza(viewGroup.getChildAt(i), zzgx2);
                n += zzhh2.zzazf;
                n2 += zzhh2.zzazg;
            }
            return new zzhh(this, n, n2);
        }
        return new zzhh(this, 0, 0);
    }

    final void zza(zzgx zzgx2, WebView webView, String string2, boolean bl) {
        zzgx2.zzgi();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzayx && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzgx2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzgx2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzgx2.zzgd()) {
                this.zzayo.zzb(zzgx2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzafx.zzcb((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzafx.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzayp.zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzgx zzgp() {
        return this.zzayo.zzgm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzayn = false;
            this.mLock.notifyAll();
            zzafx.zzcb((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzgq() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.zzayn = true;
            zzafx.zzcb((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzgr() {
        return this.zzayn;
    }
}

