/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzuk;
import com.google.android.gms.internal.zzul;
import com.google.android.gms.internal.zzun;
import com.google.android.gms.internal.zzup;
import com.google.android.gms.internal.zzuq;
import com.google.android.gms.internal.zzur;
import com.google.android.gms.internal.zzus;
import com.google.android.gms.internal.zzva;
import com.google.android.gms.internal.zzvd;
import com.google.android.gms.internal.zzvg;
import com.google.android.gms.internal.zzvj;
import com.google.android.gms.internal.zzvt;
import com.google.android.gms.internal.zzwn;
import com.google.android.gms.internal.zzzt;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzt
public final class zzuo
implements zzus {
    private final String zzcbm;
    private final zzva zzana;
    private final long zzcbn;
    private final zzul zzcbo;
    private final zzuk zzcbp;
    private zzix zzari;
    private final zzjb zzaro;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzajk zzapc;
    private final boolean zzauz;
    private final zzot zzaoy;
    private final List<String> zzaoz;
    private final List<String> zzcbq;
    private final List<String> zzcbr;
    private final boolean zzcbs;
    private zzvd zzcbt;
    private int zzcbu = -2;
    private zzvj zzcbv;

    public zzuo(Context context, String string, zzva zzva2, zzul zzul2, zzuk zzuk2, zzix zzix2, zzjb zzjb2, zzajk zzajk2, boolean bl, boolean bl2, zzot zzot2, List<String> list, List<String> list2, List<String> list3) {
        this.mContext = context;
        this.zzana = zzva2;
        this.zzcbp = zzuk2;
        this.zzcbm = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzll() : string;
        this.zzcbo = zzul2;
        this.zzcbn = zzul2.zzcat != -1L ? zzul2.zzcat : 10000L;
        this.zzari = zzix2;
        this.zzaro = zzjb2;
        this.zzapc = zzajk2;
        this.zzauz = bl;
        this.zzcbs = bl2;
        this.zzaoy = zzot2;
        this.zzaoz = list;
        this.zzcbq = list2;
        this.zzcbr = list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzcbt != null) {
                    this.zzcbt.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzafx.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzcbu = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zzll() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzcbp.zzcae)) {
                if (this.zzana.zzbi(this.zzcbp.zzcae)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzafx.zzcs((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzt(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcbu = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzvj zzvj2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcbu = 0;
            this.zzcbv = zzvj2;
            this.mLock.notify();
            return;
        }
    }

    private static zzvd zza(MediationAdapter mediationAdapter) {
        return new zzvt(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzur zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzun zzun2 = new zzun();
            zzahf.zzdbo.post((Runnable)new zzup(this, zzun2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzcbn;
            zzuo zzuo2 = this;
            while (zzuo2.zzcbu == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzuo zzuo3 = zzuo2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzafx.zzcr((String)"Timed out waiting for adapter.");
                    zzuo3.zzcbu = 3;
                    continue;
                }
                try {
                    zzuo3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzuo3.zzcbu = 5;
                }
            }
            long l14 = zzbv.zzeg().elapsedRealtime() - l3;
            return new zzur(this.zzcbp, this.zzcbt, this.zzcbm, zzun2, this.zzcbu, this.zzlm(), l14);
        }
    }

    private final zzvj zzlm() {
        if (this.zzcbu != 0 || !this.zzlo()) {
            return null;
        }
        try {
            if (this.zzu(4) && this.zzcbv != null && this.zzcbv.zzlq() != 0) {
                return this.zzcbv;
            }
        }
        catch (RemoteException remoteException) {
            zzafx.zzcs((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zzlp();
        return new zzuq(n);
    }

    private final zzvd zzln() {
        String string = String.valueOf(this.zzcbm);
        zzafx.zzcr((String)(string.length() != 0 ? "Instantiating mediation adapter: ".concat(string) : new String("Instantiating mediation adapter: ")));
        if (!this.zzauz && !this.zzcbp.zzlk()) {
            zzmk<Boolean> zzmk2 = zzmu.zzbli;
            if (zzbv.zzen().zzd(zzmk2).booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzcbm)) {
                return zzuo.zza((MediationAdapter)new AdMobAdapter());
            }
            zzmk2 = zzmu.zzblj;
            if (zzbv.zzen().zzd(zzmk2).booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzcbm)) {
                return zzuo.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzcbm)) {
                return new zzvt((MediationAdapter)new zzwn());
            }
        }
        try {
            return this.zzana.zzbh(this.zzcbm);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(this.zzcbm);
            zzafx.zza((String)(string2.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string2) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private final void zza(zzun zzun2) {
        String string = this.zzbf(this.zzcbp.zzcaj);
        try {
            if (this.zzapc.zzdem < 4100000) {
                if (this.zzaro.zzbcr) {
                    this.zzcbt.zza(zzn.zzw((Object)this.mContext), this.zzari, string, (zzvg)zzun2);
                    return;
                }
                this.zzcbt.zza(zzn.zzw((Object)this.mContext), this.zzaro, this.zzari, string, (zzvg)zzun2);
                return;
            }
            if (this.zzauz || this.zzcbp.zzlk()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zzaoz);
                if (this.zzcbq != null) {
                    for (String string2 : this.zzcbq) {
                        String string3 = ":false";
                        if (this.zzcbr != null && this.zzcbr.contains(string2)) {
                            string3 = ":true";
                        }
                        String string4 = string3;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("custom:").append(string2).append(string4).toString());
                    }
                }
                this.zzcbt.zza(zzn.zzw((Object)this.mContext), this.zzari, string, this.zzcbp.zzcaa, (zzvg)zzun2, this.zzaoy, arrayList);
                return;
            }
            if (this.zzaro.zzbcr) {
                this.zzcbt.zza(zzn.zzw((Object)this.mContext), this.zzari, string, this.zzcbp.zzcaa, (zzvg)zzun2);
                return;
            }
            if (this.zzcbs) {
                if (this.zzcbp.zzcam != null) {
                    this.zzcbt.zza(zzn.zzw((Object)this.mContext), this.zzari, string, this.zzcbp.zzcaa, (zzvg)zzun2, new zzot(zzuo.zzbg(this.zzcbp.zzcaq)), this.zzcbp.zzcap);
                    return;
                }
                this.zzcbt.zza(zzn.zzw((Object)this.mContext), this.zzaro, this.zzari, string, this.zzcbp.zzcaa, (zzvg)zzun2);
                return;
            }
            this.zzcbt.zza(zzn.zzw((Object)this.mContext), this.zzaro, this.zzari, string, this.zzcbp.zzcaa, (zzvg)zzun2);
            return;
        }
        catch (RemoteException remoteException) {
            zzafx.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzt(5);
            return;
        }
    }

    private final boolean zzu(int n) {
        Bundle bundle;
        try {
            bundle = this.zzauz ? this.zzcbt.zzlv() : (this.zzaro.zzbcr ? this.zzcbt.getInterstitialAdapterInfo() : this.zzcbt.zzlu());
        }
        catch (RemoteException remoteException) {
            zzafx.zzcs((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zzlo() {
        return this.zzcbo.zzcbd != -1;
    }

    private final String zzbf(String string) {
        if (string == null || !this.zzlo() || this.zzu(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzafx.zzcs((String)"Could not remove field. Returning the original value");
            return string;
        }
    }

    private final int zzlp() {
        JSONObject jSONObject;
        if (this.zzcbp.zzcaj == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzcbp.zzcaj);
        }
        catch (JSONException jSONException) {
            zzafx.zzcs((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzcbm)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzu(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzbg(String string) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string == null) {
            return builder.build();
        }
        try {
            String string2;
            JSONObject jSONObject = new JSONObject(string);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = string2 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string3) ? 2 : ("portrait".equals(string3) ? 1 : ("any".equals(string3) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzafx.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzuo zzuo2) {
        return zzuo2.mLock;
    }

    static /* synthetic */ int zzb(zzuo zzuo2) {
        return zzuo2.zzcbu;
    }

    static /* synthetic */ zzvd zza(zzuo zzuo2, zzvd zzvd2) {
        zzuo2.zzcbt = zzvd2;
        return zzuo2.zzcbt;
    }

    static /* synthetic */ zzvd zzc(zzuo zzuo2) {
        return zzuo2.zzln();
    }

    static /* synthetic */ zzvd zzd(zzuo zzuo2) {
        return zzuo2.zzcbt;
    }

    static /* synthetic */ boolean zze(zzuo zzuo2) {
        return zzuo2.zzlo();
    }

    static /* synthetic */ boolean zza(zzuo zzuo2, int n) {
        return zzuo2.zzu(1);
    }

    static /* synthetic */ String zzf(zzuo zzuo2) {
        return zzuo2.zzcbm;
    }

    static /* synthetic */ void zza(zzuo zzuo2, zzun zzun2) {
        zzuo2.zza(zzun2);
    }
}

