/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzwu;
import com.google.android.gms.internal.zzxd;
import com.google.android.gms.internal.zzxe;
import com.google.android.gms.internal.zzzt;
import java.util.Map;
import java.util.Set;

@zzzt
public final class zzwt
extends zzxd {
    private static Set<String> zzcdr = zze.zzb((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzcds = "top-right";
    private boolean zzcdt = true;
    private int zzcdu = 0;
    private int zzcdv = 0;
    private int zzakw = -1;
    private int zzcdw = 0;
    private int zzcdx = 0;
    private int zzakv = -1;
    private final Object mLock = new Object();
    private final zzakk zzbvz;
    private final Activity zzcdi;
    private zzjb zzaro;
    private ImageView zzcdy;
    private LinearLayout zzcdz;
    private zzxe zzcea;
    private PopupWindow zzceb;
    private RelativeLayout zzcec;
    private ViewGroup zzced;

    public zzwt(zzakk zzakk2, zzxe zzxe2) {
        super(zzakk2, "resize");
        this.zzbvz = zzakk2;
        this.zzcdi = zzakk2.zzrx();
        this.zzcea = zzxe2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzcdi == null) {
                this.zzbn("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbvz.zzbl() == null) {
                this.zzbn("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbvz.zzbl().zzbcr) {
                this.zzbn("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbvz.zzsf()) {
                this.zzbn("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzwt zzwt2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbv.zzea();
                zzwt2.zzakv = zzahf.zzci(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbv.zzea();
                zzwt2.zzakw = zzahf.zzci(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbv.zzea();
                zzwt2.zzcdw = zzahf.zzci(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbv.zzea();
                zzwt2.zzcdx = zzahf.zzci(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzwt2.zzcdt = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzwt2.zzcds = string2;
            }
            zzwt2 = this;
            if (!(zzwt2.zzakv >= 0 && zzwt2.zzakw >= 0)) {
                this.zzbn("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzcdi.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbn("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzme();
            if (nArray == null) {
                this.zzbn("Resize location out of screen or close button is not visible.");
                return;
            }
            zzjo.zzhu();
            int n = zzaje.zzc((Context)this.zzcdi, (int)this.zzakv);
            zzjo.zzhu();
            int n2 = zzaje.zzc((Context)this.zzcdi, (int)this.zzakw);
            zzakk zzakk2 = this.zzbvz;
            if (zzakk2 == null) {
                throw null;
            }
            ViewParent viewParent = ((View)zzakk2).getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                zzakk zzakk3 = this.zzbvz;
                if (zzakk3 == null) {
                    throw null;
                }
                ((ViewGroup)viewParent).removeView((View)zzakk3);
                if (this.zzceb == null) {
                    this.zzced = (ViewGroup)viewParent;
                    zzbv.zzea();
                    zzakk zzakk4 = this.zzbvz;
                    if (zzakk4 == null) {
                        throw null;
                    }
                    bitmap = zzahf.zzl((View)zzakk4);
                    this.zzcdy = new ImageView((Context)this.zzcdi);
                    this.zzcdy.setImageBitmap(bitmap);
                    this.zzaro = this.zzbvz.zzbl();
                    this.zzced.addView((View)this.zzcdy);
                } else {
                    this.zzceb.dismiss();
                }
            } else {
                this.zzbn("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzcec = new RelativeLayout((Context)this.zzcdi);
            this.zzcec.setBackgroundColor(0);
            this.zzcec.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbv.zzea();
            this.zzceb = zzahf.zza((View)this.zzcec, n, n2, false);
            this.zzceb.setOutsideTouchable(true);
            this.zzceb.setTouchable(true);
            this.zzceb.setClippingEnabled(!this.zzcdt);
            zzakk zzakk5 = this.zzbvz;
            if (zzakk5 == null) {
                throw null;
            }
            this.zzcec.addView((View)zzakk5, -1, -1);
            this.zzcdz = new LinearLayout((Context)this.zzcdi);
            zzjo.zzhu();
            int n3 = zzaje.zzc((Context)this.zzcdi, (int)50);
            zzjo.zzhu();
            bitmap = new RelativeLayout.LayoutParams(n3, zzaje.zzc((Context)this.zzcdi, (int)50));
            switch (this.zzcds) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzcdz.setOnClickListener((View.OnClickListener)new zzwu(this));
            this.zzcdz.setContentDescription((CharSequence)"Close button");
            this.zzcec.addView((View)this.zzcdz, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzjo.zzhu();
                int n4 = zzaje.zzc((Context)this.zzcdi, (int)nArray[0]);
                zzjo.zzhu();
                this.zzceb.showAtLocation(view, 0, n4, zzaje.zzc((Context)this.zzcdi, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzbn(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                zzakk zzakk6 = this.zzbvz;
                if (zzakk6 == null) {
                    throw null;
                }
                this.zzcec.removeView((View)zzakk6);
                if (this.zzced != null) {
                    this.zzced.removeView((View)this.zzcdy);
                    zzakk zzakk7 = this.zzbvz;
                    if (zzakk7 == null) {
                        throw null;
                    }
                    this.zzced.addView((View)zzakk7);
                    this.zzbvz.zza(this.zzaro);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzwt2 = this;
            if (zzwt2.zzcea != null) {
                zzwt2.zzcea.zza(n6, n5, zzwt2.zzakv, zzwt2.zzakw);
            }
            this.zzbvz.zza(new zzjb((Context)this.zzcdi, new AdSize(this.zzakv, this.zzakw)));
            this.zza(nArray[0], nArray[1]);
            this.zzbp("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzl(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzceb != null) {
                this.zzceb.dismiss();
                zzakk zzakk2 = this.zzbvz;
                if (zzakk2 == null) {
                    throw null;
                }
                this.zzcec.removeView((View)zzakk2);
                if (this.zzced != null) {
                    this.zzced.removeView((View)this.zzcdy);
                    zzakk zzakk3 = this.zzbvz;
                    if (zzakk3 == null) {
                        throw null;
                    }
                    this.zzced.addView((View)zzakk3);
                    this.zzbvz.zza(this.zzaro);
                }
                if (bl) {
                    this.zzbp("default");
                    if (this.zzcea != null) {
                        this.zzcea.zzcm();
                    }
                }
                this.zzceb = null;
                this.zzcec = null;
                this.zzced = null;
                this.zzcdz = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzme() {
        zzwt zzwt2 = this;
        int[] nArray = zzbv.zzea().zzg(zzwt2.zzcdi);
        int[] nArray2 = zzbv.zzea().zzh(zzwt2.zzcdi);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzwt2.zzakv < 50 || zzwt2.zzakv > n) {
            zzafx.zzcs((String)"Width is too small or too large.");
            return null;
        }
        if (zzwt2.zzakw < 50 || zzwt2.zzakw > n2) {
            zzafx.zzcs((String)"Height is too small or too large.");
            return null;
        }
        if (zzwt2.zzakw == n2 && zzwt2.zzakv == n) {
            zzafx.zzcs((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzwt2.zzcdt) {
            int n3;
            int n4;
            switch (zzwt2.zzcds) {
                case "top-left": {
                    n4 = zzwt2.zzcdu + zzwt2.zzcdw;
                    n3 = zzwt2.zzcdv + zzwt2.zzcdx;
                    break;
                }
                case "top-center": {
                    n4 = zzwt2.zzcdu + zzwt2.zzcdw + zzwt2.zzakv / 2 - 25;
                    n3 = zzwt2.zzcdv + zzwt2.zzcdx;
                    break;
                }
                case "center": {
                    n4 = zzwt2.zzcdu + zzwt2.zzcdw + zzwt2.zzakv / 2 - 25;
                    n3 = zzwt2.zzcdv + zzwt2.zzcdx + zzwt2.zzakw / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzwt2.zzcdu + zzwt2.zzcdw;
                    n3 = zzwt2.zzcdv + zzwt2.zzcdx + zzwt2.zzakw - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzwt2.zzcdu + zzwt2.zzcdw + zzwt2.zzakv / 2 - 25;
                    n3 = zzwt2.zzcdv + zzwt2.zzcdx + zzwt2.zzakw - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzwt2.zzcdu + zzwt2.zzcdw + zzwt2.zzakv - 50;
                    n3 = zzwt2.zzcdv + zzwt2.zzcdx + zzwt2.zzakw - 50;
                    break;
                }
                default: {
                    n4 = zzwt2.zzcdu + zzwt2.zzcdw + zzwt2.zzakv - 50;
                    n3 = zzwt2.zzcdv + zzwt2.zzcdx;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzcdt) {
            return new int[]{this.zzcdu + this.zzcdw, this.zzcdv + this.zzcdx};
        }
        int[] nArray3 = zzbv.zzea().zzg(this.zzcdi);
        int[] nArray4 = zzbv.zzea().zzh(this.zzcdi);
        int n5 = nArray3[0];
        int n6 = this.zzcdu + this.zzcdw;
        int n7 = this.zzcdv + this.zzcdx;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzakv > n5) {
            n6 = n5 - this.zzakv;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzakw <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzakw;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcdu = n;
            this.zzcdv = n2;
            if (this.zzceb != null && bl) {
                int[] nArray = this.zzme();
                if (nArray != null) {
                    zzjo.zzhu();
                    int n3 = zzaje.zzc((Context)this.zzcdi, (int)nArray[0]);
                    zzjo.zzhu();
                    this.zzceb.update(n3, zzaje.zzc((Context)this.zzcdi, (int)nArray[1]), this.zzceb.getWidth(), this.zzceb.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzl(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbv.zzea().zzh(this.zzcdi)[0];
        this.zzb(n, n2 - n3, this.zzakv, this.zzakw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzmf() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzceb != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzcdu = n;
        this.zzcdv = n2;
    }
}

