/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzwx;
import com.google.android.gms.internal.zzwy;
import com.google.android.gms.internal.zzxd;
import com.google.android.gms.internal.zzzt;
import java.util.Map;

@zzzt
public final class zzww
extends zzxd {
    private final Map<String, String> zzbqo;
    private final Context mContext;

    public zzww(zzakk zzakk2, Map<String, String> map) {
        super(zzakk2, "storePicture");
        this.zzbqo = map;
        this.mContext = zzakk2.zzrx();
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbn("Activity context is not available");
            return;
        }
        zzbv.zzea();
        if (!zzahf.zzak(this.mContext).zzii()) {
            this.zzbn("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzbqo.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbn("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzbn(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzbv.zzea();
        if (!zzahf.zzcj(string4)) {
            String string5 = String.valueOf(string4);
            this.zzbn(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzbv.zzee().getResources();
        zzbv.zzea();
        AlertDialog.Builder builder = zzahf.zzaj(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzwx(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzwy(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzww zzww2) {
        return zzww2.mContext;
    }
}

