/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzajf;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.internal.zzsf;
import com.google.android.gms.internal.zzzn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzzn
public final class zzsk
extends zzse {
    private static final Set<String> zzbwr = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzbws = new DecimalFormat("#,###");
    private File zzbwt;
    private boolean zzbwu;

    public zzsk(zzakl zzakl2) {
        super(zzakl2);
        File file = this.mContext.getCacheDir();
        if (file == null) {
            zzafy.zzcr((String)"Context.getCacheDir() returned null");
            return;
        }
        this.zzbwt = new File(file, "admobVideoStreams");
        if (!this.zzbwt.isDirectory() && !this.zzbwt.mkdirs()) {
            String string2 = String.valueOf(this.zzbwt.getAbsolutePath());
            zzafy.zzcr((String)(string2.length() != 0 ? "Could not create preload cache directory at ".concat(string2) : new String("Could not create preload cache directory at ")));
            this.zzbwt = null;
            return;
        }
        if (!this.zzbwt.setReadable(true, false) || !this.zzbwt.setExecutable(true, false)) {
            String string3 = String.valueOf(this.zzbwt.getAbsolutePath());
            zzafy.zzcr((String)(string3.length() != 0 ? "Could not set cache file permissions at ".concat(string3) : new String("Could not set cache file permissions at ")));
            this.zzbwt = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzat(String string2) {
        int n;
        int n2;
        Object object;
        Object object2;
        block35: {
            int n3;
            if (this.zzbwt == null) {
                this.zza(string2, null, "noCacheDir", null);
                return false;
            }
            do {
                int n4;
                object2 = this;
                if (((zzsk)object2).zzbwt == null) {
                    n4 = 0;
                } else {
                    int n5 = 0;
                    object = ((zzsk)object2).zzbwt.listFiles();
                    n2 = ((File[])object).length;
                    for (n = 0; n < n2; ++n) {
                        if (object[n].getName().endsWith(".done")) continue;
                        ++n5;
                    }
                    n4 = n5;
                }
                object2 = zzmn.zzbgg;
                if (n4 <= (Integer)zzbv.zzen().zzd(object2)) break block35;
                object2 = this;
                if (((zzsk)object2).zzbwt == null) {
                    n3 = 0;
                    continue;
                }
                File file = null;
                long l = Long.MAX_VALUE;
                for (File file2 : ((zzsk)object2).zzbwt.listFiles()) {
                    long l2;
                    if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
                    file = file2;
                    l = l2;
                }
                n = 0;
                if (file != null) {
                    n = file.delete() ? 1 : 0;
                    File file3 = super.zzb(file);
                    if (file3.isFile()) {
                        n &= file3.delete();
                    }
                }
                n3 = n;
            } while (n3 != 0);
            zzafy.zzcr((String)"Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        object2 = string2;
        zzjh.zzhu();
        String string3 = zzajf.zzcp((String)object2);
        File file = new File(this.zzbwt, string3);
        File file4 = this.zzb(file);
        if (file.isFile() && file4.isFile()) {
            int n6 = (int)file.length();
            String string4 = String.valueOf(string2);
            zzafy.zzca((String)(string4.length() != 0 ? "Stream cache hit at ".concat(string4) : new String("Stream cache hit at ")));
            this.zza(string2, file.getAbsolutePath(), n6);
            return true;
        }
        String string5 = String.valueOf(this.zzbwt.getAbsolutePath());
        String string6 = String.valueOf(string2);
        String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        Object object3 = zzbwr;
        synchronized (object3) {
            if (zzbwr.contains(string7)) {
                String string8 = String.valueOf(string2);
                zzafy.zzcr((String)(string8.length() != 0 ? "Stream cache already in progress at ".concat(string8) : new String("Stream cache already in progress at ")));
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzbwr.add(string7);
        }
        object3 = null;
        String string9 = "error";
        String string10 = null;
        try {
            int n7;
            int n8;
            zzbv.zzeo();
            object2 = zzmn.zzbgl;
            HttpURLConnection httpURLConnection = zzajz.zzb(string2, zzbv.zzen().zzd(object2));
            if (httpURLConnection instanceof HttpURLConnection && (n8 = httpURLConnection.getResponseCode()) >= 400) {
                string9 = "badUrl";
                String string11 = String.valueOf(Integer.toString(n8));
                string10 = string11.length() != 0 ? "HTTP request failed. Code: ".concat(string11) : new String("HTTP request failed. Code: ");
                throw new IOException(new StringBuilder(32 + String.valueOf(string2).length()).append("HTTP status code ").append(n8).append(" at ").append(string2).toString());
            }
            n8 = httpURLConnection.getContentLength();
            if (n8 < 0) {
                String string12 = String.valueOf(string2);
                zzafy.zzcr((String)(string12.length() != 0 ? "Stream cache aborted, missing content-length header at ".concat(string12) : new String("Stream cache aborted, missing content-length header at ")));
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzbwr.remove(string7);
                return false;
            }
            String string13 = zzbws.format(n8);
            object2 = zzmn.zzbgh;
            int n9 = zzbv.zzen().zzd(object2);
            if (n8 > n9) {
                zzafy.zzcr((String)new StringBuilder(33 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Content length ").append(string13).append(" exceeds limit at ").append(string2).toString());
                String string14 = String.valueOf(string13);
                String string15 = string14.length() != 0 ? "File too big for full file cache. Size: ".concat(string14) : new String("File too big for full file cache. Size: ");
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string15);
                zzbwr.remove(string7);
                return false;
            }
            zzafy.zzca((String)new StringBuilder(20 + String.valueOf(string13).length() + String.valueOf(string2).length()).append("Caching ").append(string13).append(" bytes from ").append(string2).toString());
            ReadableByteChannel readableByteChannel = Channels.newChannel(httpURLConnection.getInputStream());
            object3 = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object3).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zzd zzd2 = zzbv.zzeg();
            int n10 = 0;
            long l = zzd2.currentTimeMillis();
            object2 = zzmn.zzbgk;
            long l3 = (Long)((Object)zzbv.zzen().zzd(object2));
            zzaiy zzaiy2 = new zzaiy(l3);
            object2 = zzmn.zzbgj;
            long l4 = (Long)((Object)zzbv.zzen().zzd(object2));
            while ((n7 = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n10 += n7) > n9) {
                    string9 = "sizeExceeded";
                    String string16 = String.valueOf(Integer.toString(n10));
                    string10 = string16.length() != 0 ? "File too big for full file cache. Size: ".concat(string16) : new String("File too big for full file cache. Size: ");
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                if (zzd2.currentTimeMillis() - l > l4 * 1000L) {
                    string9 = "downloadTimeout";
                    String string17 = Long.toString(l4);
                    string10 = new StringBuilder(29 + String.valueOf(string17).length()).append("Timeout exceeded. Limit: ").append(string17).append(" sec").toString();
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzbwu) {
                    string9 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzaiy2.tryAcquire()) continue;
                n = n8;
                n2 = n10;
                object = file.getAbsolutePath();
                String string18 = string2;
                object2 = this;
                zzajf.zzdep.post((Runnable)new zzsf((zzse)object2, string18, (String)object, n2, n, false));
            }
            ((FileOutputStream)object3).close();
            if (zzafy.zzad((int)3)) {
                String string19 = zzbws.format(n10);
                zzafy.zzca((String)new StringBuilder(22 + String.valueOf(string19).length() + String.valueOf(string2).length()).append("Preloaded ").append(string19).append(" bytes from ").append(string2).toString());
            }
            file.setReadable(true, false);
            object2 = file4;
            if (((File)object2).isFile()) {
                ((File)object2).setLastModified(System.currentTimeMillis());
            } else {
                try {
                    ((File)object2).createNewFile();
                }
                catch (IOException iOException) {}
            }
            this.zza(string2, file.getAbsolutePath(), n10);
            zzbwr.remove(string7);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            Exception exception2 = exception;
            if (exception instanceof RuntimeException) {
                zzbv.zzee().zza(exception2, "VideoStreamFullFileCache.preload");
            }
            try {
                ((FileOutputStream)object3).close();
            }
            catch (IOException | NullPointerException exception3) {}
            if (this.zzbwu) {
                zzafy.zzcq((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Preload aborted for URL \"").append(string2).append("\"").toString());
            } else {
                zzafy.zzc((String)new StringBuilder(25 + String.valueOf(string2).length()).append("Preload failed for URL \"").append(string2).append("\"").toString(), (Throwable)exception2);
            }
            if (file.exists() && !file.delete()) {
                String string20 = String.valueOf(file.getAbsolutePath());
                zzafy.zzcr((String)(string20.length() != 0 ? "Could not delete partial cache file at ".concat(string20) : new String("Could not delete partial cache file at ")));
            }
            this.zza(string2, file.getAbsolutePath(), string9, string10);
            zzbwr.remove(string7);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzbwu = true;
    }

    private final File zzb(File file) {
        return new File(this.zzbwt, String.valueOf(file.getName()).concat(".done"));
    }
}

