/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzag;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzzn;

@zzzn
public final class zza {
    public static boolean zza(Context context, zzc zzc2, zzag zzag2) {
        String[] stringArray;
        if (zzc2 == null) {
            zzafy.zzcr((String)"No intent data for launcher overlay.");
            return false;
        }
        zzmn.initialize(context);
        if (zzc2.intent != null) {
            return zza.zza(context, zzc2.intent, zzag2);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)zzc2.url)) {
            zzafy.zzcr((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.mimeType)) {
            intent.setDataAndType(Uri.parse((String)zzc2.url), zzc2.mimeType);
        } else {
            intent.setData(Uri.parse((String)zzc2.url));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)zzc2.packageName)) {
            intent.setPackage(zzc2.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzcfc)) {
            stringArray = zzc2.zzcfc.split("/", 2);
            if (stringArray.length < 2) {
                String string = String.valueOf(zzc2.zzcfc);
                zzafy.zzcr((String)(string.length() != 0 ? "Could not parse component name from open GMSG: ".concat(string) : new String("Could not parse component name from open GMSG: ")));
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        stringArray = zzc2.zzcfd;
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzcfd)) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzafy.zzcr((String)"Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        zzmd<Boolean> zzmd2 = zzmn.zzbop;
        if (zzbv.zzen().zzd(zzmd2).booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
        } else {
            zzmd2 = zzmn.zzboo;
            if (zzbv.zzen().zzd(zzmd2).booleanValue()) {
                zzbv.zzea();
                zzahg.zzc(context, intent);
            }
        }
        return zza.zza(context, intent, zzag2);
    }

    private static boolean zza(Context context, Intent intent, zzag zzag2) {
        try {
            String string = String.valueOf(intent.toURI());
            zzafy.v(string.length() != 0 ? "Launching an intent: ".concat(string) : new String("Launching an intent: "));
            zzbv.zzea();
            zzahg.zzb(context, intent);
            if (zzag2 != null) {
                zzag2.zzbl();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzafy.zzcr((String)activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

