/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzab;
import com.google.android.gms.ads.internal.overlay.zzac;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzas;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zzzn;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@zzzn
public final class zzaa
extends FrameLayout
implements zzx {
    private final zzakl zzbvz;
    private final FrameLayout zzchm;
    private final zzna zzchn;
    private final zzas zzcho;
    private final long zzchp;
    @Nullable
    private zzy zzchq;
    private boolean zzchr;
    private boolean zzchs;
    private boolean zzcht;
    private boolean zzchu;
    private long zzchv;
    private long zzchw;
    private String zzbwe;
    private Bitmap zzchx;
    private ImageView zzchy;
    private boolean zzchz;

    public static void zzg(zzakl zzakl2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzakl2.zza("onVideoEvent", hashMap);
    }

    public static void zzc(zzakl zzakl2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzakl2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzakl zzakl2, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string);
        zzakl2.zza("onVideoEvent", hashMap);
    }

    public zzaa(Context context, zzakl zzakl2, int n, boolean bl, zzna zzna2, zzaq zzaq2) {
        super(context);
        zzmd<Constable> zzmd2;
        this.zzbvz = zzakl2;
        this.zzchn = zzna2;
        this.zzchm = new FrameLayout(context);
        this.addView((View)this.zzchm, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzr((Object)zzakl2.zzbi());
        this.zzchq = zzakl2.zzbi().zzanf.zza(context, zzakl2, n, bl, zzna2, zzaq2);
        if (this.zzchq != null) {
            this.zzchm.addView((View)this.zzchq, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzmd2 = zzmn.zzbgp;
            if (((Boolean)((Object)zzbv.zzen().zzd(zzmd2))).booleanValue()) {
                this.zznh();
            }
        }
        this.zzchy = new ImageView(context);
        zzmd2 = zzmn.zzbgt;
        this.zzchp = zzbv.zzen().zzd(zzmd2);
        zzmd2 = zzmn.zzbgr;
        this.zzchu = (Boolean)((Object)zzbv.zzen().zzd(zzmd2));
        if (this.zzchn != null) {
            this.zzchn.zzf("spinner_used", this.zzchu ? "1" : "0");
        }
        this.zzcho = new zzas(this);
        if (this.zzchq != null) {
            this.zzchq.zza(this);
        }
        if (this.zzchq == null) {
            this.zzh("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzchm.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzbp(String string) {
        this.zzbwe = string;
    }

    public final void zza(float f, float f2) {
        if (this.zzchq != null) {
            this.zzchq.zza(f, f2);
        }
    }

    public final void zzne() {
        if (this.zzchq == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzbwe)) {
            this.zzchq.setVideoPath(this.zzbwe);
            return;
        }
        this.zza("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzchq == null) {
            return;
        }
        this.zzchq.pause();
    }

    public final void play() {
        if (this.zzchq == null) {
            return;
        }
        this.zzchq.play();
    }

    public final void seekTo(int n) {
        if (this.zzchq == null) {
            return;
        }
        this.zzchq.seekTo(n);
    }

    public final void zznf() {
        if (this.zzchq == null) {
            return;
        }
        zzy zzy2 = this.zzchq;
        zzy2.zzchl.setMuted(true);
        zzy2.zzmn();
    }

    public final void zzng() {
        if (this.zzchq == null) {
            return;
        }
        zzy zzy2 = this.zzchq;
        zzy2.zzchl.setMuted(false);
        zzy2.zzmn();
    }

    public final void zzb(float f) {
        if (this.zzchq == null) {
            return;
        }
        float f2 = f;
        zzy zzy2 = this.zzchq;
        zzy2.zzchl.zzb(f2);
        zzy2.zzmn();
    }

    @TargetApi(value=14)
    public final void zze(MotionEvent motionEvent) {
        if (this.zzchq == null) {
            return;
        }
        this.zzchq.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zznh() {
        if (this.zzchq == null) {
            return;
        }
        Context context = this.zzchq.getContext();
        TextView textView = new TextView(context);
        String string = String.valueOf(this.zzchq.zzmj());
        textView.setText((CharSequence)(string.length() != 0 ? "AdMob - ".concat(string) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzchm.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzchm.bringChildToFront((View)textView);
    }

    @Override
    public final void zzmy() {
        this.zzcho.resume();
        zzahg.zzdbz.post((Runnable)new zzab(this));
    }

    @Override
    public final void zzmz() {
        if (this.zzchq == null) {
            return;
        }
        if (this.zzchw == 0L) {
            float f = (float)this.zzchq.getDuration() / 1000.0f;
            int n = this.zzchq.getVideoWidth();
            int n2 = this.zzchq.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzna() {
        zzaa zzaa2 = this;
        if (zzaa2.zzbvz.zzsa() != null && !zzaa2.zzchs) {
            WindowManager.LayoutParams layoutParams = zzaa2.zzbvz.zzsa().getWindow().getAttributes();
            boolean bl = zzaa2.zzcht = (layoutParams.flags & 0x80) != 0;
            if (!zzaa2.zzcht) {
                zzaa2.zzbvz.zzsa().getWindow().addFlags(128);
                zzaa2.zzchs = true;
            }
        }
        this.zzchr = true;
    }

    @Override
    public final void onPaused() {
        this.zza("pause", new String[0]);
        this.zznk();
        this.zzchr = false;
    }

    @Override
    public final void zznb() {
        this.zza("ended", new String[0]);
        this.zznk();
    }

    @Override
    public final void zzh(String string, @Nullable String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public final void zznc() {
        zzaa zzaa2 = this;
        if (zzaa2.zzchz && zzaa2.zzchx != null && !zzaa2.zznj()) {
            zzaa2.zzchy.setImageBitmap(zzaa2.zzchx);
            zzaa2.zzchy.invalidate();
            zzaa2.zzchm.addView((View)zzaa2.zzchy, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzaa2.zzchm.bringChildToFront((View)zzaa2.zzchy);
        }
        this.zzcho.pause();
        this.zzchw = this.zzchv;
        zzahg.zzdbz.post((Runnable)new zzac(this));
    }

    public final void destroy() {
        this.zzcho.pause();
        if (this.zzchq != null) {
            this.zzchq.stop();
        }
        this.zznk();
    }

    final void zzni() {
        if (this.zzchq == null) {
            return;
        }
        long l = this.zzchq.getCurrentPosition();
        if (this.zzchv != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzchv = l;
        }
    }

    @Override
    public final void zznd() {
        zzaa zzaa2;
        if (this.zzchr && (zzaa2 = this).zznj()) {
            zzaa2.zzchm.removeView((View)zzaa2.zzchy);
        }
        zzaa2 = this;
        if (zzaa2.zzchx != null) {
            long l = zzbv.zzeg().elapsedRealtime();
            if (zzaa2.zzchq.getBitmap(zzaa2.zzchx) != null) {
                zzaa2.zzchz = true;
            }
            long l2 = zzbv.zzeg().elapsedRealtime() - l;
            if (zzafy.zzqu()) {
                zzafy.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzaa2.zzchp) {
                zzafy.zzcr((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzaa2.zzchu = false;
                zzaa2.zzchx = null;
                if (zzaa2.zzchn != null) {
                    zzaa2.zzchn.zzf("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzd(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzaa zzaa2 = this;
        if (zzaa2.zzchu) {
            zzmd<Integer> zzmd2 = zzmn.zzbgs;
            n4 = Math.max(n4 / zzbv.zzen().zzd(zzmd2), 1);
            zzmd2 = zzmn.zzbgs;
            n3 = Math.max(n3 / zzbv.zzen().zzd(zzmd2), 1);
            if (zzaa2.zzchx == null || zzaa2.zzchx.getWidth() != n4 || zzaa2.zzchx.getHeight() != n3) {
                zzaa2.zzchx = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzaa2.zzchz = false;
            }
        }
    }

    private final boolean zznj() {
        return this.zzchy.getParent() != null;
    }

    private final void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray2[i];
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzbvz.zza("onVideoEvent", hashMap);
    }

    private final void zznk() {
        if (this.zzbvz.zzsa() == null) {
            return;
        }
        if (this.zzchs && !this.zzcht) {
            this.zzbvz.zzsa().getWindow().clearFlags(128);
            this.zzchs = false;
        }
    }

    static /* synthetic */ void zza(zzaa zzaa2, String string, String[] stringArray) {
        zzaa2.zza(string, stringArray);
    }
}

