/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.overlay.zzan;
import com.google.android.gms.ads.internal.overlay.zzao;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzzn;

@zzzn
final class zzam
implements SensorEventListener {
    private final SensorManager zzcih;
    private final Object zzcii;
    private final Display zzcij;
    private final float[] zzcik;
    private final float[] zzcil;
    private float[] zzcim;
    private Handler zzcin;
    private zzao zzcio;

    zzam(Context context) {
        this.zzcih = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzcij = windowManager.getDefaultDisplay();
        this.zzcik = new float[9];
        this.zzcil = new float[9];
        this.zzcii = new Object();
    }

    final void start() {
        if (this.zzcin != null) {
            return;
        }
        Sensor sensor = this.zzcih.getDefaultSensor(11);
        if (sensor == null) {
            zzafy.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzcin = new Handler(handlerThread.getLooper());
        if (!this.zzcih.registerListener((SensorEventListener)this, sensor, 0, this.zzcin)) {
            zzafy.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzcin == null) {
            return;
        }
        this.zzcih.unregisterListener((SensorEventListener)this);
        this.zzcin.post((Runnable)new zzan(this));
        this.zzcin = null;
    }

    final void zza(zzao zzao2) {
        this.zzcio = zzao2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzam zzam2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzam2.zzcii;
            synchronized (object) {
                if (zzam2.zzcim == null) {
                    zzam2.zzcim = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzam2.zzcik, (float[])fArray);
            switch (zzam2.zzcij.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzcik, (int)2, (int)129, (float[])zzam2.zzcil);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzcik, (int)129, (int)130, (float[])zzam2.zzcil);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzam2.zzcik, (int)130, (int)1, (float[])zzam2.zzcil);
                    break;
                }
                default: {
                    System.arraycopy(zzam2.zzcik, 0, zzam2.zzcil, 0, 9);
                }
            }
            zzam2.zze(1, 3);
            zzam2.zze(2, 6);
            zzam2.zze(5, 7);
            Object object2 = zzam2.zzcii;
            synchronized (object2) {
                System.arraycopy(zzam2.zzcil, 0, zzam2.zzcim, 0, 9);
            }
            if (zzam2.zzcio != null) {
                zzam2.zzcio.zzmu();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzcii;
        synchronized (object) {
            if (this.zzcim == null) {
                return false;
            }
            System.arraycopy(this.zzcim, 0, fArray, 0, this.zzcim.length);
            return true;
        }
    }

    private final void zze(int n, int n2) {
        float f = this.zzcil[n];
        this.zzcil[n] = this.zzcil[n2];
        this.zzcil[n2] = f;
    }
}

