/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzam;
import com.google.android.gms.ads.internal.overlay.zzao;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzzn;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzzn
@TargetApi(value=14)
public final class zzap
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzao {
    private static final float[] zzcip = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzam zzciq;
    private final float[] zzcim;
    private final float[] zzcir;
    private final float[] zzcis;
    private final float[] zzcit;
    private final float[] zzciu;
    private final float[] zzciv;
    private final float[] zzciw;
    private float zzcix;
    private float zzciy;
    private float zzciz;
    private int zzakq;
    private int zzakp;
    private SurfaceTexture zzcja;
    private SurfaceTexture zzcjb;
    private int zzcjc;
    private int zzcjd;
    private int zzcje;
    private FloatBuffer zzcjf = ByteBuffer.allocateDirect(zzcip.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzcjg;
    private final Object zzcjh;
    private EGL10 zzcji;
    private EGLDisplay zzcjj;
    private EGLContext zzcjk;
    private EGLSurface zzcjl;
    private volatile boolean zzcjm;
    private volatile boolean zzcjn;

    public zzap(Context context) {
        super("SphericalVideoProcessor");
        this.zzcjf.put(zzcip).position(0);
        this.zzcim = new float[9];
        this.zzcir = new float[9];
        this.zzcis = new float[9];
        this.zzcit = new float[9];
        this.zzciu = new float[9];
        this.zzciv = new float[9];
        this.zzciw = new float[9];
        this.zzcix = Float.NaN;
        this.zzciq = new zzam(context);
        this.zzciq.zza(this);
        this.zzcjg = new CountDownLatch(1);
        this.zzcjh = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzakp = n;
        this.zzakq = n2;
        this.zzcjb = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzf(int n, int n2) {
        Object object = this.zzcjh;
        synchronized (object) {
            this.zzakp = n;
            this.zzakq = n2;
            this.zzcjm = true;
            this.zzcjh.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zznl() {
        Object object = this.zzcjh;
        synchronized (object) {
            this.zzcjn = true;
            this.zzcjb = null;
            this.zzcjh.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zznm() {
        if (this.zzcjb == null) {
            return null;
        }
        try {
            this.zzcjg.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzcja;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzcje;
        Object object = this.zzcjh;
        synchronized (object) {
            this.zzcjh.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzmu() {
        Object object = this.zzcjh;
        synchronized (object) {
            this.zzcjh.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string;
        zzmd<String> zzmd2;
        Object object;
        Object object2;
        boolean bl2;
        if (this.zzcjb == null) {
            zzafy.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzcjg.countDown();
            return;
        }
        zzap zzap2 = this;
        this.zzcji = (EGL10)EGLContext.getEGL();
        zzap2.zzcjj = zzap2.zzcji.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzap2.zzcjj == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzap2.zzcji.eglInitialize(zzap2.zzcjj, nArray)) {
                bl2 = false;
            } else {
                object2 = zzap2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                int[] nArray3 = new int[1];
                object = ((zzap)object2).zzcji.eglChooseConfig(((zzap)object2).zzcjj, nArray2, eGLConfigArray, 1, nArray3) && nArray3[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray4 = new int[]{12440, 2, 12344};
                    zzap2.zzcjk = zzap2.zzcji.eglCreateContext(zzap2.zzcjj, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray4);
                    if (zzap2.zzcjk == null || zzap2.zzcjk == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzap2.zzcjl = zzap2.zzcji.eglCreateWindowSurface(zzap2.zzcjj, (EGLConfig)object, (Object)zzap2.zzcjb, null);
                        bl2 = zzap2.zzcjl == null || zzap2.zzcjl == EGL10.EGL_NO_SURFACE ? false : zzap2.zzcji.eglMakeCurrent(zzap2.zzcjj, zzap2.zzcjl, zzap2.zzcjl, zzap2.zzcjk);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzap2 = this;
        zzmd<String> zzmd3 = zzmd2 = zzmn.zzbkl;
        if (!zzbv.zzen().zzd(zzmd3).equals(zzmd2.zzil())) {
            zzmd3 = zzmd2;
            string = zzbv.zzen().zzd(zzmd3);
        } else {
            string = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzap.zzc(35633, string);
        if (n2 == 0) {
            n = 0;
        } else {
            String string2;
            zzmd3 = zzmd2 = zzmn.zzbkm;
            if (!zzbv.zzen().zzd(zzmd3).equals(zzmd2.zzil())) {
                zzmd3 = zzmd2;
                string2 = zzbv.zzen().zzd(zzmd3);
            } else {
                string2 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzap.zzc(35632, string2);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzap.zzbq("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzap.zzbq("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzap.zzbq("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzap.zzbq("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzap.zzbq("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzap.zzbq("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzap.zzbq("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzcjc = n;
        GLES20.glUseProgram((int)zzap2.zzcjc);
        zzap.zzbq("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzap2.zzcjc, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzap2.zzcjf);
        zzap.zzbq("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzap.zzbq("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzap.zzbq("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzap.zzbq("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzap.zzbq("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzap.zzbq("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzap.zzbq("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzap.zzbq("texParameteri");
        zzap2.zzcjd = GLES20.glGetUniformLocation((int)zzap2.zzcjc, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzap2.zzcjd, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzcjc != 0;
        if (!bl3 || !bl) {
            String string3 = GLUtils.getEGLErrorString((int)this.zzcji.eglGetError());
            String string4 = String.valueOf(string3);
            String string5 = string4.length() != 0 ? "EGL initialization failed: ".concat(string4) : new String("EGL initialization failed: ");
            zzafy.e((String)string5);
            zzbv.zzee().zza(new Throwable(string5), "SphericalVideoProcessor.run.1");
            this.zzno();
            this.zzcjg.countDown();
            return;
        }
        this.zzcja = new SurfaceTexture(n7);
        this.zzcja.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzcjg.countDown();
        this.zzciq.start();
        try {
            this.zzcjm = true;
            while (!this.zzcjn) {
                this.zznn();
                if (this.zzcjm) {
                    zzap2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzap2.zzakp, (int)zzap2.zzakq);
                    zzap.zzbq("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzap2.zzcjc, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzap2.zzcjc, (String)"uFOVy");
                    if (zzap2.zzakp > zzap2.zzakq) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzap2.zzakq / (float)zzap2.zzakp));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzap2.zzakp / (float)zzap2.zzakq));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzcjm = false;
                }
                try {
                    Object object3 = this.zzcjh;
                    synchronized (object3) {
                        if (!this.zzcjn && !this.zzcjm && this.zzcje == 0) {
                            this.zzcjh.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzafy.zzcr((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzafy.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbv.zzee().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzciq.stop();
            this.zzcja.setOnFrameAvailableListener(null);
            this.zzcja = null;
            this.zzno();
        }
    }

    private final void zznn() {
        while (this.zzcje > 0) {
            this.zzcja.updateTexImage();
            --this.zzcje;
        }
        if (this.zzciq.zza(this.zzcim)) {
            if (Float.isNaN(this.zzcix)) {
                float[] fArray = this.zzcim;
                float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
                float[] fArray3 = this.zzcim;
                float[] fArray4 = new float[]{fArray3[0] * fArray2[0] + fArray3[1] * fArray2[1] + fArray3[2] * fArray2[2], fArray3[3] * fArray2[0] + fArray3[4] * fArray2[1] + fArray3[5] * fArray2[2], fArray3[6] * fArray2[0] + fArray3[7] * fArray2[1] + fArray3[8] * fArray2[2]};
                this.zzcix = -((float)Math.atan2(fArray4[1], fArray4[0]) - 1.5707964f);
            }
            zzap.zzb(this.zzciv, this.zzcix + this.zzciy);
        } else {
            zzap.zza(this.zzcim, -1.5707964f);
            zzap.zzb(this.zzciv, this.zzciy);
        }
        zzap.zza(this.zzcir, 1.5707964f);
        zzap.zza(this.zzcis, this.zzciv, this.zzcir);
        zzap.zza(this.zzcit, this.zzcim, this.zzcis);
        zzap.zza(this.zzciu, this.zzciz);
        zzap.zza(this.zzciw, this.zzciu, this.zzcit);
        GLES20.glUniformMatrix3fv((int)this.zzcjd, (int)1, (boolean)false, (float[])this.zzciw, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        zzap.zzbq("drawArrays");
        GLES20.glFinish();
        this.zzcji.eglSwapBuffers(this.zzcjj, this.zzcjl);
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzakp > this.zzakq) {
            f4 = 1.7453293f * f / (float)this.zzakp;
            f3 = 1.7453293f * f2 / (float)this.zzakp;
        } else {
            f4 = 1.7453293f * f / (float)this.zzakq;
            f3 = 1.7453293f * f2 / (float)this.zzakq;
        }
        this.zzciy -= f4;
        this.zzciz -= f3;
        if (this.zzciz < -1.5707964f) {
            this.zzciz = -1.5707964f;
        }
        if (this.zzciz > 1.5707964f) {
            this.zzciz = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzc(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        zzap.zzbq("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string);
            zzap.zzbq("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzap.zzbq("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzap.zzbq("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzap.zzbq("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    private final boolean zzno() {
        boolean bl = false;
        if (this.zzcjl != null && this.zzcjl != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzcji.eglMakeCurrent(this.zzcjj, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzcji.eglDestroySurface(this.zzcjj, this.zzcjl);
            this.zzcjl = null;
        }
        if (this.zzcjk != null) {
            bl |= this.zzcji.eglDestroyContext(this.zzcjj, this.zzcjk);
            this.zzcjk = null;
        }
        if (this.zzcjj != null) {
            bl |= this.zzcji.eglTerminate(this.zzcjj);
            this.zzcjj = null;
        }
        return bl;
    }

    private static void zzbq(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string).length()).append(string).append(": glError ").append(n).toString());
        }
    }
}

