/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzap;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzar;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzzn;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzzn
@TargetApi(value=14)
public final class zzd
extends zzy
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzcff = new HashMap<Integer, String>();
    private final zzar zzcfg;
    private final boolean zzcfh;
    private int zzcfi = 0;
    private int zzcfj = 0;
    private MediaPlayer zzcfk;
    private Uri zzcfl;
    private int zzcfm;
    private int zzcfn;
    private int zzcfo;
    private int zzcfp;
    private int zzcfq;
    private zzap zzcfr;
    private boolean zzcfs;
    private int zzcft;
    private zzx zzcfu;

    public zzd(Context context, boolean bl, boolean bl2, zzaq zzaq2, zzar zzar2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzcfg = zzar2;
        this.zzcfs = bl;
        this.zzcfh = bl2;
        this.zzcfg.zza(this);
    }

    @Override
    public final String zzmj() {
        String string = String.valueOf(this.zzcfs ? " spherical" : "");
        if (string.length() != 0) {
            return "MediaPlayer".concat(string);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzx zzx2) {
        this.zzcfu = zzx2;
    }

    @Override
    public final void setVideoPath(String string) {
        Uri uri = Uri.parse((String)string);
        zzd zzd2 = this;
        zzhs zzhs2 = zzhs.zzd(uri);
        zzd2.zzcfl = zzhs2 == null ? uri : Uri.parse((String)zzhs2.url);
        zzd2.zzcft = 0;
        zzd2.zzmk();
        zzd2.requestLayout();
        zzd2.invalidate();
    }

    @Override
    public final void stop() {
        zzafy.v("AdMediaPlayerView stop");
        if (this.zzcfk != null) {
            this.zzcfk.stop();
            this.zzcfk.release();
            this.zzcfk = null;
            this.zzv(0);
            this.zzcfj = 0;
        }
        this.zzcfg.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzafy.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzcfm = mediaPlayer.getVideoWidth();
        this.zzcfn = mediaPlayer.getVideoHeight();
        if (this.zzcfm != 0 && this.zzcfn != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzafy.v("AdMediaPlayerView prepared");
        this.zzv(2);
        this.zzcfg.zzmz();
        zzahg.zzdbz.post((Runnable)new zze(this));
        this.zzcfm = mediaPlayer.getVideoWidth();
        this.zzcfn = mediaPlayer.getVideoHeight();
        if (this.zzcft != 0) {
            ((zzy)this).seekTo(this.zzcft);
        }
        this.zzml();
        int n = this.zzcfm;
        int n2 = this.zzcfn;
        zzafy.zzcq((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzcfj == 3) {
            ((zzy)this).play();
        }
        ((zzy)this).zzmn();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzafy.v("AdMediaPlayerView completion");
        this.zzv(5);
        this.zzcfj = 5;
        zzahg.zzdbz.post((Runnable)new zzf(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzcff.get(n);
        String string2 = zzcff.get(n2);
        zzafy.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzcff.get(n);
        String string2 = zzcff.get(n2);
        zzafy.zzcr((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzv(-1);
        this.zzcfj = -1;
        zzahg.zzdbz.post((Runnable)new zzg(this, string, string2));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzcfo = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzafy.v("AdMediaPlayerView surface created");
        this.zzmk();
        zzahg.zzdbz.post((Runnable)new zzh(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzafy.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzcfj == 3;
        boolean bl3 = bl = this.zzcfm == n && this.zzcfn == n2;
        if (this.zzcfk != null && bl2 && bl) {
            if (this.zzcft != 0) {
                ((zzy)this).seekTo(this.zzcft);
            }
            ((zzy)this).play();
        }
        if (this.zzcfr != null) {
            this.zzcfr.zzf(n, n2);
        }
        zzahg.zzdbz.post((Runnable)new zzi(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzafy.v("AdMediaPlayerView surface destroyed");
        if (this.zzcfk != null && this.zzcft == 0) {
            this.zzcft = this.zzcfk.getCurrentPosition();
        }
        if (this.zzcfr != null) {
            this.zzcfr.zznl();
        }
        zzahg.zzdbz.post((Runnable)new zzj(this));
        this.zzr(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzcfg.zzb(this);
        this.zzchk.zza(surfaceTexture, this.zzcfu);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzd.getDefaultSize((int)this.zzcfm, (int)n);
        int n4 = zzd.getDefaultSize((int)this.zzcfn, (int)n2);
        if (this.zzcfm > 0 && this.zzcfn > 0 && this.zzcfr == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzcfm * n4 < n3 * this.zzcfn) {
                    n3 = n4 * this.zzcfm / this.zzcfn;
                } else if (this.zzcfm * n4 > n3 * this.zzcfn) {
                    n4 = n3 * this.zzcfn / this.zzcfm;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzcfn / this.zzcfm;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzcfm / this.zzcfn;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzcfm;
                n4 = this.zzcfn;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzcfm / this.zzcfn;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzcfn / this.zzcfm;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzcfr != null) {
            this.zzcfr.zzf(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzcfp > 0 && this.zzcfp != n3 || this.zzcfq > 0 && this.zzcfq != n4) {
                this.zzml();
            }
            this.zzcfp = n3;
            this.zzcfq = n4;
        }
    }

    public final String toString() {
        String string = this.getClass().getName();
        String string2 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private final void zzmk() {
        zzafy.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzcfl == null || surfaceTexture == null) {
            return;
        }
        this.zzr(false);
        try {
            Surface surface;
            zzbv.zzes();
            this.zzcfk = new MediaPlayer();
            this.zzcfk.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzcfk.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzcfk.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzcfk.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzcfk.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzcfk.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzcfo = 0;
            if (this.zzcfs) {
                this.zzcfr = new zzap(this.getContext());
                this.zzcfr.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzcfr.start();
                surface = this.zzcfr.zznm();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzcfr.zznl();
                    this.zzcfr = null;
                }
            }
            this.zzcfk.setDataSource(this.getContext(), this.zzcfl);
            zzbv.zzet();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzcfk.setSurface(surface);
            this.zzcfk.setAudioStreamType(3);
            this.zzcfk.setScreenOnWhilePlaying(true);
            this.zzcfk.prepareAsync();
            this.zzv(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzcfl);
            zzafy.zzc((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzcfk, 1, 0);
            return;
        }
    }

    private final void zzml() {
        if (!this.zzcfh) {
            return;
        }
        if (this.zzmm() && this.zzcfk.getCurrentPosition() > 0 && this.zzcfj != 3) {
            zzafy.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzcfk.start();
            int n = this.zzcfk.getCurrentPosition();
            long l = zzbv.zzeg().currentTimeMillis();
            while (this.zzmm() && this.zzcfk.getCurrentPosition() == n && zzbv.zzeg().currentTimeMillis() - l <= 250L) {
            }
            this.zzcfk.pause();
            ((zzy)this).zzmn();
        }
    }

    private final void zzr(boolean bl) {
        zzafy.v("AdMediaPlayerView release");
        if (this.zzcfr != null) {
            this.zzcfr.zznl();
            this.zzcfr = null;
        }
        if (this.zzcfk != null) {
            this.zzcfk.reset();
            this.zzcfk.release();
            this.zzcfk = null;
            this.zzv(0);
            if (bl) {
                this.zzcfj = 0;
                this.zzcfj = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzafy.v("AdMediaPlayerView play");
        if (this.zzmm()) {
            this.zzcfk.start();
            this.zzv(3);
            this.zzchk.zzna();
            zzahg.zzdbz.post((Runnable)new zzk(this));
        }
        this.zzcfj = 3;
    }

    @Override
    public final void pause() {
        zzafy.v("AdMediaPlayerView pause");
        if (this.zzmm() && this.zzcfk.isPlaying()) {
            this.zzcfk.pause();
            this.zzv(4);
            zzahg.zzdbz.post((Runnable)new zzl(this));
        }
        this.zzcfj = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzmm()) {
            return this.zzcfk.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzmm()) {
            return this.zzcfk.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzafy.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzmm()) {
            this.zzcfk.seekTo(n);
            this.zzcft = 0;
            return;
        }
        this.zzcft = n;
    }

    private final boolean zzmm() {
        return this.zzcfk != null && this.zzcfi != -1 && this.zzcfi != 0 && this.zzcfi != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzcfr != null) {
            this.zzcfr.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzcfk != null) {
            return this.zzcfk.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzcfk != null) {
            return this.zzcfk.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzmn() {
        this.zza(this.zzchl.zzns());
    }

    private final void zza(float f) {
        if (this.zzcfk != null) {
            try {
                this.zzcfk.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzafy.zzcr((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzv(int n) {
        if (n == 3) {
            this.zzcfg.zznp();
            this.zzchl.zznp();
        } else if (this.zzcfi == 3) {
            this.zzcfg.zznq();
            this.zzchl.zznq();
        }
        this.zzcfi = n;
    }

    static /* synthetic */ zzx zza(zzd zzd2) {
        return zzd2.zzcfu;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzcff.put(-1004, "MEDIA_ERROR_IO");
            zzcff.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzcff.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzcff.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzcff.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzcff.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzcff.put(1, "MEDIA_ERROR_UNKNOWN");
        zzcff.put(1, "MEDIA_INFO_UNKNOWN");
        zzcff.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzcff.put(701, "MEDIA_INFO_BUFFERING_START");
        zzcff.put(702, "MEDIA_INFO_BUFFERING_END");
        zzcff.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzcff.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzcff.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzcff.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzcff.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

