/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zza;
import com.google.android.gms.ads.internal.overlay.zzae;
import com.google.android.gms.ads.internal.overlay.zzaf;
import com.google.android.gms.ads.internal.overlay.zzaj;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.overlay.zzr;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzahl;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzakm;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzwx;
import com.google.android.gms.internal.zzxb;
import com.google.android.gms.internal.zzzn;
import java.util.Collections;

@zzzn
public final class zzm
extends zzxb
implements zzaj {
    private static int zzcga = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzcgb;
    private zzakl zzbvz;
    private zzr zzcgc;
    private zzae zzcgd;
    private boolean zzcge = false;
    private FrameLayout zzcgf;
    private WebChromeClient.CustomViewCallback zzcgg;
    private boolean zzcgh = false;
    private boolean zzcgi = false;
    private zzq zzcgj;
    private boolean zzcgk = false;
    private int zzcgl = 0;
    private final Object zzcgm = new Object();
    private Runnable zzcgn;
    private boolean zzcgo;
    private boolean zzcgp;
    private boolean zzcgq = false;
    private boolean zzcgr = false;
    private boolean zzcgs = true;

    public zzm(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzcgl = 2;
        this.mActivity.finish();
    }

    public final void zzmo() {
        if (this.zzcgb != null && this.zzcge) {
            this.setRequestedOrientation(this.zzcgb.orientation);
        }
        if (this.zzcgf != null) {
            this.mActivity.setContentView((View)this.zzcgj);
            this.zzcgp = true;
            this.zzcgf.removeAllViews();
            this.zzcgf = null;
        }
        if (this.zzcgg != null) {
            this.zzcgg.onCustomViewHidden();
            this.zzcgg = null;
        }
        this.zzcge = false;
    }

    @Override
    public final void zzmp() {
        this.zzcgl = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzcgl = 0;
    }

    public final boolean zzmq() {
        this.zzcgl = 0;
        if (this.zzbvz == null) {
            return true;
        }
        boolean bl = this.zzbvz.zzsk();
        if (!bl) {
            this.zzbvz.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public final void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzcgh = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzcgb = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzcgb == null) {
                throw new zzp("Could not get info for ad overlay.");
            }
            if (this.zzcgb.zzasz.zzdex > 7500000) {
                this.zzcgl = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzcgs = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzcgi = this.zzcgb.zzchj != null ? this.zzcgb.zzchj.zzapn : false;
            zzmd<Boolean> zzmd2 = zzmn.zzbmd;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && this.zzcgi && this.zzcgb.zzchj.zzaps != -1) {
                new zzs(this, null).zzqt();
            }
            if (bundle == null) {
                if (this.zzcgb.zzcha != null && this.zzcgs) {
                    this.zzcgb.zzcha.zzbz();
                }
                if (this.zzcgb.zzchh != 1 && this.zzcgb.zzcgz != null) {
                    this.zzcgb.zzcgz.onAdClicked();
                }
            }
            this.zzcgj = new zzq((Context)this.mActivity, this.zzcgb.zzchi, this.zzcgb.zzasz.zzcp);
            this.zzcgj.setId(1000);
            switch (this.zzcgb.zzchh) {
                case 1: {
                    this.zzt(false);
                    return;
                }
                case 2: {
                    this.zzcgc = new zzr(this.zzcgb.zzchb);
                    this.zzt(false);
                    return;
                }
                case 3: {
                    this.zzt(true);
                    return;
                }
                case 4: {
                    if (this.zzcgh) {
                        this.zzcgl = 3;
                        this.mActivity.finish();
                        return;
                    }
                    zzbv.zzdx();
                    if (zza.zza((Context)this.mActivity, this.zzcgb.zzcgy, this.zzcgb.zzchg)) break;
                    this.zzcgl = 3;
                    this.mActivity.finish();
                    return;
                }
                default: {
                    throw new zzp("Could not determine ad overlay type.");
                }
            }
            return;
        }
        catch (zzp zzp2) {
            zzafy.zzcr((String)zzp2.getMessage());
            this.zzcgl = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzmd<Boolean> zzmd2 = zzmn.zzboz;
        if (zzbv.zzen().zzd(zzmd2).booleanValue()) {
            if (this.zzbvz != null && !this.zzbvz.isDestroyed()) {
                zzbv.zzec();
                zzahl.zzk(this.zzbvz);
                return;
            }
            zzafy.zzcr((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzcgb != null && this.zzcgb.zzchh == 4) {
            if (this.zzcgh) {
                this.zzcgl = 3;
                this.mActivity.finish();
            } else {
                this.zzcgh = true;
            }
        }
        if (this.zzcgb.zzcha != null) {
            this.zzcgb.zzcha.onResume();
        }
        zzmd<Boolean> zzmd2 = zzmn.zzboz;
        if (!zzbv.zzen().zzd(zzmd2).booleanValue()) {
            if (this.zzbvz != null && !this.zzbvz.isDestroyed()) {
                zzbv.zzec();
                zzahl.zzk(this.zzbvz);
                return;
            }
            zzafy.zzcr((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzmo();
        if (this.zzcgb.zzcha != null) {
            this.zzcgb.zzcha.onPause();
        }
        zzmd<Boolean> zzmd2 = zzmn.zzboz;
        if (!(zzbv.zzen().zzd(zzmd2).booleanValue() || this.zzbvz == null || this.mActivity.isFinishing() && this.zzcgc != null)) {
            zzbv.zzec();
            zzahl.zzj(this.zzbvz);
        }
        this.zzms();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzk(IObjectWrapper iObjectWrapper) {
        zzmd<Boolean> zzmd2 = zzmn.zzboy;
        if (zzbv.zzen().zzd(zzmd2).booleanValue() && com.google.android.gms.common.util.zzp.isAtLeastN()) {
            Configuration configuration = (Configuration)com.google.android.gms.dynamic.zzn.zzx((IObjectWrapper)iObjectWrapper);
            zzbv.zzea();
            if (zzahg.zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
                return;
            }
            this.mActivity.getWindow().addFlags(2048);
            this.mActivity.getWindow().clearFlags(1024);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzcgh);
    }

    public final void onStop() {
        zzmd<Boolean> zzmd2 = zzmn.zzboz;
        if (zzbv.zzen().zzd(zzmd2).booleanValue() && this.zzbvz != null && (!this.mActivity.isFinishing() || this.zzcgc == null)) {
            zzbv.zzec();
            zzahl.zzj(this.zzbvz);
        }
        this.zzms();
    }

    public final void onDestroy() {
        if (this.zzbvz != null) {
            zzakl zzakl2 = this.zzbvz;
            if (zzakl2 == null) {
                throw null;
            }
            this.zzcgj.removeView((View)zzakl2);
        }
        this.zzms();
    }

    private final void zzs(boolean bl) {
        zzmd<Integer> zzmd2 = zzmn.zzbpa;
        int n = zzbv.zzen().zzd(zzmd2);
        zzaf zzaf2 = new zzaf();
        new zzaf().size = 50;
        zzaf2.paddingLeft = bl ? n : 0;
        zzaf2.paddingRight = bl ? 0 : n;
        zzaf2.paddingTop = 0;
        zzaf2.paddingBottom = n;
        this.zzcgd = new zzae((Context)this.mActivity, zzaf2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zza(bl, this.zzcgb.zzche);
        this.zzcgj.addView((View)this.zzcgd, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzay() {
        this.zzcgp = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        boolean bl3;
        zzmd<Boolean> zzmd2 = zzmn.zzbjr;
        boolean bl4 = bl3 = zzbv.zzen().zzd(zzmd2) != false && this.zzcgb != null && this.zzcgb.zzchj != null && this.zzcgb.zzchj.zzapu;
        if (bl && bl2 && bl3) {
            new zzwx(this.zzbvz, "useCustomClose").zzbm("Custom close has been disabled for interstitial ads in this ad slot.");
        }
        if (this.zzcgd != null) {
            this.zzcgd.zza(bl, bl2 && !bl3);
        }
    }

    public final void zzmr() {
        this.zzcgj.removeView((View)this.zzcgd);
        this.zzs(true);
    }

    public final void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzcgf = new FrameLayout((Context)this.mActivity);
        this.zzcgf.setBackgroundColor(-16777216);
        this.zzcgf.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzcgf);
        this.zzcgp = true;
        this.zzcgg = customViewCallback;
        this.zzcge = true;
    }

    private final void zzt(boolean bl) throws zzp {
        zzakm zzakm2;
        boolean bl2;
        zzmd<Boolean> zzmd2;
        Window window;
        if (!this.zzcgp) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzp("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (com.google.android.gms.common.util.zzp.isAtLeastN()) {
            zzmd2 = zzmn.zzboy;
            if (zzbv.zzen().zzd(zzmd2).booleanValue()) {
                zzbv.zzea();
                bl3 = zzahg.zza(this.mActivity, this.mActivity.getResources().getConfiguration());
            }
        }
        boolean bl4 = bl2 = this.zzcgb.zzchj != null && this.zzcgb.zzchj.zzapo;
        if ((!this.zzcgi || bl2) && bl3) {
            window.setFlags(1024, 1024);
            zzmd2 = zzmn.zzbjq;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && com.google.android.gms.common.util.zzp.zzali() && this.zzcgb.zzchj != null && this.zzcgb.zzchj.zzapt) {
                window.getDecorView().setSystemUiVisibility(4098);
            }
        }
        boolean bl5 = (zzakm2 = this.zzcgb.zzchb.zzse()) != null ? zzakm2.zzfo() : false;
        this.zzcgk = false;
        if (bl5) {
            if (this.zzcgb.orientation == zzbv.zzec().zzrb()) {
                this.zzcgk = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzcgb.orientation == zzbv.zzec().zzrc()) {
                this.zzcgk = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzcgk;
        zzafy.zzca((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzcgb.orientation);
        if (zzbv.zzec().zza(window)) {
            zzafy.zzca((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzcgi) {
            this.zzcgj.setBackgroundColor(-16777216);
        } else {
            this.zzcgj.setBackgroundColor(zzcga);
        }
        this.mActivity.setContentView((View)this.zzcgj);
        this.zzcgp = true;
        if (bl) {
            try {
                this.zzbvz = zzbv.zzeb().zza((Context)this.mActivity, this.zzcgb.zzchb.zzbk(), true, bl5, null, this.zzcgb.zzasz, null, null, this.zzcgb.zzchb.zzbi(), zzhz.zzhf());
            }
            catch (Exception exception) {
                throw new zzp("Could not obtain webview for the overlay.");
            }
            this.zzbvz.zzse().zza(null, null, this.zzcgb.zzchc, this.zzcgb.zzchg, true, null, this.zzcgb.zzchb.zzse().zzsw(), null, null);
            this.zzbvz.zzse().zza(new zzn(this));
            if (this.zzcgb.url != null) {
                this.zzbvz.loadUrl(this.zzcgb.url);
            } else if (this.zzcgb.zzchf != null) {
                this.zzbvz.loadDataWithBaseURL(this.zzcgb.zzchd, this.zzcgb.zzchf, "text/html", "UTF-8", null);
            } else {
                throw new zzp("No URL or HTML to display in ad overlay.");
            }
            if (this.zzcgb.zzchb != null) {
                this.zzcgb.zzchb.zzc(this);
            }
        } else {
            this.zzbvz = this.zzcgb.zzchb;
            this.zzbvz.setContext((Context)this.mActivity);
        }
        this.zzbvz.zzb(this);
        ViewParent viewParent = this.zzbvz.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            zzakl zzakl2 = this.zzbvz;
            if (zzakl2 == null) {
                throw null;
            }
            ((ViewGroup)viewParent).removeView((View)zzakl2);
        }
        if (this.zzcgi) {
            this.zzbvz.zzsv();
        }
        zzakl zzakl3 = this.zzbvz;
        if (zzakl3 == null) {
            throw null;
        }
        this.zzcgj.addView((View)zzakl3, -1, -1);
        if (!bl && !this.zzcgk) {
            this.zzmv();
        }
        this.zzs(bl5);
        if (this.zzbvz.zzsf()) {
            this.zza(bl5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzms() {
        if (!this.mActivity.isFinishing() || this.zzcgq) {
            return;
        }
        this.zzcgq = true;
        if (this.zzbvz != null) {
            int n = this.zzcgl;
            this.zzbvz.zzae(n);
            Object object = this.zzcgm;
            synchronized (object) {
                if (!this.zzcgo && this.zzbvz.zzsq()) {
                    this.zzcgn = new zzo(this);
                    zzmd<Long> zzmd2 = zzmn.zzbjp;
                    zzahg.zzdbz.postDelayed(this.zzcgn, zzbv.zzen().zzd(zzmd2).longValue());
                    return;
                }
            }
        }
        this.zzmt();
    }

    final void zzmt() {
        if (this.zzcgr) {
            return;
        }
        this.zzcgr = true;
        if (this.zzbvz != null) {
            zzakl zzakl2 = this.zzbvz;
            if (zzakl2 == null) {
                throw null;
            }
            this.zzcgj.removeView((View)zzakl2);
            if (this.zzcgc != null) {
                this.zzbvz.setContext(this.zzcgc.zzahy);
                this.zzbvz.zzab(false);
                zzakl zzakl3 = this.zzbvz;
                if (zzakl3 == null) {
                    throw null;
                }
                this.zzcgc.parent.addView((View)zzakl3, this.zzcgc.index, this.zzcgc.zzcgv);
                this.zzcgc = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzbvz.setContext(this.mActivity.getApplicationContext());
            }
            this.zzbvz = null;
        }
        if (this.zzcgb != null && this.zzcgb.zzcha != null) {
            this.zzcgb.zzcha.zzby();
        }
    }

    public final void zzmu() {
        if (this.zzcgk) {
            this.zzcgk = false;
            this.zzmv();
        }
    }

    private final void zzmv() {
        this.zzbvz.zzmv();
    }

    public final void zzmw() {
        this.zzcgj.zzcgu = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzmx() {
        Object object = this.zzcgm;
        synchronized (object) {
            this.zzcgo = true;
            if (this.zzcgn != null) {
                zzahg.zzdbz.removeCallbacks(this.zzcgn);
                zzahg.zzdbz.post(this.zzcgn);
            }
            return;
        }
    }

    static /* synthetic */ Activity zza(zzm zzm2) {
        return zzm2.mActivity;
    }
}

