/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.internal.zzabc;
import com.google.android.gms.internal.zzabd;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.internal.zzbco;
import com.google.android.gms.internal.zzzn;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzzn
public final class zzabb
extends zzbck {
    public static final Parcelable.Creator<zzabb> CREATOR = new zzabd();
    private ParcelFileDescriptor zzcqy;
    private Parcelable zzcqz;
    private boolean zzcra;

    zzabb(ParcelFileDescriptor parcelFileDescriptor) {
        this.zzcqy = parcelFileDescriptor;
        this.zzcqz = null;
        this.zzcra = true;
    }

    public zzabb(zzbco zzbco2) {
        this.zzcqy = null;
        this.zzcqz = zzbco2;
        this.zzcra = false;
    }

    public final <T extends zzbco> T zza(Parcelable.Creator<T> creator) {
        if (this.zzcra) {
            byte[] byArray;
            if (this.zzcqy == null) {
                zzafy.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcqy));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzafy.zzb((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                zzm.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzcqz = (zzbco)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzcra = false;
        }
        return (T)((zzbco)this.zzcqz);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        if (this.zzcqy == null) {
            byte[] byArray;
            Parcel parcel2 = Parcel.obtain();
            try {
                this.zzcqz.writeToParcel(parcel2, 0);
                byArray = parcel2.marshall();
            }
            finally {
                parcel2.recycle();
            }
            this.zzcqy = this.zze(byArray);
        }
        Parcel parcel3 = parcel;
        zzabb zzabb2 = this;
        int n2 = zzbcn.zze((Parcel)parcel3);
        zzbcn.zza((Parcel)parcel3, (int)2, (Parcelable)zzabb2.zzcqy, (int)n, (boolean)false);
        zzbcn.zzai((Parcel)parcel3, (int)n2);
    }

    private final <T> ParcelFileDescriptor zze(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzabc zzabc2 = new zzabc(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzabc2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzafy.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzbv.zzee().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzm.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

