/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzajs;
import com.google.android.gms.internal.zzajt;
import com.google.android.gms.internal.zzzn;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzzn
public class zzajy<T>
implements zzajs<T> {
    private final Object mLock = new Object();
    private T mValue;
    private Throwable zzdfo;
    private boolean zzdfp;
    private boolean zzcck;
    private final zzajt zzdfq = new zzajt();

    @Override
    public final void zza(Runnable runnable, Executor executor) {
        this.zzdfq.zza(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcck) {
                return;
            }
            if (this.zzrv()) {
                zzbv.zzee().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.set");
                return;
            }
            this.zzdfp = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzdfq.zzru();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcck) {
                return;
            }
            if (this.zzrv()) {
                zzbv.zzee().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.setException");
                return;
            }
            this.zzdfo = throwable;
            this.mLock.notifyAll();
            this.zzdfq.zzru();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzrv()) {
                this.mLock.wait();
            }
            if (this.zzdfo != null) {
                throw new ExecutionException(this.zzdfo);
            }
            if (this.zzcck) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzrv()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzdfo != null) {
                throw new ExecutionException(this.zzdfo);
            }
            if (!this.zzdfp) {
                throw new TimeoutException("SettableFuture timed out.");
            }
            if (this.zzcck) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzrv()) {
                return false;
            }
            this.zzcck = true;
            this.zzdfp = true;
            this.mLock.notifyAll();
            this.zzdfq.zzru();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcck;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzrv();
        }
    }

    private final boolean zzrv() {
        return this.zzdfo != null || this.zzdfp;
    }
}

