/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbt;
import com.google.android.gms.internal.zzbvz;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzcw;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzde;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzehg;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzcz {
    private static final String TAG = zzcz.class.getSimpleName();
    protected Context zzahy;
    private Context zzahz;
    private ExecutorService zzaia;
    private DexClassLoader zzaib;
    private zzcu zzaic;
    private byte[] zzaid;
    private volatile AdvertisingIdClient zzaie = null;
    private volatile boolean zzahf = false;
    private Future zzaif = null;
    private volatile zzaw zzaig = null;
    private Future zzaih = null;
    private zzcm zzaii;
    private boolean zzaij = false;
    private static Object zzaik = new Object();
    private boolean zzail = false;
    private static zze zzaim = null;
    private Map<Pair<String, String>, zzdy> zzain;
    private boolean zzaio = false;

    public static zzcz zza(Context context, String string2, String string3, boolean bl) {
        zzcz zzcz2 = new zzcz(context);
        try {
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzcz zzcz3 = zzcz2;
            zzcz2.zzaia = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            Object object = zzcz3;
            zzcz3.zzahf = bl3;
            if (bl3) {
                ((zzcz)object).zzaif = ((zzcz)object).zzaia.submit(new zzda((zzcz)object));
            }
            zzcz zzcz4 = zzcz3;
            zzcz4.zzaia.execute(new zzdc(zzcz4));
            try {
                zzaim = zze.zzaex();
                zzcz4.zzaij = zze.zzbw((Context)zzcz4.zzahy) > 0;
                zzcz4.zzail = zzaim.isGooglePlayServicesAvailable(zzcz4.zzahy) == 0;
            }
            catch (Throwable throwable) {}
            zzcz3.zza(0, true);
            if (zzde.zzaq()) {
                object = zzmn.zzblw;
                if (((Boolean)zzbv.zzen().zzd(object)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            String string6 = string5;
            zzcz4 = zzcz3;
            zzcz3.zzaic = new zzcu(null);
            try {
                zzcz4.zzaid = zzcz4.zzaic.zzk(string6);
            }
            catch (zzcv zzcv2) {
                throw new zzcw(zzcv2);
            }
            string6 = string4;
            zzcz4 = zzcz3;
            try {
                String string7;
                File file = zzcz4.zzahy.getCacheDir();
                if (file == null && (file = zzcz4.zzahy.getDir("dex", 0)) == null) {
                    throw new zzcw();
                }
                String string8 = string7 = "1496809943795";
                File file2 = file;
                String string9 = string6;
                zzcz zzcz5 = zzcz4;
                File file3 = new File(String.format("%s/%s.jar", file2, string8));
                if (!file3.exists()) {
                    byte[] byArray = zzcz5.zzaic.zzb(zzcz5.zzaid, string9);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzcz4.zzb(file, string7);
                try {
                    zzcz4.zzaib = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzcz4.zzahy.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzcz.zza(file4);
                    zzcz4.zza(file, string7);
                    zzcz.zzl(String.format("%s/%s.dex", file, string7));
                    throw throwable;
                }
                zzcz.zza(file4);
                zzcz4.zza(file, string7);
                zzcz.zzl(String.format("%s/%s.dex", file, string7));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzcw(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzcw(iOException);
            }
            catch (zzcv zzcv3) {
                throw new zzcw(zzcv3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzcw(nullPointerException);
            }
            zzcz3.zzaii = new zzcm(zzcz3);
            zzcz3.zzaio = true;
        }
        catch (zzcw zzcw2) {}
        return zzcz2;
    }

    public final Context getContext() {
        return this.zzahy;
    }

    public final boolean isInitialized() {
        return this.zzaio;
    }

    public final Context getApplicationContext() {
        return this.zzahz;
    }

    public final ExecutorService zzad() {
        return this.zzaia;
    }

    public final DexClassLoader zzae() {
        return this.zzaib;
    }

    public final zzcu zzaf() {
        return this.zzaic;
    }

    public final byte[] zzag() {
        return this.zzaid;
    }

    public final boolean zzah() {
        return this.zzaij;
    }

    public final zzcm zzai() {
        return this.zzaii;
    }

    public final boolean zzaj() {
        return this.zzail;
    }

    public final zzaw zzak() {
        return this.zzaig;
    }

    public final Future zzal() {
        return this.zzaih;
    }

    private zzcz(Context context) {
        this.zzahy = context;
        this.zzahz = context.getApplicationContext();
        this.zzain = new HashMap<Pair<String, String>, zzdy>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzcz.zza(file2);
            return;
        }
        zzba zzba2 = new zzba();
        new zzba().zzgb = Build.VERSION.SDK.getBytes();
        zzba2.zzga = string2.getBytes();
        byte[] byArray2 = this.zzaic.zzc(this.zzaid, byArray).getBytes();
        zzba2.data = byArray2;
        zzba2.zzfz = zzbt.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = zzehg.zzc((zzehg)zzba2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzcz.zza(file2);
        return;
        catch (zzcv | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzcz.zza(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzcz.zza(file2);
            throw throwable;
        }
    }

    private static void zzl(String string2) {
        zzcz.zza(new File(string2));
    }

    private static void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzba zzba2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzcz.zza(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzcz.zza(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzba2 = (zzba)zzehg.zza((zzehg)new zzba(), (byte[])byArray2);
                if (string2.equals(new String(zzba2.zzga)) && Arrays.equals(zzba2.zzfz, zzbt.zzb(zzba2.data)) && Arrays.equals(zzba2.zzgb, Build.VERSION.SDK.getBytes())) break block30;
                zzcz.zza(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzaic.zzb(this.zzaid, new String(zzba2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcv | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzain.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzain.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzdy(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zza(String string2, String string3) {
        zzdy zzdy2 = this.zzain.get(new Pair((Object)string2, (Object)string3));
        if (zzdy2 == null) {
            return null;
        }
        return zzdy2.zzaw();
    }

    private final void zzam() {
        try {
            if (this.zzaie == null && this.zzahz != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzahz);
                advertisingIdClient.start();
                this.zzaie = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzaie = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzail) {
            return;
        }
        Future<?> future = this.zzaia.submit(new zzdb(this, n, bl));
        if (n == 0) {
            this.zzaih = future;
        }
    }

    @VisibleForTesting
    final zzaw zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzan();
    }

    private static boolean zza(int n, zzaw zzaw2) {
        if (n < 4) {
            if (zzaw2 == null) {
                return true;
            }
            zzmd<Boolean> zzmd2 = zzmn.zzblz;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && (zzaw2.zzcq == null || zzaw2.zzcq.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzmd2 = zzmn.zzbma;
            if (zzbv.zzen().zzd(zzmd2).booleanValue() && (zzaw2.zzew == null || zzaw2.zzew.zzfu == null || zzaw2.zzew.zzfu == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzaw zzan() {
        zzaw zzaw2 = null;
        try {
            PackageInfo packageInfo = this.zzahy.getPackageManager().getPackageInfo(this.zzahy.getPackageName(), 0);
            zzaw2 = zzbvz.zzn((Context)this.zzahy, (String)this.zzahy.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzaw2;
    }

    public final AdvertisingIdClient zzao() {
        if (!this.zzahf) {
            return null;
        }
        if (this.zzaie != null) {
            return this.zzaie;
        }
        if (this.zzaif != null) {
            try {
                this.zzaif.get(2000L, TimeUnit.MILLISECONDS);
                this.zzaif = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzaif.cancel(true);
            }
        }
        return this.zzaie;
    }

    public final int zzz() {
        int n = Integer.MIN_VALUE;
        if (this.zzaii != null) {
            n = zzcm.zzz();
        }
        return n;
    }

    static /* synthetic */ void zza(zzcz zzcz2) {
        zzcz2.zzam();
    }

    static /* synthetic */ zzaw zza(zzcz zzcz2, zzaw zzaw2) {
        zzcz2.zzaig = zzaw2;
        return zzcz2.zzaig;
    }

    static /* synthetic */ boolean zzb(int n, zzaw zzaw2) {
        return zzcz.zza(n, zzaw2);
    }
}

