/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdgb;
import com.google.android.gms.internal.zzdgh;
import com.google.android.gms.internal.zzdgk;
import com.google.android.gms.internal.zzdgo;
import com.google.android.gms.internal.zzdgt;
import com.google.android.gms.internal.zzdin;
import com.google.android.gms.internal.zzdio;
import com.google.android.gms.internal.zzdip;
import com.google.android.gms.internal.zzeec;
import com.google.android.gms.internal.zzefj;
import com.google.android.gms.internal.zzefq;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

public final class zzdhq
implements zzdgk<zzdgo> {
    zzdhq() {
    }

    private final zzdgo zzaa(zzeec zzeec2) throws GeneralSecurityException {
        try {
            zzdin zzdin2;
            zzdgh.zza zza2;
            zzdgh.zza zza3;
            zzdgh.zza zza4 = zza3 = zzdgh.zza.zzn(zzeec2);
            zzdgh.zza zza5 = zza3;
            if (!(zza3 instanceof zzdgh.zza)) {
                throw new GeneralSecurityException("expected HmacKey proto");
            }
            zzdgh.zza zza6 = zza2 = zza5;
            zzdip.zzq(zza2.getVersion(), 0);
            if (zza6.zzbjw().size() < 16) {
                throw new GeneralSecurityException("key too short");
            }
            zzdhq.zzc(zza6.zzbli());
            zzdgb zzdgb2 = zza2.zzbli().zzblo();
            byte[] byArray = zza2.zzbjw().toByteArray();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
            int n = zza2.zzbli().zzblp();
            switch (zzdgb2) {
                case zzlal: {
                    zzdin2 = new zzdin("HMACSHA1", secretKeySpec, n);
                    break;
                }
                case zzlan: {
                    zzdin2 = new zzdin("HMACSHA256", secretKeySpec, n);
                    break;
                }
                case zzlao: {
                    zzdin2 = new zzdin("HMACSHA512", secretKeySpec, n);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("unknown hash");
                }
            }
            return zzdin2;
        }
        catch (zzefj zzefj2) {
            throw new GeneralSecurityException("expected serialized HmacKey proto", zzefj2);
        }
    }

    @Override
    public final zzefq zzr(zzeec zzeec2) throws GeneralSecurityException {
        try {
            zzdgh.zzb zzb2 = zzdgh.zzb.zzp(zzeec2);
            return this.zzb((zzefq)zzb2);
        }
        catch (zzefj zzefj2) {
            throw new GeneralSecurityException("expected serialized HmacKeyFormat proto", zzefj2);
        }
    }

    @Override
    public final zzefq zzb(zzefq zzefq2) throws GeneralSecurityException {
        zzdgh.zzb zzb2;
        if (!(zzefq2 instanceof zzdgh.zzb)) {
            throw new GeneralSecurityException("expected HmacKeyFormat proto");
        }
        zzdgh.zzb zzb3 = zzb2 = (zzdgh.zzb)zzefq2;
        if (zzb2.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdhq.zzc(zzb3.zzbli());
        return zzdgh.zza.zzblj().zzfg(0).zzb(zzb2.zzbli()).zzo(zzeec.zzar((byte[])zzdio.zzfp(zzb2.getKeySize()))).zzcda();
    }

    @Override
    public final zzdgt.zzb zzs(zzeec zzeec2) throws GeneralSecurityException {
        zzdgh.zza zza2 = (zzdgh.zza)this.zzr(zzeec2);
        return (zzdgt.zzb)zzdgt.zzb.zzbmi().zzof("type.googleapis.com/google.crypto.tink.HmacKey").zzw(zza2.zzcbp()).zzb(zzdgt.zzb.zzb.zzlcl).zzcda();
    }

    @Override
    public final String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.HmacKey";
    }

    private static void zzc(zzdgh.zzc zzc2) throws GeneralSecurityException {
        if (zzc2.zzblp() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzc2.zzblo()) {
            case zzlal: {
                if (zzc2.zzblp() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlan: {
                if (zzc2.zzblp() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzlao: {
                if (zzc2.zzblp() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ Object zza(zzefq zzefq2) throws GeneralSecurityException {
        zzdgh.zza zza2;
        zzefq zzefq3 = zzefq2;
        if (!(zzefq3 instanceof zzdgh.zza)) {
            throw new GeneralSecurityException("expected HmacKey proto");
        }
        zzdgh.zza zza3 = zza2 = (zzdgh.zza)zzefq3;
        zzdip.zzq(zza2.getVersion(), 0);
        if (zza3.zzbjw().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdhq.zzc(zza3.zzbli());
        zzdgb zzdgb2 = zza2.zzbli().zzblo();
        byte[] byArray = zza2.zzbjw().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zza2.zzbli().zzblp();
        switch (zzdgb2) {
            case zzlal: {
                return new zzdin("HMACSHA1", secretKeySpec, n);
            }
            case zzlan: {
                return new zzdin("HMACSHA256", secretKeySpec, n);
            }
            case zzlao: {
                return new zzdin("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public final /* synthetic */ Object zzq(zzeec zzeec2) throws GeneralSecurityException {
        return this.zzaa(zzeec2);
    }
}

