/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzfb;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfv;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzzn;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
public final class zzfa
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object mLock = new Object();
    private final WeakReference<zzafj> zzaut;
    private WeakReference<ViewTreeObserver> zzauu;
    private final zzgk zzauv;
    protected final zzey zzauw;
    private final Context mApplicationContext;
    private final WindowManager zzaux;
    private final PowerManager zzauy;
    private final KeyguardManager zzauz;
    private final DisplayMetrics zzava;
    @Nullable
    private zzfh zzavb;
    private boolean zzavc;
    private boolean zzara = false;
    private boolean zzavd = false;
    private boolean zzave;
    private boolean zzavf;
    private boolean zzavg;
    @Nullable
    private BroadcastReceiver zzavh;
    private final HashSet<Object> zzavi = new HashSet();
    private zzaiy zzaud;
    private final HashSet<zzfv> zzavj = new HashSet();
    private final Rect zzavk = new Rect();
    private final zzfd zzavl;
    private float zzavm;

    public zzfa(Context context, zziu zziu2, zzafj zzafj2, zzajl zzajl2, zzgk zzgk2) {
        this.zzaut = new WeakReference<zzafj>(zzafj2);
        this.zzauv = zzgk2;
        this.zzauu = new WeakReference<Object>(null);
        this.zzave = true;
        this.zzavg = false;
        this.zzaud = new zzaiy(200L);
        this.zzauw = new zzey(UUID.randomUUID().toString(), zzajl2, zziu2.zzbcv, zzafj2.zzcyn, zzafj2.zzfo(), zziu2.zzbcy);
        this.zzaux = (WindowManager)context.getSystemService("window");
        this.zzauy = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzauz = (KeyguardManager)context.getSystemService("keyguard");
        this.mApplicationContext = context;
        this.zzavl = new zzfd(this, new Handler());
        this.mApplicationContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzavl);
        this.zzava = context.getResources().getDisplayMetrics();
        Display display = this.zzaux.getDefaultDisplay();
        this.zzavk.right = display.getWidth();
        this.zzavk.bottom = display.getHeight();
        this.zzfq();
    }

    public final void zzfq() {
        zzbv.zzea();
        this.zzavm = zzahg.zzao(this.mApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzfr() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzave) {
                this.zzavf = true;
                try {
                    JSONObject jSONObject = this.zzfv();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzafy.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzafy.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzauw.zzfn());
                zzafy.zzca((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzj(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzfv> iterator = this.zzavj.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzfz()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzave) {
                return;
            }
            View view = this.zzauv.zzfw();
            boolean bl3 = view != null && zzbv.zzea().zza(view, this.zzauy, this.zzauz);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzauv.zzfx()) {
                this.zzfr();
                return;
            }
            if (n == 1 && !this.zzaud.tryAcquire() && bl == this.zzavg) {
                return;
            }
            if (!bl && !this.zzavg && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzavg = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzafy.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzfa zzfa2 = this;
            View view2 = zzfa2.zzauv.zzfy().zzfw();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzfa2.zzauu.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzfa2.zzfu();
                    if (!zzfa2.zzavc || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzfa2.zzavc = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzfa2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzfa2);
                    }
                    zzfa2.zzauu = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzfs();
            return;
        }
    }

    private final void zzfs() {
        if (this.zzavb != null) {
            this.zzavb.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzft() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzave;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zzc(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzauw.zzfn());
    }

    final void zzb(zzakl zzakl2, Map<String, String> map) {
        if (zzakl2 == null) {
            throw null;
        }
        this.zzj(3);
    }

    final void zza(zzfv zzfv2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzauw.zzfn());
        zzafy.zzca((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzfv2);
    }

    final void zzd(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        if (!"1".equals(map.get("isVisible"))) {
            "true".equals(map.get("isVisible"));
        }
        Iterator<Object> iterator = this.zzavi.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private final void zzfu() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzauu.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzfv() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = jSONObject.put("afmaVersion", (Object)this.zzauw.zzfl()).put("activeViewJSON", (Object)this.zzauw.zzfm()).put("timestamp", zzbv.zzeg().elapsedRealtime()).put("adFormat", (Object)this.zzauw.zzfk()).put("hashCode", (Object)this.zzauw.zzfn()).put("isMraid", this.zzauw.zzfo()).put("isStopped", this.zzavd).put("isPaused", this.zzara).put("isNative", this.zzauw.zzfp()).put("isScreenOn", this.isScreenOn());
        zzbv.zzea();
        JSONObject jSONObject3 = jSONObject2.put("appMuted", zzahg.zzdg());
        zzbv.zzea();
        jSONObject3.put("appVolume", (double)zzahg.zzde()).put("deviceVolume", (double)this.zzavm);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzfa.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzfa zzfa2 = this;
            ArrayList<zzfv> arrayList = new ArrayList<zzfv>(zzfa2.zzavj);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzfv zzfv2 = arrayList.get(i);
                zzfv2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzafy.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfv zzfv2) {
        if (this.zzavj.isEmpty()) {
            zzfa zzfa2 = this;
            Object object = zzfa2.mLock;
            synchronized (object) {
                if (zzfa2.zzavh != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzfa2.zzavh = new zzfb(zzfa2);
                    zzfa2.mApplicationContext.registerReceiver(zzfa2.zzavh, intentFilter);
                }
            }
            this.zzj(3);
        }
        this.zzavj.add(zzfv2);
        try {
            JSONObject jSONObject = zzfa.zza(this.zza(this.zzauv.zzfw(), null));
            zzfv2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzafy.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzfv zzfv2) {
        this.zzavj.remove(zzfv2);
        zzfv2.zzga();
        if (this.zzavj.isEmpty()) {
            zzfa zzfa2 = this;
            Object object = zzfa2.mLock;
            synchronized (object) {
                zzfa2.zzfu();
                zzfa zzfa3 = zzfa2;
                Object object2 = zzfa3.mLock;
                synchronized (object2) {
                    if (zzfa3.zzavh != null) {
                        try {
                            zzfa3.mApplicationContext.unregisterReceiver(zzfa3.zzavh);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzafy.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbv.zzee().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzfa3.zzavh = null;
                    }
                }
                zzfa2.mApplicationContext.getContentResolver().unregisterContentObserver((ContentObserver)zzfa2.zzavl);
                zzfa2.zzave = false;
                zzfa2.zzfs();
                zzfa3 = zzfa2;
                ArrayList<zzfv> arrayList = new ArrayList<zzfv>(zzfa3.zzavj);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzfv zzfv3 = arrayList.get(i);
                    zzfv zzfv4 = zzfv3;
                    zzfa3.zzb(zzfv4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzfa zzfa2 = this;
            return zzfa2.zzfv().put("isAttachedToWindow", false).put("isScreenOn", zzfa2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbv.zzec().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzafy.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzfv();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzfa.zza(this.zzavk.top, this.zzava)).put("bottom", zzfa.zza(this.zzavk.bottom, this.zzava)).put("left", zzfa.zza(this.zzavk.left, this.zzava)).put("right", zzfa.zza(this.zzavk.right, this.zzava))).put("adBox", (Object)new JSONObject().put("top", zzfa.zza(rect.top, this.zzava)).put("bottom", zzfa.zza(rect.bottom, this.zzava)).put("left", zzfa.zza(rect.left, this.zzava)).put("right", zzfa.zza(rect.right, this.zzava))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzfa.zza(rect2.top, this.zzava)).put("bottom", zzfa.zza(rect2.bottom, this.zzava)).put("left", zzfa.zza(rect2.left, this.zzava)).put("right", zzfa.zza(rect2.right, this.zzava))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzfa.zza(rect3.top, this.zzava)).put("bottom", zzfa.zza(rect3.bottom, this.zzava)).put("left", zzfa.zza(rect3.left, this.zzava)).put("right", zzfa.zza(rect3.right, this.zzava))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzfa.zza(rect4.top, this.zzava)).put("bottom", zzfa.zza(rect4.bottom, this.zzava)).put("left", zzfa.zza(rect4.left, this.zzava)).put("right", zzfa.zza(rect4.right, this.zzava))).put("screenDensity", (double)this.zzava.density);
        if (bl == null) {
            bl = zzbv.zzea().zza(view, this.zzauy, this.zzauz);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzauy.isInteractive();
        }
        return this.zzauy.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzj(1);
    }

    public final void onGlobalLayout() {
        this.zzj(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfh zzfh2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzavb = zzfh2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzavd = true;
            this.zzj(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzara = true;
            this.zzj(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzara = false;
            this.zzj(3);
            return;
        }
    }
}

