/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzajf;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzwo;
import com.google.android.gms.internal.zzwx;
import com.google.android.gms.internal.zzwy;
import com.google.android.gms.internal.zzzn;
import java.util.Map;
import java.util.Set;

@zzzn
public final class zzwn
extends zzwx {
    private static Set<String> zzcdt = zze.zzb((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzcdu = "top-right";
    private boolean zzcdv = true;
    private int zzcdw = 0;
    private int zzcdx = 0;
    private int zzakq = -1;
    private int zzcdy = 0;
    private int zzcdz = 0;
    private int zzakp = -1;
    private final Object mLock = new Object();
    private final zzakl zzbvz;
    private final Activity zzcdk;
    private zziu zzare;
    private ImageView zzcea;
    private LinearLayout zzceb;
    private zzwy zzcec;
    private PopupWindow zzced;
    private RelativeLayout zzcee;
    private ViewGroup zzcef;

    public zzwn(zzakl zzakl2, zzwy zzwy2) {
        super(zzakl2, "resize");
        this.zzbvz = zzakl2;
        this.zzcdk = zzakl2.zzsa();
        this.zzcec = zzwy2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzcdk == null) {
                this.zzbm("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbvz.zzbk() == null) {
                this.zzbm("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbvz.zzbk().zzbcw) {
                this.zzbm("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbvz.zzsi()) {
                this.zzbm("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzwn zzwn2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbv.zzea();
                zzwn2.zzakp = zzahg.zzch(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbv.zzea();
                zzwn2.zzakq = zzahg.zzch(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbv.zzea();
                zzwn2.zzcdy = zzahg.zzch(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbv.zzea();
                zzwn2.zzcdz = zzahg.zzch(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzwn2.zzcdv = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzwn2.zzcdu = string2;
            }
            zzwn2 = this;
            if (!(zzwn2.zzakp >= 0 && zzwn2.zzakq >= 0)) {
                this.zzbm("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzcdk.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbm("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzmh();
            if (nArray == null) {
                this.zzbm("Resize location out of screen or close button is not visible.");
                return;
            }
            zzjh.zzhu();
            int n = zzajf.zzc((Context)this.zzcdk, (int)this.zzakp);
            zzjh.zzhu();
            int n2 = zzajf.zzc((Context)this.zzcdk, (int)this.zzakq);
            zzakl zzakl2 = this.zzbvz;
            if (zzakl2 == null) {
                throw null;
            }
            ViewParent viewParent = ((View)zzakl2).getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                zzakl zzakl3 = this.zzbvz;
                if (zzakl3 == null) {
                    throw null;
                }
                ((ViewGroup)viewParent).removeView((View)zzakl3);
                if (this.zzced == null) {
                    this.zzcef = (ViewGroup)viewParent;
                    zzbv.zzea();
                    zzakl zzakl4 = this.zzbvz;
                    if (zzakl4 == null) {
                        throw null;
                    }
                    bitmap = zzahg.zzl((View)zzakl4);
                    this.zzcea = new ImageView((Context)this.zzcdk);
                    this.zzcea.setImageBitmap(bitmap);
                    this.zzare = this.zzbvz.zzbk();
                    this.zzcef.addView((View)this.zzcea);
                } else {
                    this.zzced.dismiss();
                }
            } else {
                this.zzbm("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzcee = new RelativeLayout((Context)this.zzcdk);
            this.zzcee.setBackgroundColor(0);
            this.zzcee.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbv.zzea();
            this.zzced = zzahg.zza((View)this.zzcee, n, n2, false);
            this.zzced.setOutsideTouchable(true);
            this.zzced.setTouchable(true);
            this.zzced.setClippingEnabled(!this.zzcdv);
            zzakl zzakl5 = this.zzbvz;
            if (zzakl5 == null) {
                throw null;
            }
            this.zzcee.addView((View)zzakl5, -1, -1);
            this.zzceb = new LinearLayout((Context)this.zzcdk);
            zzjh.zzhu();
            int n3 = zzajf.zzc((Context)this.zzcdk, (int)50);
            zzjh.zzhu();
            bitmap = new RelativeLayout.LayoutParams(n3, zzajf.zzc((Context)this.zzcdk, (int)50));
            switch (this.zzcdu) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzceb.setOnClickListener((View.OnClickListener)new zzwo(this));
            this.zzceb.setContentDescription((CharSequence)"Close button");
            this.zzcee.addView((View)this.zzceb, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzjh.zzhu();
                int n4 = zzajf.zzc((Context)this.zzcdk, (int)nArray[0]);
                zzjh.zzhu();
                this.zzced.showAtLocation(view, 0, n4, zzajf.zzc((Context)this.zzcdk, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzbm(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                zzakl zzakl6 = this.zzbvz;
                if (zzakl6 == null) {
                    throw null;
                }
                this.zzcee.removeView((View)zzakl6);
                if (this.zzcef != null) {
                    this.zzcef.removeView((View)this.zzcea);
                    zzakl zzakl7 = this.zzbvz;
                    if (zzakl7 == null) {
                        throw null;
                    }
                    this.zzcef.addView((View)zzakl7);
                    this.zzbvz.zza(this.zzare);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzwn2 = this;
            if (zzwn2.zzcec != null) {
                zzwn2.zzcec.zza(n6, n5, zzwn2.zzakp, zzwn2.zzakq);
            }
            this.zzbvz.zza(new zziu((Context)this.zzcdk, new AdSize(this.zzakp, this.zzakq)));
            this.zza(nArray[0], nArray[1]);
            this.zzbo("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzl(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzced != null) {
                this.zzced.dismiss();
                zzakl zzakl2 = this.zzbvz;
                if (zzakl2 == null) {
                    throw null;
                }
                this.zzcee.removeView((View)zzakl2);
                if (this.zzcef != null) {
                    this.zzcef.removeView((View)this.zzcea);
                    zzakl zzakl3 = this.zzbvz;
                    if (zzakl3 == null) {
                        throw null;
                    }
                    this.zzcef.addView((View)zzakl3);
                    this.zzbvz.zza(this.zzare);
                }
                if (bl) {
                    this.zzbo("default");
                    if (this.zzcec != null) {
                        this.zzcec.zzcm();
                    }
                }
                this.zzced = null;
                this.zzcee = null;
                this.zzcef = null;
                this.zzceb = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzmh() {
        zzwn zzwn2 = this;
        int[] nArray = zzbv.zzea().zzg(zzwn2.zzcdk);
        int[] nArray2 = zzbv.zzea().zzh(zzwn2.zzcdk);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzwn2.zzakp < 50 || zzwn2.zzakp > n) {
            zzafy.zzcr((String)"Width is too small or too large.");
            return null;
        }
        if (zzwn2.zzakq < 50 || zzwn2.zzakq > n2) {
            zzafy.zzcr((String)"Height is too small or too large.");
            return null;
        }
        if (zzwn2.zzakq == n2 && zzwn2.zzakp == n) {
            zzafy.zzcr((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzwn2.zzcdv) {
            int n3;
            int n4;
            switch (zzwn2.zzcdu) {
                case "top-left": {
                    n4 = zzwn2.zzcdw + zzwn2.zzcdy;
                    n3 = zzwn2.zzcdx + zzwn2.zzcdz;
                    break;
                }
                case "top-center": {
                    n4 = zzwn2.zzcdw + zzwn2.zzcdy + zzwn2.zzakp / 2 - 25;
                    n3 = zzwn2.zzcdx + zzwn2.zzcdz;
                    break;
                }
                case "center": {
                    n4 = zzwn2.zzcdw + zzwn2.zzcdy + zzwn2.zzakp / 2 - 25;
                    n3 = zzwn2.zzcdx + zzwn2.zzcdz + zzwn2.zzakq / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzwn2.zzcdw + zzwn2.zzcdy;
                    n3 = zzwn2.zzcdx + zzwn2.zzcdz + zzwn2.zzakq - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzwn2.zzcdw + zzwn2.zzcdy + zzwn2.zzakp / 2 - 25;
                    n3 = zzwn2.zzcdx + zzwn2.zzcdz + zzwn2.zzakq - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzwn2.zzcdw + zzwn2.zzcdy + zzwn2.zzakp - 50;
                    n3 = zzwn2.zzcdx + zzwn2.zzcdz + zzwn2.zzakq - 50;
                    break;
                }
                default: {
                    n4 = zzwn2.zzcdw + zzwn2.zzcdy + zzwn2.zzakp - 50;
                    n3 = zzwn2.zzcdx + zzwn2.zzcdz;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzcdv) {
            return new int[]{this.zzcdw + this.zzcdy, this.zzcdx + this.zzcdz};
        }
        int[] nArray3 = zzbv.zzea().zzg(this.zzcdk);
        int[] nArray4 = zzbv.zzea().zzh(this.zzcdk);
        int n5 = nArray3[0];
        int n6 = this.zzcdw + this.zzcdy;
        int n7 = this.zzcdx + this.zzcdz;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzakp > n5) {
            n6 = n5 - this.zzakp;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzakq <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzakq;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcdw = n;
            this.zzcdx = n2;
            if (this.zzced != null && bl) {
                int[] nArray = this.zzmh();
                if (nArray != null) {
                    zzjh.zzhu();
                    int n3 = zzajf.zzc((Context)this.zzcdk, (int)nArray[0]);
                    zzjh.zzhu();
                    this.zzced.update(n3, zzajf.zzc((Context)this.zzcdk, (int)nArray[1]), this.zzced.getWidth(), this.zzced.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzl(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbv.zzea().zzh(this.zzcdk)[0];
        this.zzb(n, n2 - n3, this.zzakp, this.zzakq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzmi() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzced != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzcdw = n;
        this.zzcdx = n2;
    }
}

