/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzahu;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzahx;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzmw;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznd;
import com.google.android.gms.internal.zzzb;
import java.util.concurrent.TimeUnit;

@zzzb
public final class zzalj {
    private final Context mContext;
    private final String zzcqb;
    private final zzaiy zzaqi;
    @Nullable
    private final zznb zzdgr;
    @Nullable
    private final zznd zzdeh;
    private final zzahu zzdgs = new zzahx().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zzql();
    private final long[] zzdgt;
    private final String[] zzdgu;
    private boolean zzdgv = false;
    private boolean zzdgw = false;
    private boolean zzdgx = false;
    private boolean zzdgy = false;
    private boolean zzdel;
    private zzaku zzdgz;
    private boolean zzdha;
    private boolean zzdhb;
    private long zzdhc = -1L;

    public zzalj(Context context, zzaiy zzaiy2, String string2, @Nullable zznd zznd2, @Nullable zznb zznb2) {
        this.mContext = context;
        this.zzaqi = zzaiy2;
        this.zzcqb = string2;
        this.zzdeh = zznd2;
        this.zzdgr = zznb2;
        zzmg<String> zzmg2 = zzmq.zzbgx;
        String string3 = zzbs.zzep().zzd(zzmg2);
        if (string3 == null) {
            this.zzdgu = new String[0];
            this.zzdgt = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string3, (String)",");
        this.zzdgu = new String[stringArray.length];
        this.zzdgt = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzdgt[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzafj.zzc((String)"Unable to parse frame hash target time number.", (Throwable)numberFormatException);
                this.zzdgt[i] = -1L;
            }
        }
    }

    public final void zza(zzaku zzaku2) {
        zzmw.zza(this.zzdeh, this.zzdgr, "vpc2");
        this.zzdgv = true;
        if (this.zzdeh != null) {
            this.zzdeh.zzf("vpn", zzaku2.zzqz());
        }
        this.zzdgz = zzaku2;
    }

    public final void zzrf() {
        if (!this.zzdgv || this.zzdgw) {
            return;
        }
        zzmw.zza(this.zzdeh, this.zzdgr, "vfr2");
        this.zzdgw = true;
    }

    public final void onStop() {
        zzmg<Boolean> zzmg2 = zzmq.zzbgw;
        if (zzbs.zzep().zzd(zzmg2).booleanValue() && !this.zzdha) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzcqb);
            bundle.putString("player", this.zzdgz.zzqz());
            for (zzahw object : this.zzdgs.getBuckets()) {
                String string2 = String.valueOf("fps_c_");
                String string3 = String.valueOf(object.name);
                bundle.putString(string3.length() != 0 ? string2.concat(string3) : new String(string2), Integer.toString(object.count));
                String string4 = String.valueOf("fps_p_");
                String string5 = String.valueOf(object.name);
                bundle.putString(string5.length() != 0 ? string4.concat(string5) : new String(string4), Double.toString(object.zzdam));
            }
            for (int i = 0; i < this.zzdgt.length; ++i) {
                String string6 = this.zzdgu[i];
                if (string6 == null) continue;
                String string7 = "fh_";
                String string8 = String.valueOf((Object)this.zzdgt[i]);
                bundle.putString(new StringBuilder(String.valueOf(string7).length() + String.valueOf(string8).length()).append(string7).append(string8).toString(), string6);
            }
            zzbs.zzec().zza(this.mContext, this.zzaqi.zzcp, "gmob-apps", bundle, true);
            this.zzdha = true;
        }
    }

    public final void zzb(zzaku zzaku2) {
        zzalj zzalj2 = this;
        if (zzalj2.zzdgx && !zzalj2.zzdgy) {
            zzmw.zza(zzalj2.zzdeh, zzalj2.zzdgr, "vff2");
            zzalj2.zzdgy = true;
        }
        long l = zzbs.zzei().nanoTime();
        if (zzalj2.zzdel && zzalj2.zzdhb && zzalj2.zzdhc != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - zzalj2.zzdhc);
            zzalj2.zzdgs.zza(d);
        }
        zzalj2.zzdhb = zzalj2.zzdel;
        zzalj2.zzdhc = l;
        zzaku zzaku3 = zzaku2;
        zzalj2 = this;
        zzmg<Long> zzmg2 = zzmq.zzbgy;
        long l2 = zzbs.zzep().zzd(zzmg2);
        long l3 = zzaku3.getCurrentPosition();
        for (int i = 0; i < zzalj2.zzdgu.length; ++i) {
            long l4;
            if (zzalj2.zzdgu[i] != null || l2 <= Math.abs(l3 - (l4 = zzalj2.zzdgt[i]))) continue;
            String[] stringArray = zzalj2.zzdgu;
            Bitmap bitmap = zzaku3.getBitmap(8, 8);
            long l5 = 0L;
            long l6 = 63L;
            for (int j = 0; j < 8; ++j) {
                int n = 0;
                while (n < 8) {
                    int n2 = bitmap.getPixel(n, j);
                    long l7 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2) > 128 ? 1L : 0L;
                    l5 |= l7 << (int)l6;
                    ++n;
                    --l6;
                }
            }
            stringArray[i] = String.format("%016X", l5);
            return;
        }
    }

    public final void zzse() {
        this.zzdel = true;
        if (this.zzdgw && !this.zzdgx) {
            zzmw.zza(this.zzdeh, this.zzdgr, "vfp2");
            this.zzdgx = true;
        }
    }

    public final void zzsf() {
        this.zzdel = false;
    }
}

