/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzaiq;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzakw;
import com.google.android.gms.internal.zzakz;
import com.google.android.gms.internal.zzalh;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzzb;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@zzzb
public final class zzalo
implements zzt<zzali> {
    private boolean zzdhi;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzjk.zzhx();
                n2 = zzais.zzc((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzafj.zzco((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    private static void zza(zzakw zzakw2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        try {
            if (string2 != null) {
                Integer.parseInt(string2);
            }
            if (string3 != null) {
                Integer.parseInt(string3);
            }
            if (string4 != null) {
                Integer.parseInt(string4);
            }
            if (string5 != null) {
                Integer.parseInt(string5);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzafj.zzco((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        Object object2;
        Object object3;
        Map map2 = map;
        zzali zzali2 = (zzali)object;
        zzalo zzalo2 = this;
        String string2 = (String)map2.get("action");
        if (string2 == null) {
            zzafj.zzco((String)"Action missing from video GMSG.");
            return;
        }
        if (zzafj.zzae((int)3)) {
            object3 = new JSONObject(map2);
            object3.remove("google.afma.Notify_dt");
            object2 = object3.toString();
            zzafj.zzbw((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object2).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object2).toString());
        }
        if ("background".equals(string2)) {
            object3 = (String)map2.get("color");
            if (TextUtils.isEmpty((CharSequence)object3)) {
                zzafj.zzco((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object3);
                zzali2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzafj.zzco((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object3 = (String)map2.get("mimeTypes");
            if (object3 == null) {
                zzafj.zzco((String)"No MIME types specified for decoder properties inspection.");
                zzakw.zza(zzali2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzafj.zzco((String)"Video decoder properties available on API versions >= 16.");
                zzakw.zza(zzali2, "deficientApiVersion");
                return;
            }
            object2 = new HashMap();
            for (String string3 : ((String)object3).split(",")) {
                object2.put(string3, zzaiq.zzck(string3.trim()));
            }
            zzakw.zza(zzali2, (Map<String, List<Map<String, Object>>>)object2);
            return;
        }
        object3 = zzali2.zzrw();
        if (object3 == null) {
            zzafj.zzco((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzali2.getContext();
            int n2 = zzalo.zza(context, map2, "x", 0);
            int n3 = zzalo.zza(context, map2, "y", 0);
            int n4 = zzalo.zza(context, map2, "w", -1);
            int n5 = zzalo.zza(context, map2, "h", -1);
            zzmg<Boolean> zzmg2 = zzmq.zzbnc;
            if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
                n4 = Math.min(n4, zzali2.zzsd() - n2);
                n5 = Math.min(n5, zzali2.zzsc() - n3);
            }
            try {
                n = Integer.parseInt((String)map2.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean((String)map2.get("spherical"));
            if (bl && ((zzakz)object3).zzrr() == null) {
                zzalh zzalh2 = new zzalh((String)map2.get("flags"));
                ((zzakz)object3).zza(n2, n3, n4, n5, n, bl3, zzalh2);
                zzakw zzakw2 = ((zzakz)object3).zzrr();
                if (zzakw2 != null) {
                    zzalo.zza(zzakw2, map2);
                }
                return;
            }
            ((zzakz)object3).zze(n2, n3, n4, n5);
            return;
        }
        zzakw zzakw3 = ((zzakz)object3).zzrr();
        if (zzakw3 == null) {
            zzakw.zza(zzali2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzali2.getContext();
            int n = zzalo.zza(context, map2, "x", 0);
            int n6 = zzalo.zza(context, map2, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzakw3.zzf(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string4 = (String)map2.get("time");
            if (string4 == null) {
                zzafj.zzco((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string4) * 1000.0f);
                zzakw3.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = String.valueOf(string4);
                zzafj.zzco((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzakw3.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzakw3.zzrk();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzalo.zza(zzakw3, map2);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean((String)map2.get("muted"))) {
                zzakw3.zzrl();
                return;
            }
            zzakw3.zzrm();
            return;
        }
        if ("pause".equals(string2)) {
            zzakw3.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzakw3.play();
            return;
        }
        if ("show".equals(string2)) {
            zzakw3.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            zzakw3.zzcp((String)map2.get("src"));
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzali2.getContext();
            int n = zzalo.zza(context, map2, "dx", 0);
            int n7 = zzalo.zza(context, map2, "dy", 0);
            zzakw3.zza(n, n7);
            if (!zzalo2.zzdhi) {
                zzali2.zzmu();
                zzalo2.zzdhi = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string6 = (String)map2.get("volume");
            if (string6 == null) {
                zzafj.zzco((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string6);
                zzakw3.zzb(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzafj.zzco((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzakw3.zzrn();
            return;
        }
        String string8 = String.valueOf(string2);
        zzafj.zzco((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
    }
}

