/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.gmsg.zzt;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzbl;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzair;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzakg;
import com.google.android.gms.internal.zzakz;
import com.google.android.gms.internal.zzals;
import com.google.android.gms.internal.zzalt;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzamp;
import com.google.android.gms.internal.zzamq;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzano;
import com.google.android.gms.internal.zzanp;
import com.google.android.gms.internal.zzcs;
import com.google.android.gms.internal.zzgb;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzmw;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznc;
import com.google.android.gms.internal.zznd;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzwg;
import com.google.android.gms.internal.zzzb;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzb
final class zzamo
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzama {
    private final zzano zzdjd;
    private final Object mLock = new Object();
    @Nullable
    private final zzcs zzbta;
    private final zzaiy zzaov;
    private final zzbl zzdje;
    private final zzv zzamw;
    private zzamb zzdjf;
    private zzd zzdjg;
    private zzanp zzdjh;
    private String zzaky;
    private boolean zzdji;
    private boolean zzdjj;
    private boolean zzdjk;
    private boolean zzdjl;
    private Boolean zzcxg;
    private int zzdjm;
    private boolean zzdjn = true;
    private boolean zzdjo = false;
    private String zzcqb = "";
    private zzamr zzdjp;
    private boolean zzdjq;
    private boolean zzdjr;
    private zzny zzdjs;
    private int zzdjt;
    private int zzdju;
    private zznb zzdjv;
    private zznb zzdgr;
    private zznb zzdjw;
    private zznc zzdjx;
    private WeakReference<View.OnClickListener> zzdjy;
    private zzd zzdjz;
    private boolean zzdka;
    private zzair zzaun;
    private int zzcfx = -1;
    private int zzcfw = -1;
    private int zzcfz = -1;
    private int zzcga = -1;
    private Map<String, zzalt> zzdkb;
    private final WindowManager zzavc;
    private final zzib zzckz;

    static zzamo zzb(Context context, zzanp zzanp2, String string2, boolean bl, boolean bl2, @Nullable zzcs zzcs2, zzaiy zzaiy2, zznd zznd2, zzbl zzbl2, zzv zzv2, zzib zzib2) {
        zzano zzano2 = new zzano(context);
        return new zzamo(zzano2, zzanp2, string2, bl, bl2, zzcs2, zzaiy2, zznd2, zzbl2, zzv2, zzib2);
    }

    private zzamo(zzano zzano2, zzanp zzanp2, String string2, boolean bl, boolean bl2, @Nullable zzcs zzcs2, zzaiy zzaiy2, zznd zznd2, zzbl zzbl2, zzv zzv2, zzib zzib2) {
        super((Context)zzano2);
        this.zzdjd = zzano2;
        this.zzdjh = zzanp2;
        this.zzaky = string2;
        this.zzdjk = bl;
        this.zzdjm = -1;
        this.zzbta = zzcs2;
        this.zzaov = zzaiy2;
        this.zzdje = zzbl2;
        this.zzamw = zzv2;
        this.zzavc = (WindowManager)this.getContext().getSystemService("window");
        this.zzckz = zzib2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzafj.zzb((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        WebSettings webSettings2 = webSettings;
        String string3 = zzaiy2.zzcp;
        Object object = zzano2;
        Object object2 = zzbs.zzec();
        webSettings2.setUserAgentString(((zzagr)object2).zzp((Context)object, string3));
        zzbs.zzee().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzts();
        if (zzq.zzaly()) {
            this.addJavascriptInterface(new zzamu(this), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzaun = new zzair(this.zzdjd.zzrz(), (View)this, this, null);
        object = zznd2;
        object2 = this;
        ((zzamo)object2).zztv();
        ((zzamo)object2).zzdjx = new zznc(new zznd(true, "make_wv", ((zzamo)object2).zzaky));
        ((zzamo)object2).zzdjx.zziy().zzc((zznd)object);
        ((zzamo)object2).zzdgr = zzmw.zzb(((zzamo)object2).zzdjx.zziy());
        ((zzamo)object2).zzdjx.zza("native:view_create", ((zzamo)object2).zzdgr);
        ((zzamo)object2).zzdjw = null;
        ((zzamo)object2).zzdjv = null;
        zzbs.zzee().zzaw((Context)zzano2);
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzamb) {
            this.zzdjf = (zzamb)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final zzv zzbk() {
        return this.zzamw;
    }

    private final boolean zztq() {
        int n;
        int n2;
        if (!this.zzdjf.zzfr() && !this.zzdjf.zzte()) {
            return false;
        }
        zzbs.zzec();
        DisplayMetrics displayMetrics = zzagr.zza(this.zzavc);
        zzjk.zzhx();
        int n3 = zzais.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzjk.zzhx();
        int n4 = zzais.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.heightPixels);
        Activity activity = this.zzdjd.zzrz();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbs.zzec();
            int[] nArray = zzagr.zzf(activity);
            zzjk.zzhx();
            n2 = zzais.zzb((DisplayMetrics)displayMetrics, (int)nArray[0]);
            zzjk.zzhx();
            n = zzais.zzb((DisplayMetrics)displayMetrics, (int)nArray[1]);
        }
        if (this.zzcfw == n3 && this.zzcfx == n4 && this.zzcfz == n2 && this.zzcga == n) {
            return false;
        }
        boolean bl = this.zzcfw != n3 || this.zzcfx != n4;
        this.zzcfw = n3;
        this.zzcfx = n4;
        this.zzcfz = n2;
        this.zzcga = n;
        new zzwg(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzavc.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzbs.zzec().zzp(map);
        }
        catch (JSONException jSONException) {
            zzafj.zzco((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zza(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public final void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzafj.zzco((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzcv(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzafj.zzco((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadUrl(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
                    zzbs.zzeg().zza(throwable, "AdWebViewImpl.loadUrl");
                    zzafj.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
                }
            } else {
                zzafj.zzco((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzct(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
                zzbs.zzeg().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
                zzafj.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadData(String string2, String string3, String string4) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzafj.zzco((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzafj.zzco((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzcw(String string2) {
        if (zzq.zzama()) {
            Object object;
            zzamo zzamo2;
            if (this.zzpa() == null) {
                zzamo2 = this;
                object = zzamo2.mLock;
                synchronized (object) {
                    zzamo2.zzcxg = zzbs.zzeg().zzpa();
                    if (zzamo2.zzcxg == null) {
                        try {
                            String string3 = "(function(){})()";
                            zzamo2.evaluateJavascript(string3, null);
                            zzamo2.zza(true);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzamo2.zza(false);
                        }
                    }
                }
            }
            if (this.zzpa().booleanValue()) {
                object = string2;
                zzamo2 = this;
                Object object2 = zzamo2.mLock;
                synchronized (object2) {
                    if (!zzamo2.isDestroyed()) {
                        zzamo2.evaluateJavascript((String)object, null);
                    } else {
                        zzafj.zzco((String)"The webview is destroyed. Ignoring action.");
                    }
                    return;
                }
            }
            String string4 = String.valueOf(string2);
            this.zzcv(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
            return;
        }
        String string5 = String.valueOf(string2);
        this.zzcv(string5.length() != 0 ? "javascript:".concat(string5) : new String("javascript:"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcxg = bl;
        }
        zzbs.zzeg().zza(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Boolean zzpa() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcxg;
        }
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        String string3;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string4 = string3 = jSONObject.toString();
        String string5 = string2;
        zzamo zzamo2 = this;
        String string6 = new StringBuilder(3 + String.valueOf(string5).length() + String.valueOf(string4).length()).append(string5).append("(").append(string4).append(");").toString();
        zzamo2.zzcw(string6);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzafj.zzbw((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzcw(stringBuilder.toString());
    }

    @Override
    public final void zzsj() {
        this.zztr();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzaov.zzcp);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzag(int n) {
        if (n == 0) {
            zzamo zzamo2 = this;
            zzmw.zza(zzamo2.zzdjx.zziy(), zzamo2.zzdgr, "aebb2");
        }
        this.zztr();
        if (this.zzdjx.zziy() != null) {
            this.zzdjx.zziy().zzf("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzaov.zzcp);
        this.zza("onhide", hashMap);
    }

    private final void zztr() {
        zzmw.zza(this.zzdjx.zziy(), this.zzdgr, "aeh2");
    }

    @Override
    public final void zzmt() {
        if (this.zzdjv == null) {
            zzmw.zza(this.zzdjx.zziy(), this.zzdgr, "aes2");
            this.zzdjv = zzmw.zzb(this.zzdjx.zziy());
            this.zzdjx.zza("native:view_show", this.zzdjv);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzaov.zzcp);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zzsk() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        zzbs.zzec();
        hashMap.put("app_muted", String.valueOf(zzagr.zzdi()));
        zzbs.zzec();
        hashMap.put("app_volume", String.valueOf(zzagr.zzdh()));
        zzbs.zzec();
        hashMap.put("device_volume", String.valueOf(zzagr.zzap(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzd zzsm() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzd zzsn() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzanp zzso() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String zzsp() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaky;
        }
    }

    @Override
    public final zzamb zzsq() {
        return this.zzdjf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsr() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdji;
        }
    }

    @Override
    public final zzcs zzss() {
        return this.zzbta;
    }

    @Override
    public final zzaiy zzsb() {
        return this.zzaov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzst() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjk;
        }
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbs.zzec();
            zzagr.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzafj.zzbw((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzdjf.zzte()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.zzdjs != null) {
                    this.zzdjs.zzc(motionEvent);
                }
            }
        } else if (this.zzbta != null) {
            this.zzbta.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzmg<Boolean> zzmg2 = zzmq.zzbjm;
        if (zzbs.zzep().zzd(zzmg2).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected final void onMeasure(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzdjk || this.zzdjh.zzty()) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzdjh.isFluid()) {
                int n3;
                Object object2 = zzmq.zzbnf;
                if (zzbs.zzep().zzd(object2).booleanValue() || !zzq.zzaly()) {
                    super.onMeasure(n, n2);
                    return;
                }
                object2 = this;
                this.zza("/contentHeight", new zzamp((zzamo)object2));
                String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
                this.zzcw(string2);
                float f = this.zzdjd.getResources().getDisplayMetrics().density;
                int n4 = View.MeasureSpec.getSize((int)n);
                switch (this.zzdju) {
                    case -1: {
                        n3 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n3 = (int)((float)this.zzdju * f);
                    }
                }
                this.setMeasuredDimension(n4, n3);
                return;
            }
            if (this.zzdjh.zztx()) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzavc.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            int n9 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n9 = n6;
            }
            int n10 = Integer.MAX_VALUE;
            if (n7 == Integer.MIN_VALUE || n7 == 0x40000000) {
                n10 = n8;
            }
            if (this.zzdjh.widthPixels > n9 || this.zzdjh.heightPixels > n10) {
                float f = this.zzdjd.getResources().getDisplayMetrics().density;
                int n11 = (int)((float)this.zzdjh.widthPixels / f);
                int n12 = (int)((float)this.zzdjh.heightPixels / f);
                int n13 = (int)((float)n6 / f);
                int n14 = (int)((float)n8 / f);
                zzafj.zzco((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n11).append("x").append(n12).append(" dp, but only has ").append(n13).append("x").append(n14).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzdjh.widthPixels, this.zzdjh.heightPixels);
            }
            return;
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zztq();
        zzd zzd2 = this.zzsm();
        if (zzd2 != null && bl) {
            zzd2.zzms();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zzd zzd2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjg = zzd2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(zzd zzd2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjz = zzd2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzanp zzanp2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjh = zzanp2;
            this.requestLayout();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzac(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl2 = bl != this.zzdjk;
            this.zzdjk = bl;
            this.zzts();
            if (bl2) {
                new zzwg(this).zzbn(bl ? "expanded" : "default");
            }
            return;
        }
    }

    @Override
    public final void zzsy() {
        this.zzaun.zzqo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onAttachedToWindow() {
        Object object = this.mLock;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzaun.onAttachedToWindow();
            }
            boolean bl = this.zzdjq;
            if (this.zzdjf != null && this.zzdjf.zzte()) {
                bl = true;
                if (!this.zzdjr) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdjf.zztf();
                    if (onGlobalLayoutListener != null) {
                        zzbs.zzez();
                        zzamo zzamo2 = this;
                        if (zzamo2 == null) {
                            throw null;
                        }
                        zzakg.zza((View)zzamo2, onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzdjf.zztg()) != null) {
                        zzbs.zzez();
                        zzamo zzamo3 = this;
                        if (zzamo3 == null) {
                            throw null;
                        }
                        zzakg.zza((View)zzamo3, onScrollChangedListener);
                    }
                    this.zzdjr = true;
                }
                this.zztq();
            }
            this.zzag(bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzaun.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzdjr && this.zzdjf != null && this.zzdjf.zzte() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdjf.zztf();
                if (onGlobalLayoutListener != null) {
                    zzbs.zzee().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdjf.zztg()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzdjr = false;
            }
        }
        this.zzag(false);
    }

    @Override
    public final void setContext(Context context) {
        this.zzdjd.setBaseContext(context);
        this.zzaun.zzi(this.zzdjd.zzrz());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzad(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdjg != null) {
                this.zzdjg.zza(this.zzdjf.zzfr(), bl);
            } else {
                this.zzdji = bl;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getRequestedOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setRequestedOrientation(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjm = n;
            if (this.zzdjg != null) {
                this.zzdjg.setRequestedOrientation(this.zzdjm);
            }
            return;
        }
    }

    @Override
    public final Activity zzrz() {
        return this.zzdjd.zzrz();
    }

    @Override
    public final Context zzsl() {
        return this.zzdjd.zzsl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzts() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdjk || this.zzdjh.zztx()) {
                zzafj.zzbw((String)"Enabling hardware acceleration on an overlay.");
                this.zztt();
            } else if (Build.VERSION.SDK_INT < 18) {
                zzafj.zzbw((String)"Disabling hardware acceleration on an AdView.");
                zzamo zzamo2 = this;
                Object object2 = zzamo2.mLock;
                synchronized (object2) {
                    if (!zzamo2.zzdjl) {
                        zzbs.zzee().zzt((View)zzamo2);
                    }
                    zzamo2.zzdjl = true;
                }
            } else {
                zzafj.zzbw((String)"Enabling hardware acceleration on an AdView.");
                this.zztt();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zztt() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdjl) {
                zzbs.zzee().zzs((View)this);
            }
            this.zzdjl = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.zztv();
            this.zzaun.zzqp();
            if (this.zzdjg != null) {
                this.zzdjg.close();
                this.zzdjg.onDestroy();
                this.zzdjg = null;
            }
            this.zzdjf.reset();
            if (this.zzdjj) {
                return;
            }
            zzbs.zzey();
            zzals.zzb(this);
            this.zztu();
            this.zzdjj = true;
            zzafj.v("Initiating WebView self destruct sequence in 3...");
            this.zzdjf.zzti();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            if (this.mLock != null) {
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.zzdjj) {
                        this.zzdjf.reset();
                        zzbs.zzey();
                        zzals.zzb(this);
                        this.zztu();
                        this.zzpo();
                    }
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzsu() {
        Object object = this.mLock;
        synchronized (object) {
            zzafj.v("Destroying WebView!");
            this.zzpo();
            zzagr.zzczc.post((Runnable)new zzamq(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzpo() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzdka) {
                this.zzdka = true;
                zzbs.zzeg().zzpo();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjj;
        }
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzdjf != null && this.zzdjf.zztp() != null) {
            this.zzdjf.zztp().zzcv();
        }
    }

    @Override
    public final void zzsz() {
        if (this.zzdjw == null) {
            this.zzdjw = zzmw.zzb(this.zzdjx.zziy());
            this.zzdjx.zza("native:view_load", this.zzdjw);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zztc() {
        zzafj.v("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzafj.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzae(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjn = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsv() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzck() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjo = true;
            if (this.zzdje != null) {
                this.zzdje.zzck();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcl() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjo = false;
            if (this.zzdje != null) {
                this.zzdje.zzcl();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zztu() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdkb = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcu(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcqb = string2 == null ? "" : string2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getRequestId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcqb;
        }
    }

    @Override
    public final zzakz zzrw() {
        return null;
    }

    @Override
    public final zznb zzry() {
        return this.zzdgr;
    }

    @Override
    public final zznc zzsa() {
        return this.zzdjx;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzdjy = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener getOnClickListener() {
        return (View.OnClickListener)this.zzdjy.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zzny zzny2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjs = zzny2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzny zzta() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzamr zzrx() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzamr zzamr2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdjp != null) {
                zzafj.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzdjp = zzamr2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsx() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdjt > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaf(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjt += bl ? 1 : -1;
            if (this.zzdjt <= 0 && this.zzdjg != null) {
                this.zzdjg.zzmv();
            }
            return;
        }
    }

    private final void zztv() {
        if (this.zzdjx == null) {
            return;
        }
        zznd zznd2 = this.zzdjx.zziy();
        if (zznd2 != null && zzbs.zzeg().zzow() != null) {
            zzbs.zzeg().zzow().zza(zznd2);
        }
    }

    @Override
    public final void zztb() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzab(boolean bl) {
        this.zzdjf.zzab(bl);
    }

    @Override
    public final void zzmu() {
        zzd zzd2 = this.zzsm();
        if (zzd2 != null) {
            zzd2.zzmu();
        }
    }

    @Override
    public final int zzsc() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzsd() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzdjf.zza(zzc2);
    }

    @Override
    public final void zza(boolean bl, int n) {
        this.zzdjf.zza(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzdjf.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzdjf.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzgb zzgb2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdjq = zzgb2.zzaxe;
        }
        this.zzag(zzgb2.zzaxe);
    }

    private final void zzag(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzt<? super zzama> zzt2) {
        if (this.zzdjf != null) {
            this.zzdjf.zza(string2, zzt2);
        }
    }

    @Override
    public final void zzb(String string2, zzt<? super zzama> zzt2) {
        if (this.zzdjf != null) {
            this.zzdjf.zzb(string2, zzt2);
        }
    }

    static /* synthetic */ Object zza(zzamo zzamo2) {
        return zzamo2.mLock;
    }

    static /* synthetic */ int zzb(zzamo zzamo2) {
        return zzamo2.zzdju;
    }

    static /* synthetic */ int zza(zzamo zzamo2, int n) {
        zzamo2.zzdju = n;
        return zzamo2.zzdju;
    }

    static /* synthetic */ void zzc(zzamo zzamo2) {
        super.destroy();
    }
}

